/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm;

import org.gradle.internal.jvm.Jvm;
import org.gradle.util.GradleVersion;

public class UnsupportedJavaRuntimeException
extends RuntimeException {
    public UnsupportedJavaRuntimeException(String message) {
        super(message);
    }

    public static void assertUsingSupportedDaemonVersion() throws UnsupportedJavaRuntimeException {
        UnsupportedJavaRuntimeException.assertIsSupportedDaemonJvmVersion(Jvm.current().getJavaVersionMajor(), "You are currently using Java %d.");
    }

    public static void assertIsSupportedDaemonJvmVersion(int majorVersion) {
        UnsupportedJavaRuntimeException.assertIsSupportedDaemonJvmVersion(majorVersion, "Your build is currently configured to use Java %d.");
    }

    private static void assertIsSupportedDaemonJvmVersion(int majorVersion, String message) {
        if (majorVersion < 8) {
            throw new UnsupportedJavaRuntimeException(String.format("Gradle %s requires Java %d or later to run. " + message, GradleVersion.current().getVersion(), 8, majorVersion));
        }
    }
}

