/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.diagnostics.internal.artifact.transforms.model.ArtifactTransformReportModel;
import org.gradle.api.tasks.diagnostics.internal.artifact.transforms.model.ArtifactTransformReportModelFactory;
import org.gradle.api.tasks.diagnostics.internal.artifact.transforms.renderer.ConsoleArtifactTransformReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.artifact.transforms.spec.ArtifactTransformReportSpec;
import org.gradle.api.tasks.options.Option;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.serialization.Cached;
import org.gradle.work.DisableCachingByDefault;

@Incubating
@DisableCachingByDefault(because="Produces only non-cacheable console output")
public abstract class ArtifactTransformsReportTask
extends DefaultTask {
    private final Cached<ArtifactTransformReportModel> reportModel = Cached.of(() -> this.buildReportModel(this.getProject()));

    @Inject
    protected abstract ObjectFactory getObjectFactory();

    @Inject
    protected abstract StyledTextOutputFactory getTextOutputFactory();

    @Inject
    protected abstract DocumentationRegistry getDocumentationRegistry();

    @Input
    @Optional
    @Option(option="type", description="The type of Transform to report")
    public abstract Property<String> getTransformType();

    @Incubating
    public ArtifactTransformsReportTask() {
    }

    @TaskAction
    public final void report() {
        ArtifactTransformReportSpec reportSpec = this.buildReportSpec();
        ArtifactTransformReportModel model = (ArtifactTransformReportModel)this.reportModel.get();
        this.reportToConsole(reportSpec, model);
    }

    private void reportToConsole(ArtifactTransformReportSpec reportSpec, ArtifactTransformReportModel reportModel) {
        ConsoleArtifactTransformReportRenderer renderer = new ConsoleArtifactTransformReportRenderer(reportSpec, this.getDocumentationRegistry());
        StyledTextOutput output = this.getTextOutputFactory().create(((Object)((Object)this)).getClass());
        renderer.render(reportModel, output);
    }

    private ArtifactTransformReportModel buildReportModel(Project project) {
        ArtifactTransformReportModelFactory factory = (ArtifactTransformReportModelFactory)this.getObjectFactory().newInstance(ArtifactTransformReportModelFactory.class, new Object[0]);
        return factory.buildForProject(project);
    }

    private ArtifactTransformReportSpec buildReportSpec() {
        return new ArtifactTransformReportSpec((String)this.getTransformType().getOrNull());
    }
}

