/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import org.gradle.api.artifacts.component.ModuleComponentIdentifier;

public class ModuleComponentAtRepositoryKey {
    private final String repositoryId;
    private final ModuleComponentIdentifier componentId;
    private final int hashCode;

    ModuleComponentAtRepositoryKey(String repositoryId, ModuleComponentIdentifier componentId) {
        this.repositoryId = repositoryId;
        this.componentId = componentId;
        this.hashCode = 31 * repositoryId.hashCode() + componentId.hashCode();
    }

    public String toString() {
        return this.repositoryId + "," + this.componentId;
    }

    public ModuleComponentIdentifier getComponentId() {
        return this.componentId;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ModuleComponentAtRepositoryKey)) {
            return false;
        }
        ModuleComponentAtRepositoryKey other = (ModuleComponentAtRepositoryKey)o;
        return this.hashCode == other.hashCode && this.repositoryId.equals(other.repositoryId) && this.componentId.equals(other.componentId);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

