/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.gradle.launcher.daemon.server.Daemon;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationResult;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStatus;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStrategy;

public class DaemonIdleTimeoutExpirationStrategy
implements DaemonExpirationStrategy {
    private final Function<?, Long> idleTimeout;
    private final Daemon daemon;
    public static final String EXPIRATION_REASON = "after being idle";

    public DaemonIdleTimeoutExpirationStrategy(Daemon daemon, int idleTimeout, TimeUnit timeUnit) {
        this(daemon, Functions.constant((Object)timeUnit.toMillis(idleTimeout)));
    }

    public DaemonIdleTimeoutExpirationStrategy(Daemon daemon, Function<?, Long> timeoutClosure) {
        this.daemon = daemon;
        this.idleTimeout = (Function)Preconditions.checkNotNull(timeoutClosure);
    }

    @Override
    public DaemonExpirationResult checkExpiration() {
        boolean idleTimeoutExceeded;
        long idleMillis = this.daemon.getStateCoordinator().getIdleMillis();
        boolean bl = idleTimeoutExceeded = idleMillis > (Long)this.idleTimeout.apply(null);
        if (idleTimeoutExceeded) {
            return new DaemonExpirationResult(DaemonExpirationStatus.QUIET_EXPIRE, "after being idle for " + idleMillis / 60000L + " minutes");
        }
        return DaemonExpirationResult.NOT_TRIGGERED;
    }
}

