/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.internal.project.ProjectTaskLister;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.diagnostics.ConventionReportTask;
import org.gradle.api.tasks.diagnostics.internal.AggregateMultiProjectTaskReportModel;
import org.gradle.api.tasks.diagnostics.internal.DefaultGroupTaskReportModel;
import org.gradle.api.tasks.diagnostics.internal.ProjectDetails;
import org.gradle.api.tasks.diagnostics.internal.ReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.RuleDetails;
import org.gradle.api.tasks.diagnostics.internal.SingleProjectTaskReportModel;
import org.gradle.api.tasks.diagnostics.internal.TaskDetails;
import org.gradle.api.tasks.diagnostics.internal.TaskDetailsFactory;
import org.gradle.api.tasks.diagnostics.internal.TaskReportRenderer;
import org.gradle.api.tasks.options.Option;
import org.gradle.internal.Try;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;
import org.gradle.internal.serialization.Cached;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not worth caching")
public abstract class TaskReportTask
extends ConventionReportTask {
    private boolean detail;
    private final Property<Boolean> showTypes = this.getProject().getObjects().property(Boolean.class);
    private String group;
    private List<String> groups;
    private final Cached<TaskReportModel> model = Cached.of(this::computeTaskReportModel);
    private transient TaskReportRenderer renderer;

    @Override
    @ToBeReplacedByLazyProperty
    public ReportRenderer getRenderer() {
        if (this.renderer == null) {
            this.renderer = new TaskReportRenderer();
        }
        return this.renderer;
    }

    public void setRenderer(TaskReportRenderer renderer) {
        this.renderer = renderer;
    }

    @Option(option="all", description="Show additional tasks and detail.")
    public void setShowDetail(boolean detail) {
        this.detail = detail;
    }

    @Console
    @ToBeReplacedByLazyProperty
    public boolean isDetail() {
        return this.detail;
    }

    @Option(option="group", description="Show tasks for a specific group.")
    public void setDisplayGroup(String group) {
        this.group = group;
    }

    @Console
    @ToBeReplacedByLazyProperty
    public String getDisplayGroup() {
        return this.group;
    }

    @Incubating
    @Option(option="groups", description="Show tasks for specific groups (can be used multiple times to specify multiple groups).")
    public void setDisplayGroups(List<String> groups) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.addAll(groups);
    }

    @Incubating
    @Console
    @ToBeReplacedByLazyProperty
    public List<String> getDisplayGroups() {
        return this.groups == null ? new ArrayList() : this.groups;
    }

    @Console
    @Option(option="types", description="Show task class types")
    public Property<Boolean> getShowTypes() {
        return this.showTypes;
    }

    @TaskAction
    void generate() {
        this.reportGenerator().generateReport(((TaskReportModel)this.model.get()).projects, projectModel -> ((ProjectReportModel)projectModel.get()).project, projectModel -> {
            this.render((ProjectReportModel)projectModel.get());
            this.logClickableOutputFileUrl();
        });
    }

    private TaskReportModel computeTaskReportModel() {
        return new TaskReportModel(this.computeProjectModels());
    }

    private List<Try<ProjectReportModel>> computeProjectModels() {
        ArrayList<Try<ProjectReportModel>> result = new ArrayList<Try<ProjectReportModel>>();
        for (Project project : new TreeSet<Project>(this.getProjects())) {
            result.add((Try<ProjectReportModel>)Try.ofFailable(() -> this.projectReportModelFor(project)));
        }
        return result;
    }

    private ProjectReportModel projectReportModelFor(Project project) {
        return new ProjectReportModel(ProjectDetails.of(project), project.getDefaultTasks(), this.taskReportModelFor(project, this.isDetail()), Strings.isNullOrEmpty((String)this.group) && (this.groups == null || this.groups.isEmpty()) ? this.ruleDetailsFor(project) : Collections.emptyList());
    }

    private void render(ProjectReportModel reportModel) {
        this.renderer.showDetail(this.isDetail());
        this.renderer.showTypes((Boolean)this.getShowTypes().get());
        this.renderer.addDefaultTasks(reportModel.defaultTasks);
        DefaultGroupTaskReportModel model = reportModel.tasks;
        for (String group : model.getGroups()) {
            this.renderer.startTaskGroup(group);
            for (TaskDetails task : model.getTasksForGroup(group)) {
                this.renderer.addTask(task);
            }
        }
        this.renderer.completeTasks();
        for (RuleDetails rule : reportModel.rules) {
            this.renderer.addRule(rule);
        }
    }

    private List<RuleDetails> ruleDetailsFor(Project project) {
        return project.getTasks().getRules().stream().map(rule -> RuleDetails.of(rule.getDescription())).collect(Collectors.toList());
    }

    private DefaultGroupTaskReportModel taskReportModelFor(Project project, boolean detail) {
        AggregateMultiProjectTaskReportModel aggregateModel = new AggregateMultiProjectTaskReportModel(!detail, detail, this.getDisplayGroup(), this.getDisplayGroups());
        TaskDetailsFactory taskDetailsFactory = new TaskDetailsFactory(project);
        SingleProjectTaskReportModel projectTaskModel = this.buildTaskReportModelFor(taskDetailsFactory, project);
        aggregateModel.add(projectTaskModel);
        for (Project subproject : project.getSubprojects()) {
            aggregateModel.add(this.buildTaskReportModelFor(taskDetailsFactory, subproject));
        }
        aggregateModel.build();
        return DefaultGroupTaskReportModel.of(aggregateModel);
    }

    private SingleProjectTaskReportModel buildTaskReportModelFor(TaskDetailsFactory taskDetailsFactory, Project subproject) {
        return (SingleProjectTaskReportModel)this.projectStateFor(subproject).fromMutableState(project -> SingleProjectTaskReportModel.forTasks(this.getProjectTaskLister().listProjectTasks((Project)project), taskDetailsFactory));
    }

    private ProjectState projectStateFor(Project subproject) {
        return this.getProjectStateRegistry().stateFor(subproject);
    }

    @Inject
    protected ProjectStateRegistry getProjectStateRegistry() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ProjectTaskLister getProjectTaskLister() {
        throw new UnsupportedOperationException();
    }

    private static class TaskReportModel {
        final List<Try<ProjectReportModel>> projects;

        public TaskReportModel(List<Try<ProjectReportModel>> projects) {
            this.projects = projects;
        }
    }

    private static class ProjectReportModel {
        public final ProjectDetails project;
        public final List<String> defaultTasks;
        public final DefaultGroupTaskReportModel tasks;
        public final List<RuleDetails> rules;

        public ProjectReportModel(ProjectDetails project, List<String> defaultTasks, DefaultGroupTaskReportModel tasks, List<RuleDetails> rules) {
            this.project = project;
            this.defaultTasks = defaultTasks;
            this.tasks = tasks;
            this.rules = rules;
        }
    }
}

