/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.internal.provider.PropertyFactory;
import org.gradle.api.provider.Property;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JvmImplementation;
import org.gradle.jvm.toolchain.JvmVendorSpec;
import org.gradle.jvm.toolchain.internal.DefaultJvmVendorSpec;
import org.gradle.jvm.toolchain.internal.JavaToolchainSpecInternal;

public class DefaultToolchainSpec
implements JavaToolchainSpecInternal {
    private final Property<JavaLanguageVersion> version;
    private final Property<JvmVendorSpec> vendor;
    private final Property<JvmImplementation> implementation;
    private final Property<Boolean> nativeImageCapable;

    @Inject
    public DefaultToolchainSpec(PropertyFactory propertyFactory) {
        this.version = propertyFactory.property(JavaLanguageVersion.class);
        this.vendor = propertyFactory.property(JvmVendorSpec.class);
        this.implementation = propertyFactory.property(JvmImplementation.class);
        this.nativeImageCapable = propertyFactory.property(Boolean.class);
        this.getVendor().convention((Object)DefaultToolchainSpec.getConventionVendor());
        this.getImplementation().convention((Object)DefaultToolchainSpec.getConventionImplementation());
    }

    @Override
    public Property<JavaLanguageVersion> getLanguageVersion() {
        return this.version;
    }

    @Override
    public Property<JvmVendorSpec> getVendor() {
        return this.vendor;
    }

    @Override
    public Property<JvmImplementation> getImplementation() {
        return this.implementation;
    }

    @Override
    public Property<Boolean> getNativeImageCapable() {
        return this.nativeImageCapable;
    }

    @Override
    public JavaToolchainSpecInternal.Key toKey() {
        return new Key((JavaLanguageVersion)this.getLanguageVersion().getOrNull(), (JvmVendorSpec)this.getVendor().getOrNull(), (JvmImplementation)this.getImplementation().getOrNull(), (Boolean)this.nativeImageCapable.getOrElse((Object)false));
    }

    @Override
    public boolean isConfigured() {
        return this.getLanguageVersion().isPresent();
    }

    @Override
    public boolean isValid() {
        if (this.getVendor().getOrNull() == JvmVendorSpec.IBM_SEMERU) {
            ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateBehaviour((String)"Requesting JVM vendor IBM_SEMERU.").willBeRemovedInGradle9().withUpgradeGuideSection(8, "ibm_semeru_should_not_be_used")).nagUser();
        }
        return this.getLanguageVersion().isPresent() || this.isSecondaryPropertiesUnchanged();
    }

    private boolean isSecondaryPropertiesUnchanged() {
        return Objects.equals(DefaultToolchainSpec.getConventionVendor(), this.getVendor().getOrNull()) && Objects.equals(DefaultToolchainSpec.getConventionImplementation(), this.getImplementation().getOrNull());
    }

    public String toString() {
        return this.getDisplayName();
    }

    private static JvmVendorSpec getConventionVendor() {
        return DefaultJvmVendorSpec.any();
    }

    private static JvmImplementation getConventionImplementation() {
        return JvmImplementation.VENDOR_SPECIFIC;
    }

    public static class Key
    implements JavaToolchainSpecInternal.Key {
        private final JavaLanguageVersion languageVersion;
        private final JvmVendorSpec vendor;
        private final JvmImplementation implementation;
        private final boolean nativeImageCapable;

        public Key(@Nullable JavaLanguageVersion languageVersion, @Nullable JvmVendorSpec vendor, @Nullable JvmImplementation implementation, boolean nativeImageCapable) {
            this.languageVersion = languageVersion;
            this.vendor = vendor;
            this.implementation = implementation;
            this.nativeImageCapable = nativeImageCapable;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key that = (Key)o;
            return Objects.equals(this.languageVersion, that.languageVersion) && Objects.equals(this.vendor, that.vendor) && Objects.equals(this.implementation, that.implementation) && this.nativeImageCapable == that.nativeImageCapable;
        }

        public int hashCode() {
            return Objects.hash(this.languageVersion, this.vendor, this.implementation, this.nativeImageCapable);
        }

        public String toString() {
            return "DefaultKey{languageVersion=" + this.languageVersion + ", vendor=" + this.vendor + ", implementation=" + this.implementation + ", nativeImageCapable=" + this.nativeImageCapable + '}';
        }
    }
}

