/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller.impl;

import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.configuration.internal.BuildCacheConfigurationInternal;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.caching.internal.controller.NoOpBuildCacheController;
import org.gradle.caching.internal.controller.impl.LifecycleAwareBuildCacheController;
import org.gradle.caching.internal.controller.service.BuildCacheLoadResult;
import org.gradle.caching.internal.services.BuildCacheControllerFactory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.instantiation.InstanceGenerator;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.util.Path;

@ServiceScope(value={Scope.BuildTree.class})
public class LifecycleAwareBuildCacheControllerFactory {
    private final RootBuildCacheController rootController = new RootBuildCacheController();

    public LifecycleAwareBuildCacheController createForRootBuild(Path identityPath, BuildCacheControllerFactory buildCacheControllerFactory, InstanceGenerator instanceGenerator) {
        return this.rootController.init(identityPath, buildCacheControllerFactory, instanceGenerator);
    }

    public LifecycleAwareBuildCacheController createForNonRootBuild(Path identityPath, BuildCacheControllerFactory buildCacheControllerFactory, InstanceGenerator instanceGenerator) {
        return this.rootController.createChild(identityPath, buildCacheControllerFactory, instanceGenerator);
    }

    private static class RootBuildCacheController
    extends DelegatingBuildCacheController {
        private final AtomicReference<BuildCacheController> delegate = new AtomicReference();
        private Path identityPath;
        private BuildCacheControllerFactory buildCacheControllerFactory;
        private InstanceGenerator instanceGenerator;

        private RootBuildCacheController() {
            this.delegate.set(NoOpBuildCacheController.INSTANCE);
        }

        public RootBuildCacheController init(Path identityPath, BuildCacheControllerFactory buildCacheControllerFactory, InstanceGenerator instanceGenerator) {
            this.identityPath = identityPath;
            this.buildCacheControllerFactory = buildCacheControllerFactory;
            this.instanceGenerator = instanceGenerator;
            return this;
        }

        @Override
        public void configurationAvailable(BuildCacheConfigurationInternal configuration) {
            RootBuildCacheController.createDelegate(configuration, this.delegate, this.buildCacheControllerFactory, this.identityPath, this.instanceGenerator);
        }

        @Override
        protected BuildCacheController getDelegate() {
            return this.delegate.get();
        }

        @Override
        public void resetState() {
            RootBuildCacheController.discardDelegate(this.delegate);
        }

        public LifecycleAwareBuildCacheController createChild(Path identityPath, BuildCacheControllerFactory buildCacheControllerFactory, InstanceGenerator instanceGenerator) {
            return new NonRootBuildCacheController(this, identityPath, buildCacheControllerFactory, instanceGenerator);
        }
    }

    private static class NonRootBuildCacheController
    extends DelegatingBuildCacheController {
        private final RootBuildCacheController rootController;
        private final AtomicReference<BuildCacheController> delegate = new AtomicReference();
        private final Path identityPath;
        private final BuildCacheControllerFactory buildCacheControllerFactory;
        private final InstanceGenerator instanceGenerator;

        private NonRootBuildCacheController(RootBuildCacheController rootController, Path identityPath, BuildCacheControllerFactory buildCacheControllerFactory, InstanceGenerator instanceGenerator) {
            this.rootController = rootController;
            this.identityPath = identityPath;
            this.buildCacheControllerFactory = buildCacheControllerFactory;
            this.instanceGenerator = instanceGenerator;
            this.delegate.set(NoOpBuildCacheController.INSTANCE);
        }

        @Override
        public void configurationAvailable(BuildCacheConfigurationInternal configuration) {
            BuildCacheController rootController = this.rootController.getDelegate();
            if (rootController != NoOpBuildCacheController.INSTANCE) {
                return;
            }
            NonRootBuildCacheController.createDelegate(configuration, this.delegate, this.buildCacheControllerFactory, this.identityPath, this.instanceGenerator);
        }

        @Override
        protected BuildCacheController getDelegate() {
            BuildCacheController rootController = this.rootController.getDelegate();
            if (rootController != NoOpBuildCacheController.INSTANCE) {
                return rootController;
            }
            return this.delegate.get();
        }

        @Override
        public void resetState() {
            NonRootBuildCacheController.discardDelegate(this.delegate);
        }
    }

    private static abstract class DelegatingBuildCacheController
    implements LifecycleAwareBuildCacheController {
        private DelegatingBuildCacheController() {
        }

        public boolean isEnabled() {
            return this.getDelegate().isEnabled();
        }

        public Optional<BuildCacheLoadResult> load(BuildCacheKey cacheKey, CacheableEntity cacheableEntity) {
            return this.getDelegate().load(cacheKey, cacheableEntity);
        }

        public void store(BuildCacheKey cacheKey, CacheableEntity entity, Map<String, FileSystemSnapshot> snapshots, Duration executionTime) {
            this.getDelegate().store(cacheKey, entity, snapshots, executionTime);
        }

        public void close() {
            this.resetState();
        }

        protected static void createDelegate(BuildCacheConfigurationInternal configuration, AtomicReference<BuildCacheController> delegate, BuildCacheControllerFactory buildCacheControllerFactory, Path identityPath, InstanceGenerator instanceGenerator) {
            BuildCacheController controller = buildCacheControllerFactory.createController(identityPath, configuration, instanceGenerator);
            if (!delegate.compareAndSet(NoOpBuildCacheController.INSTANCE, controller)) {
                try {
                    controller.close();
                }
                catch (IOException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
                throw new IllegalStateException("Build cache controller already set");
            }
        }

        protected static void discardDelegate(AtomicReference<BuildCacheController> delegate) {
            BuildCacheController controller = delegate.getAndSet(NoOpBuildCacheController.INSTANCE);
            try {
                controller.close();
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }

        protected abstract BuildCacheController getDelegate();
    }
}

