/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.cli;

import org.jreleaser.cli.AbstractPlatformAwareModelCommand;
import org.jreleaser.cli.Main;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.workflow.Workflows;
import picocli.CommandLine;

@CommandLine.Command(name="catalog")
public class Catalog
extends AbstractPlatformAwareModelCommand<Main> {
    @CommandLine.ArgGroup
    Composite composite;

    @Override
    protected void doExecute(JReleaserContext context) {
        if (null != this.composite) {
            context.setIncludedDistributions(this.collectEntries(this.composite.includedDistributions()));
            context.setExcludedDistributions(this.collectEntries(this.composite.excludedDistributions()));
            context.setIncludedCatalogers(this.collectEntries(this.composite.includedCatalogers(), true));
            context.setExcludedCatalogers(this.collectEntries(this.composite.excludedCatalogers(), true));
        }
        Workflows.catalog((JReleaserContext)context).execute();
    }

    static class Exclude {
        @CommandLine.Option(names={"--exclude-distribution"}, paramLabel="<distribution>")
        String[] excludedDistributions;
        @CommandLine.Option(names={"--exclude-cataloger"}, paramLabel="<cataloger>")
        String[] excludedCatalogers;

        Exclude() {
        }
    }

    static class Include {
        @CommandLine.Option(names={"--distribution"}, paramLabel="<distribution>")
        String[] includedDistributions;
        @CommandLine.Option(names={"--cataloger"}, paramLabel="<cataloger>")
        String[] includedCatalogers;

        Include() {
        }
    }

    static class Composite {
        @CommandLine.ArgGroup(exclusive=false, order=1, headingKey="include.filter.header")
        Include include;
        @CommandLine.ArgGroup(exclusive=false, order=2, headingKey="exclude.filter.header")
        Exclude exclude;

        Composite() {
        }

        String[] includedDistributions() {
            return null != this.include ? this.include.includedDistributions : null;
        }

        String[] excludedDistributions() {
            return null != this.exclude ? this.exclude.excludedDistributions : null;
        }

        String[] includedCatalogers() {
            return null != this.include ? this.include.includedCatalogers : null;
        }

        String[] excludedCatalogers() {
            return null != this.exclude ? this.exclude.excludedCatalogers : null;
        }
    }
}

