/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.EnabledAware;
import org.jreleaser.model.internal.common.ExtraProperties;
import org.jreleaser.util.StringUtils;

public final class Java
extends AbstractModelObject<Java>
implements Domain,
ExtraProperties,
EnabledAware {
    private static final long serialVersionUID = -2234061310893799176L;
    private final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    private Boolean enabled;
    private String version;
    private String groupId;
    private String artifactId;
    private String mainModule;
    private String mainClass;
    private Boolean multiProject;
    @JsonIgnore
    private final org.jreleaser.model.api.common.Java immutable = new org.jreleaser.model.api.common.Java(){
        private static final long serialVersionUID = 1595567967292822458L;

        public String getVersion() {
            return Java.this.version;
        }

        public String getGroupId() {
            return Java.this.groupId;
        }

        public String getArtifactId() {
            return Java.this.artifactId;
        }

        public boolean isMultiProject() {
            return Java.this.isMultiProject();
        }

        public String getMainClass() {
            return Java.this.mainClass;
        }

        public String getMainModule() {
            return Java.this.mainModule;
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Java.this.asMap(full));
        }

        public boolean isEnabled() {
            return Java.this.isEnabled();
        }

        public String getPrefix() {
            return Java.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(Java.this.extraProperties);
        }
    };

    public org.jreleaser.model.api.common.Java asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Java source) {
        this.enabled = this.merge(this.enabled, source.enabled);
        this.version = this.merge(this.version, source.version);
        this.groupId = this.merge(this.groupId, source.groupId);
        this.artifactId = this.merge(this.artifactId, source.artifactId);
        this.mainModule = this.merge(this.mainModule, source.mainModule);
        this.mainClass = this.merge(this.mainClass, source.mainClass);
        this.multiProject = this.merge(this.multiProject, source.multiProject);
        this.setExtraProperties(this.merge(this.extraProperties, source.extraProperties));
    }

    @Override
    public boolean isEnabled() {
        return null != this.enabled && this.enabled != false;
    }

    @Override
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabledSet() {
        return null != this.enabled;
    }

    @Override
    public String prefix() {
        return "java";
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = StringUtils.isNotBlank((String)version) && version.startsWith("1.8") ? "8" : version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public boolean isMultiProject() {
        return null != this.multiProject && this.multiProject != false;
    }

    public void setMultiProject(Boolean multiProject) {
        this.multiProject = multiProject;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public String getMainModule() {
        return this.mainModule;
    }

    public void setMainModule(String mainModule) {
        this.mainModule = mainModule;
    }

    public boolean isMultiProjectSet() {
        return null != this.multiProject;
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.putAll(extraProperties);
    }

    public boolean isSet() {
        return this.isEnabledSet() || StringUtils.isNotBlank((String)this.version) || StringUtils.isNotBlank((String)this.groupId) || StringUtils.isNotBlank((String)this.artifactId) || StringUtils.isNotBlank((String)this.mainModule) || StringUtils.isNotBlank((String)this.mainClass) || this.isMultiProjectSet() || !this.extraProperties.isEmpty();
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("version", this.version);
        map.put("groupId", this.groupId);
        map.put("artifactId", this.artifactId);
        map.put("mainModule", this.mainModule);
        map.put("mainClass", this.mainClass);
        map.put("multiProject", this.isMultiProject());
        map.put("extraProperties", this.getExtraProperties());
        return map;
    }
}

