/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.hooks;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.hooks.Hook;

public abstract class AbstractHook<S extends AbstractHook<S>>
extends AbstractActivatable<S>
implements Hook {
    private static final long serialVersionUID = -4116420563092875433L;
    private final Map<String, String> environment = new LinkedHashMap<String, String>();
    private final Set<String> platforms = new LinkedHashSet<String>();
    private final Hook.Filter filter = new Hook.Filter();
    protected Boolean continueOnError;
    protected Boolean verbose;
    protected String condition;

    @Override
    public void merge(S source) {
        super.merge(source);
        this.continueOnError = this.merge(this.continueOnError, ((AbstractHook)source).continueOnError);
        this.verbose = this.merge(this.verbose, ((AbstractHook)source).verbose);
        this.condition = this.merge(this.condition, ((AbstractHook)source).condition);
        this.setFilter(((AbstractHook)source).getFilter());
        this.setPlatforms(this.merge(this.platforms, ((AbstractHook)source).getPlatforms()));
        this.setEnvironment(this.merge(this.environment, ((AbstractHook)source).getEnvironment()));
    }

    @Override
    public boolean isContinueOnError() {
        return null != this.continueOnError && this.continueOnError != false;
    }

    @Override
    public void setContinueOnError(Boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    @Override
    public boolean isContinueOnErrorSet() {
        return null != this.continueOnError;
    }

    @Override
    public boolean isVerbose() {
        return null != this.verbose && this.verbose != false;
    }

    @Override
    public void setVerbose(Boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public boolean isVerboseSet() {
        return null != this.verbose;
    }

    @Override
    public String getCondition() {
        return this.condition;
    }

    @Override
    public void setCondition(String condition) {
        this.condition = condition;
    }

    @Override
    public Hook.Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Hook.Filter filter) {
        this.filter.merge(filter);
    }

    @Override
    public Set<String> getPlatforms() {
        return this.platforms;
    }

    @Override
    public void setPlatforms(Set<String> platforms) {
        this.platforms.clear();
        this.platforms.addAll(platforms);
    }

    @Override
    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    @Override
    public void setEnvironment(Map<String, String> environment) {
        this.environment.clear();
        this.environment.putAll(environment);
    }

    @Override
    public void addEnvironment(Map<String, String> environment) {
        this.environment.putAll(environment);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("active", this.getActive());
        map.put("continueOnError", this.isContinueOnError());
        map.put("verbose", this.isVerbose());
        map.put("platforms", this.platforms);
        map.put("condition", this.condition);
        Map<String, Object> filterAsMap = this.filter.asMap(full);
        if (full || !filterAsMap.isEmpty()) {
            map.put("filter", filterAsMap);
        }
        map.put("environment", this.environment);
        this.asMap(full, map);
        return map;
    }

    protected abstract void asMap(boolean var1, Map<String, Object> var2);
}

