/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.hooks;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.Active;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.hooks.CommandHooks;
import org.jreleaser.model.internal.hooks.ScriptHooks;

public final class Hooks
extends AbstractActivatable<Hooks>
implements Domain {
    private static final long serialVersionUID = -5698247369155386191L;
    private final Map<String, String> environment = new LinkedHashMap<String, String>();
    private final CommandHooks command = new CommandHooks();
    private final ScriptHooks script = new ScriptHooks();
    @JsonIgnore
    private final org.jreleaser.model.api.hooks.Hooks immutable = new org.jreleaser.model.api.hooks.Hooks(){
        private static final long serialVersionUID = -3768581923578821278L;

        public org.jreleaser.model.api.hooks.CommandHooks getCommand() {
            return Hooks.this.command.asImmutable();
        }

        public org.jreleaser.model.api.hooks.ScriptHooks getScript() {
            return Hooks.this.script.asImmutable();
        }

        public Map<String, String> getEnvironment() {
            return Collections.unmodifiableMap(Hooks.this.getEnvironment());
        }

        public Active getActive() {
            return Hooks.this.getActive();
        }

        public boolean isEnabled() {
            return Hooks.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Hooks.this.asMap(full));
        }
    };

    public Hooks() {
        this.enabledSet(true);
    }

    public org.jreleaser.model.api.hooks.Hooks asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Hooks source) {
        super.merge(source);
        this.setCommand(source.command);
        this.setScript(source.script);
        this.setEnvironment(this.merge(this.environment, source.getEnvironment()));
    }

    @Override
    public boolean isSet() {
        return super.isSet() || this.command.isSet() || this.script.isSet();
    }

    public CommandHooks getCommand() {
        return this.command;
    }

    public void setCommand(CommandHooks command) {
        this.command.merge(command);
    }

    public ScriptHooks getScript() {
        return this.script;
    }

    public void setScript(ScriptHooks script) {
        this.script.merge(script);
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment.clear();
        this.environment.putAll(environment);
    }

    public void addEnvironment(Map<String, String> environment) {
        this.environment.putAll(environment);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("active", this.getActive());
        map.put("environment", this.environment);
        map.put("command", this.command.asMap(full));
        map.put("script", this.script.asMap(full));
        return map;
    }
}

