/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.packagers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.common.ExtraProperties;
import org.jreleaser.model.internal.packagers.DockerConfiguration;
import org.jreleaser.util.StringUtils;

public abstract class AbstractDockerConfiguration<S extends AbstractDockerConfiguration<S>>
extends AbstractActivatable<S>
implements DockerConfiguration,
ExtraProperties {
    private static final long serialVersionUID = 9145623803421730899L;
    private final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    private final Map<String, String> labels = new LinkedHashMap<String, String>();
    private final Set<String> imageNames = new LinkedHashSet<String>();
    private final List<String> buildArgs = new ArrayList<String>();
    private final List<String> preCommands = new ArrayList<String>();
    private final List<String> postCommands = new ArrayList<String>();
    private final Set<DockerConfiguration.Registry> registries = new LinkedHashSet<DockerConfiguration.Registry>();
    private final List<String> skipTemplates = new ArrayList<String>();
    private final DockerConfiguration.Buildx buildx = new DockerConfiguration.Buildx();
    private String templateDirectory;
    protected Boolean useLocalArtifact;
    private String baseImage;

    @Override
    public void merge(S source) {
        super.merge(source);
        this.templateDirectory = this.merge(this.templateDirectory, ((AbstractDockerConfiguration)source).getTemplateDirectory());
        this.setSkipTemplates(this.merge(this.skipTemplates, ((AbstractDockerConfiguration)source).getSkipTemplates()));
        this.setExtraProperties(this.merge(this.extraProperties, ((AbstractDockerConfiguration)source).getExtraProperties()));
        this.baseImage = this.merge(this.baseImage, ((AbstractDockerConfiguration)source).getBaseImage());
        this.useLocalArtifact = this.merge(this.useLocalArtifact, ((AbstractDockerConfiguration)source).useLocalArtifact);
        this.setImageNames(this.merge(this.imageNames, ((AbstractDockerConfiguration)source).getImageNames()));
        this.setBuildArgs(this.merge(this.buildArgs, ((AbstractDockerConfiguration)source).getBuildArgs()));
        this.setPreCommands(this.merge(this.preCommands, ((AbstractDockerConfiguration)source).getPreCommands()));
        this.setPostCommands(this.merge(this.postCommands, ((AbstractDockerConfiguration)source).getPostCommands()));
        this.setLabels(this.merge(this.labels, ((AbstractDockerConfiguration)source).getLabels()));
        this.setRegistries(this.merge(this.registries, ((AbstractDockerConfiguration)source).getRegistries()));
        this.setBuildx(((AbstractDockerConfiguration)source).getBuildx());
    }

    @Override
    public String prefix() {
        return "docker";
    }

    @Override
    public String getTemplateDirectory() {
        return this.templateDirectory;
    }

    @Override
    public void setTemplateDirectory(String templateDirectory) {
        this.templateDirectory = templateDirectory;
    }

    @Override
    public List<String> getSkipTemplates() {
        return this.skipTemplates;
    }

    @Override
    public void setSkipTemplates(List<String> skipTemplates) {
        this.skipTemplates.clear();
        this.skipTemplates.addAll(skipTemplates);
    }

    @Override
    public void addSkipTemplates(List<String> templates) {
        this.skipTemplates.addAll(templates);
    }

    @Override
    public void addSkipTemplate(String template) {
        if (StringUtils.isNotBlank((String)template)) {
            this.skipTemplates.add(template.trim());
        }
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public String getBaseImage() {
        return this.baseImage;
    }

    @Override
    public void setBaseImage(String baseImage) {
        this.baseImage = baseImage;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public void setLabels(Map<String, String> labels) {
        this.labels.clear();
        this.labels.putAll(labels);
    }

    @Override
    public void addLabels(Map<String, String> labels) {
        this.labels.putAll(labels);
    }

    @Override
    public void addLabel(String key, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            this.labels.put(key, value);
        }
    }

    @Override
    public Set<String> getImageNames() {
        return this.imageNames;
    }

    @Override
    public void setImageNames(Set<String> imageNames) {
        if (null != imageNames) {
            this.imageNames.clear();
            this.imageNames.addAll(imageNames);
        }
    }

    @Override
    public void addImageName(String imageName) {
        if (StringUtils.isNotBlank((String)imageName)) {
            this.imageNames.add(imageName);
        }
    }

    @Override
    public List<String> getBuildArgs() {
        return this.buildArgs;
    }

    @Override
    public void setBuildArgs(List<String> buildArgs) {
        if (null != buildArgs) {
            this.buildArgs.clear();
            this.buildArgs.addAll(buildArgs);
        }
    }

    @Override
    public void addBuildArg(String buildArg) {
        if (StringUtils.isNotBlank((String)buildArg)) {
            this.buildArgs.add(buildArg);
        }
    }

    @Override
    public List<String> getPreCommands() {
        return this.preCommands;
    }

    @Override
    public void setPreCommands(List<String> preCommands) {
        if (null != preCommands) {
            this.preCommands.clear();
            this.preCommands.addAll(preCommands);
        }
    }

    @Override
    public List<String> getPostCommands() {
        return this.postCommands;
    }

    @Override
    public void setPostCommands(List<String> postCommands) {
        if (null != postCommands) {
            this.postCommands.clear();
            this.postCommands.addAll(postCommands);
        }
    }

    public Set<DockerConfiguration.Registry> getRegistries() {
        return this.registries;
    }

    @Override
    public void setRegistries(Set<? extends DockerConfiguration.Registry> registries) {
        if (null != registries) {
            this.registries.clear();
            this.registries.addAll(registries);
        }
    }

    @Override
    public void addRegistry(DockerConfiguration.Registry registry) {
        if (null != registry) {
            this.registries.add(registry);
        }
    }

    @Override
    public boolean isUseLocalArtifact() {
        return null == this.useLocalArtifact || this.useLocalArtifact != false;
    }

    @Override
    public void setUseLocalArtifact(Boolean useLocalArtifact) {
        this.useLocalArtifact = useLocalArtifact;
    }

    @Override
    public boolean isUseLocalArtifactSet() {
        return null != this.useLocalArtifact;
    }

    @Override
    public DockerConfiguration.Buildx getBuildx() {
        return this.buildx;
    }

    @Override
    public void setBuildx(DockerConfiguration.Buildx buildx) {
        this.buildx.merge(buildx);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("enabled", this.isEnabled());
        props.put("active", this.getActive());
        props.put("templateDirectory", this.templateDirectory);
        props.put("skipTemplates", this.skipTemplates);
        props.put("useLocalArtifact", this.isUseLocalArtifact());
        props.put("baseImage", this.baseImage);
        props.put("imageNames", this.imageNames);
        props.put("buildArgs", this.buildArgs);
        props.put("labels", this.labels);
        props.put("preCommands", this.preCommands);
        props.put("postCommands", this.postCommands);
        if (this.buildx.isEnabled() || full) {
            props.put("buildx", this.buildx.asMap(full));
        }
        this.asMap(full, props);
        LinkedHashMap<String, Map<String, Object>> m = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (DockerConfiguration.Registry registry : this.registries) {
            m.put("registry " + i++, registry.asMap(full));
        }
        props.put("registries", m);
        props.put("extraProperties", this.getExtraProperties());
        return props;
    }

    protected abstract void asMap(boolean var1, Map<String, Object> var2);
}

