/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collection;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Mail;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.SmtpAnnouncer;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class SmtpAnnouncerValidator {
    private SmtpAnnouncerValidator() {
    }

    public static void validateSmtp(JReleaserContext context, SmtpAnnouncer announcer, Errors errors) {
        context.getLogger().debug("announce.smtp");
        Validator.resolveActivatable(context, (Activatable)announcer, "announce.smtp", "NEVER");
        if (!announcer.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (null == announcer.getTransport()) {
            announcer.setTransport(Mail.Transport.SMTP);
        }
        if (StringUtils.isBlank((String)announcer.getHost())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"mail.host"}));
        }
        if (null == announcer.getPort()) {
            announcer.setPort(25);
        }
        if (!announcer.isAuthSet()) {
            announcer.setAuth(true);
        }
        if (StringUtils.isBlank((String)announcer.getUsername())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"mail.username"}));
        }
        announcer.setPassword(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.smtp.password", "SMTP_PASSWORD", "MAIL_PASSWORD"}), "announce.smtp.password", announcer.getPassword(), errors, context.isDryrun()));
        if (StringUtils.isBlank((String)announcer.getFrom())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"mail.from"}));
        }
        boolean to = StringUtils.isBlank((String)announcer.getTo());
        boolean cc = StringUtils.isBlank((String)announcer.getCc());
        boolean bcc = StringUtils.isBlank((String)announcer.getBcc());
        if (!(to || cc || bcc)) {
            errors.configuration(RB.$((String)"validation_mail_not_blank", (Object[])new Object[]{"mail.to, mail.cc,", "mail.bcc"}));
        }
        if (StringUtils.isBlank((String)announcer.getSubject())) {
            announcer.setSubject(RB.$((String)"default.discussion.title", (Object[])new Object[0]));
        }
        if (null == announcer.getMimeType()) {
            announcer.setMimeType(Mail.MimeType.TEXT);
        }
        if (StringUtils.isBlank((String)announcer.getMessage()) && StringUtils.isBlank((String)announcer.getMessageTemplate())) {
            announcer.setMessageTemplate("src/jreleaser/templates/mail.tpl");
        }
        if (StringUtils.isNotBlank((String)announcer.getMessageTemplate()) && !Files.exists(context.getBasedir().resolve(announcer.getMessageTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"mail.messageTemplate", announcer.getMessageTemplate()}));
        }
    }
}

