/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.deploy.maven;

import java.util.Collection;
import java.util.Map;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.deploy.maven.GithubMavenDeployer;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.deploy.maven.MavenDeployersValidator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class GithubMavenDeployerValidator {
    private GithubMavenDeployerValidator() {
    }

    public static void validateGithubMavenDeployer(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, GithubMavenDeployer> github = context.getModel().getDeploy().getMaven().getGithub();
        if (!github.isEmpty()) {
            context.getLogger().debug("deploy.maven.github");
        }
        for (Map.Entry<String, GithubMavenDeployer> e : github.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateDeploy() && !mode.validateConfig()) continue;
            GithubMavenDeployerValidator.validateGithubMavenDeployer(context, e.getValue(), errors);
        }
    }

    private static void validateGithubMavenDeployer(JReleaserContext context, GithubMavenDeployer mavenDeployer, Errors errors) {
        if (StringUtils.isBlank((String)mavenDeployer.getUrl())) {
            mavenDeployer.setUrl("https://maven.pkg.github.com/{{owner}}/{{repository}}");
        }
        MavenDeployersValidator.validateMavenDeployer(context, mavenDeployer, errors);
        if (!mavenDeployer.isEnabled()) {
            return;
        }
        BaseReleaser<?, ?> service = context.getModel().getRelease().getReleaser();
        mavenDeployer.setUsername(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"deploy.maven." + mavenDeployer.getType() + "." + mavenDeployer.getName() + ".username", "deploy.maven." + mavenDeployer.getType() + ".username", mavenDeployer.getType() + "." + mavenDeployer.getName() + ".username", mavenDeployer.getType() + ".username"}), "deploy.maven." + mavenDeployer.getType() + "." + mavenDeployer.getName() + ".username", mavenDeployer.getUsername(), service.getUsername()));
        mavenDeployer.setPassword(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"deploy.maven." + mavenDeployer.getType() + "." + mavenDeployer.getName() + ".password", "deploy.maven." + mavenDeployer.getType() + "." + mavenDeployer.getName() + ".token", "deploy.maven." + mavenDeployer.getType() + ".password", "deploy.maven." + mavenDeployer.getType() + ".token", mavenDeployer.getType() + "." + mavenDeployer.getName() + ".password", mavenDeployer.getType() + "." + mavenDeployer.getName() + ".token", mavenDeployer.getType() + ".password", mavenDeployer.getType() + ".token"}), "deploy.maven." + mavenDeployer.getType() + "." + mavenDeployer.getName() + ".password", mavenDeployer.getPassword(), service.getToken()));
        if (StringUtils.isBlank((String)mavenDeployer.getUsername())) {
            mavenDeployer.setUsername(context.getModel().getRelease().getReleaser().getUsername());
        }
        if (StringUtils.isBlank((String)mavenDeployer.getRepository())) {
            mavenDeployer.setRepository(context.getModel().getRelease().getReleaser().getName());
        }
    }
}

