/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.deploy.maven;

import java.util.Collection;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.deploy.maven.GitlabMavenDeployer;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.deploy.maven.MavenDeployersValidator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class GitlabMavenDeployerValidator {
    private GitlabMavenDeployerValidator() {
    }

    public static void validateGitlabMavenDeployer(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, GitlabMavenDeployer> gitlab = context.getModel().getDeploy().getMaven().getGitlab();
        if (!gitlab.isEmpty()) {
            context.getLogger().debug("deploy.maven.gitlab");
        }
        for (Map.Entry<String, GitlabMavenDeployer> e : gitlab.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateDeploy() && !mode.validateConfig()) continue;
            GitlabMavenDeployerValidator.validateGitlabMavenDeployer(context, e.getValue(), errors);
        }
    }

    private static void validateGitlabMavenDeployer(JReleaserContext context, GitlabMavenDeployer mavenDeployer, Errors errors) {
        MavenDeployersValidator.validateMavenDeployer(context, mavenDeployer, errors);
        if (!mavenDeployer.isEnabled()) {
            return;
        }
        BaseReleaser<?, ?> service = context.getModel().getRelease().getReleaser();
        mavenDeployer.setUsername(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"deploy.maven." + mavenDeployer.getType() + "." + mavenDeployer.getName() + ".username", "deploy.maven." + mavenDeployer.getType() + ".username", mavenDeployer.getType() + "." + mavenDeployer.getName() + ".username", mavenDeployer.getType() + ".username"}), "deploy.maven." + mavenDeployer.getType() + "." + mavenDeployer.getName() + ".username", mavenDeployer.getUsername(), service.getUsername()));
        mavenDeployer.setPassword(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"deploy.maven." + mavenDeployer.getType() + "." + mavenDeployer.getName() + ".password", "deploy.maven." + mavenDeployer.getType() + "." + mavenDeployer.getName() + ".token", "deploy.maven." + mavenDeployer.getType() + ".password", "deploy.maven." + mavenDeployer.getType() + ".token", mavenDeployer.getType() + "." + mavenDeployer.getName() + ".password", mavenDeployer.getType() + "." + mavenDeployer.getName() + ".token", mavenDeployer.getType() + ".password", mavenDeployer.getType() + ".token"}), "deploy.maven." + mavenDeployer.getType() + "." + mavenDeployer.getName() + ".password", mavenDeployer.getPassword(), service.getToken()));
        if (StringUtils.isBlank((String)mavenDeployer.getUsername())) {
            mavenDeployer.setUsername(context.getModel().getRelease().getReleaser().getUsername());
        }
        if (StringUtils.isBlank((String)mavenDeployer.getProjectIdentifier())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"deploy.maven.gitea." + mavenDeployer.getName() + ".projectIdentifier"}));
        }
    }
}

