/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.release;

import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.release.Release;
import org.jreleaser.model.internal.validation.release.CodebergReleaserValidator;
import org.jreleaser.model.internal.validation.release.GenericGitReleaserValidator;
import org.jreleaser.model.internal.validation.release.GiteaReleaserValidator;
import org.jreleaser.model.internal.validation.release.GithubReleaserValidator;
import org.jreleaser.model.internal.validation.release.GitlabReleaserValidator;
import org.jreleaser.util.Errors;

public final class ReleaseValidator {
    private ReleaseValidator() {
    }

    public static void validateRelease(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        context.getLogger().debug("release");
        Release release = context.getModel().getRelease();
        int count = 0;
        if (GithubReleaserValidator.validateGithub(context, mode, release.getGithub(), errors)) {
            ++count;
        }
        if (GitlabReleaserValidator.validateGitlab(context, mode, release.getGitlab(), errors)) {
            ++count;
        }
        if (GiteaReleaserValidator.validateGitea(context, mode, release.getGitea(), errors)) {
            ++count;
        }
        if (CodebergReleaserValidator.validateCodeberg(context, mode, release.getCodeberg(), errors)) {
            ++count;
        }
        if (GenericGitReleaserValidator.validateGeneric(context, mode, release.getGeneric(), errors)) {
            ++count;
        }
        if (!mode.validateStandalone()) {
            if (0 == count) {
                errors.configuration(RB.$((String)"validation_release_no_providers", (Object[])new Object[0]));
                return;
            }
            if (count > 1) {
                errors.configuration(RB.$((String)"validation_release_requirement", (Object[])new Object[]{"release.[github|gitlab|gitea|codeberg|generic]"}));
            }
        }
    }
}

