/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal.inline;

import org.commonmark.internal.inline.InlineContentParser;
import org.commonmark.internal.inline.InlineParserState;
import org.commonmark.internal.inline.ParsedInline;
import org.commonmark.internal.inline.Position;
import org.commonmark.internal.inline.Scanner;
import org.commonmark.internal.util.AsciiMatcher;
import org.commonmark.internal.util.Html5Entities;
import org.commonmark.node.Text;

public class EntityInlineParser
implements InlineContentParser {
    private static final AsciiMatcher hex = AsciiMatcher.builder().range('0', '9').range('A', 'F').range('a', 'f').build();
    private static final AsciiMatcher dec = AsciiMatcher.builder().range('0', '9').build();
    private static final AsciiMatcher entityStart = AsciiMatcher.builder().range('A', 'Z').range('a', 'z').build();
    private static final AsciiMatcher entityContinue = entityStart.newBuilder().range('0', '9').build();

    @Override
    public ParsedInline tryParse(InlineParserState inlineParserState) {
        Scanner scanner = inlineParserState.scanner();
        Position start = scanner.position();
        scanner.next();
        char c = scanner.peek();
        if (c == '#') {
            int digits;
            scanner.next();
            if (scanner.next('x') || scanner.next('X') ? 1 <= (digits = scanner.match(hex)) && digits <= 6 && scanner.next(';') : 1 <= (digits = scanner.match(dec)) && digits <= 7 && scanner.next(';')) {
                return this.entity(scanner, start);
            }
        } else if (entityStart.matches(c)) {
            scanner.match(entityContinue);
            if (scanner.next(';')) {
                return this.entity(scanner, start);
            }
        }
        return ParsedInline.none();
    }

    private ParsedInline entity(Scanner scanner, Position start) {
        String text = scanner.getSource(start, scanner.position()).getContent();
        return ParsedInline.of(new Text(Html5Entities.entityToString(text)), scanner.position());
    }
}

