/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj;

import net.schmizz.sshj.Service;
import net.schmizz.sshj.common.DisconnectReason;
import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.transport.Transport;
import net.schmizz.sshj.transport.TransportException;
import org.slf4j.Logger;

public abstract class AbstractService
implements Service {
    protected final Logger log;
    protected final String name;
    protected final Transport trans;

    public AbstractService(String name, Transport trans) {
        this.name = name;
        this.trans = trans;
        this.log = trans.getConfig().getLoggerFactory().getLogger(this.getClass());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void handle(Message msg, SSHPacket buf) throws SSHException {
        this.trans.sendUnimplemented();
    }

    @Override
    public void notifyError(SSHException error) {
        this.log.debug("Notified of {}", (Object)error.toString());
    }

    @Override
    public void notifyUnimplemented(long seqNum) throws SSHException {
        throw new SSHException(DisconnectReason.PROTOCOL_ERROR, "Unexpected: SSH_MSG_UNIMPLEMENTED");
    }

    @Override
    public void request() throws TransportException {
        Service active = this.trans.getService();
        if (!this.equals(active)) {
            if (this.name.equals(active.getName())) {
                this.trans.setService(this);
            } else {
                this.trans.reqService(this);
            }
        }
    }
}

