/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.sdkman;

import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.sdk.sdkman.AbstractSdkmanCommand;
import org.jreleaser.sdk.sdkman.SdkmanException;
import org.jreleaser.util.StringUtils;

public class AnnounceSdkmanCommand
extends AbstractSdkmanCommand {
    private final String hashtag;
    private final String releaseNotesUrl;

    private AnnounceSdkmanCommand(JReleaserLogger logger, String apiHost, int connectTimeout, int readTimeout, String consumerKey, String consumerToken, String candidate, String version, boolean dryrun, String hashtag, String releaseNotesUrl) {
        super(logger, apiHost, connectTimeout, readTimeout, consumerKey, consumerToken, candidate, version, dryrun);
        this.hashtag = hashtag;
        this.releaseNotesUrl = releaseNotesUrl;
    }

    @Override
    public void execute() throws SdkmanException {
        this.sdkman.announce(this.candidate, this.version, this.hashtag, this.releaseNotesUrl);
    }

    public static Builder builder(JReleaserLogger logger) {
        return new Builder(logger);
    }

    public static class Builder
    extends AbstractSdkmanCommand.Builder<Builder> {
        private String hashtag;
        private String releaseNotesUrl;

        protected Builder(JReleaserLogger logger) {
            super(logger);
        }

        public Builder hashtag(String hashtag) {
            this.hashtag = hashtag;
            return this;
        }

        public Builder releaseNotesUrl(String releaseNotesUrl) {
            this.releaseNotesUrl = releaseNotesUrl;
            return this;
        }

        public AnnounceSdkmanCommand build() {
            StringUtils.requireNonBlank((String)this.apiHost, (String)"'apiHost' must not be blank");
            StringUtils.requireNonBlank((String)this.consumerKey, (String)"'consumerKey' must not be blank");
            StringUtils.requireNonBlank((String)this.consumerToken, (String)"'consumerToken' must not be blank");
            StringUtils.requireNonBlank((String)this.candidate, (String)"'candidate' must not be blank");
            StringUtils.requireNonBlank((String)this.version, (String)"'version' must not be blank");
            return new AnnounceSdkmanCommand(this.logger, this.apiHost, this.connectTimeout, this.readTimeout, this.consumerKey, this.consumerToken, this.candidate, this.version, this.dryrun, this.hashtag, this.releaseNotesUrl);
        }
    }
}

