/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Objects;
import twitter4j.HttpResponse;
import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.TwitterException;

public class OAuth2Token
implements Serializable {
    private static final long serialVersionUID = -8985359441959903216L;
    private final String tokenType;
    private final String accessToken;

    OAuth2Token(HttpResponse res) throws TwitterException {
        JSONObject json = res.asJSONObject();
        this.tokenType = OAuth2Token.getRawString("token_type", json);
        try {
            this.accessToken = URLDecoder.decode(OAuth2Token.getRawString("access_token", json), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public OAuth2Token(String tokenType, String accessToken) {
        this.tokenType = tokenType;
        this.accessToken = accessToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    String generateAuthorizationHeader() {
        String encoded;
        try {
            encoded = URLEncoder.encode(this.accessToken, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return "Bearer " + encoded;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2Token that = (OAuth2Token)o;
        return Objects.equals(this.tokenType, that.tokenType) && Objects.equals(this.accessToken, that.accessToken);
    }

    public int hashCode() {
        int result = this.tokenType != null ? this.tokenType.hashCode() : 0;
        result = 31 * result + (this.accessToken != null ? this.accessToken.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "OAuth2Token{tokenType='" + this.tokenType + '\'' + ", accessToken='" + this.accessToken + '\'' + '}';
    }

    private static String getRawString(String name, JSONObject json) {
        try {
            if (json.isNull(name)) {
                return null;
            }
            return json.getString(name);
        }
        catch (JSONException jsone) {
            return null;
        }
    }
}

