/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.catalog.sbom;

import java.util.Objects;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.catalog.sbom.ProjectSbomCatalogers;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.catalog.sbom.SbomCataloger;
import org.jreleaser.model.spi.catalog.CatalogProcessingException;
import org.jreleaser.model.spi.catalog.sbom.SbomCatalogerProcessor;

public class ProjectSbomCataloger {
    private final JReleaserContext context;
    private final SbomCataloger<?> cataloger;

    private ProjectSbomCataloger(JReleaserContext context, SbomCataloger<?> cataloger) {
        this.context = context;
        this.cataloger = cataloger;
    }

    public SbomCataloger<?> getSbomCataloger() {
        return this.cataloger;
    }

    public SbomCatalogerProcessor.Result catalog() throws CatalogProcessingException {
        if (!this.cataloger.isEnabled()) {
            this.context.getLogger().debug(RB.$((String)"catalogers.skip.catalog", (Object[])new Object[0]), new Object[]{this.cataloger.getType()});
            return SbomCatalogerProcessor.Result.SKIPPED;
        }
        return ProjectSbomCatalogers.findSbomCataloger(this.context, this.cataloger).catalog();
    }

    public static ProjectSbomCatalogerBuilder builder() {
        return new ProjectSbomCatalogerBuilder();
    }

    public static class ProjectSbomCatalogerBuilder {
        private JReleaserContext context;
        private SbomCataloger<?> cataloger;

        public ProjectSbomCatalogerBuilder context(JReleaserContext context) {
            this.context = Objects.requireNonNull(context, "'context' must not be null");
            return this;
        }

        public ProjectSbomCatalogerBuilder cataloger(SbomCataloger<?> cataloger) {
            this.cataloger = Objects.requireNonNull(cataloger, "'cataloger' must not be null");
            return this;
        }

        public ProjectSbomCataloger build() {
            Objects.requireNonNull(this.context, "'context' must not be null");
            Objects.requireNonNull(this.cataloger, "'cataloger' must not be null");
            return new ProjectSbomCataloger(this.context, this.cataloger);
        }
    }
}

