/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.distribution;

import java.util.List;
import java.util.Locale;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.distribution.DistributionProcessor;
import org.jreleaser.extensions.api.workflow.WorkflowListenerException;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.api.JReleaserCommand;
import org.jreleaser.model.api.hooks.ExecutionEvent;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.JReleaserSupport;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.Packager;
import org.jreleaser.model.spi.packagers.PackagerProcessingException;

public final class Distributions {
    private Distributions() {
    }

    public static void process(JReleaserContext context, DistributionProcessor.PackagingAction action) {
        List activeDistributions = context.getModel().getActiveDistributions();
        if (activeDistributions.isEmpty()) {
            context.getLogger().debug(RB.$((String)"distributions.not.enabled", (Object[])new Object[0]), new Object[]{action.getText().toLowerCase(Locale.ENGLISH)});
            return;
        }
        if (!context.getIncludedDistributions().isEmpty()) {
            for (String distributionName : context.getIncludedDistributions()) {
                Distribution distribution = activeDistributions.stream().filter(d -> distributionName.equals(d.getName())).findFirst().orElse(null);
                if (null == distribution) {
                    context.getLogger().error(RB.$((String)"distributions.no.match", (Object[])new Object[0]), new Object[]{distributionName});
                    return;
                }
                if (!context.getIncludedPackagers().isEmpty()) {
                    for (String packagerName : context.getIncludedPackagers()) {
                        if (!JReleaserSupport.supportedPackagers().contains(packagerName)) {
                            context.getLogger().warn(RB.$((String)"ERROR_unsupported_packager", (Object[])new Object[]{packagerName}));
                            continue;
                        }
                        context.getLogger().info(RB.$((String)"distributions.apply.action", (Object[])new Object[0]), new Object[]{action.getText()});
                        Distributions.processDistribution(context, distribution, packagerName, action);
                    }
                    continue;
                }
                Distributions.processDistribution(context, distribution, action);
            }
        } else if (!context.getIncludedPackagers().isEmpty()) {
            for (String packagerName : context.getIncludedPackagers()) {
                if (!JReleaserSupport.supportedPackagers().contains(packagerName)) {
                    context.getLogger().warn(RB.$((String)"ERROR_unsupported_packager", (Object[])new Object[]{packagerName}));
                    continue;
                }
                context.getLogger().info(RB.$((String)"distributions.apply.action", (Object[])new Object[0]), new Object[]{action.getText()});
                for (Distribution distribution : activeDistributions) {
                    Distributions.processDistribution(context, distribution, packagerName, action);
                }
            }
        } else {
            context.getLogger().info(RB.$((String)"distributions.apply.action", (Object[])new Object[0]), new Object[]{action.getText()});
            for (Distribution distribution : activeDistributions) {
                if (context.getExcludedDistributions().contains(distribution.getName())) {
                    context.getLogger().info(RB.$((String)"distributions.distribution.excluded", (Object[])new Object[0]), new Object[]{distribution.getName()});
                    continue;
                }
                Distributions.processDistribution(context, distribution, action);
            }
        }
    }

    private static void processDistribution(JReleaserContext context, Distribution distribution, DistributionProcessor.PackagingAction action) {
        context.getLogger().increaseIndent();
        context.getLogger().info(RB.$((String)"distributions.apply.action.to", (Object[])new Object[0]), new Object[]{action.getText(), distribution.getName()});
        Distributions.fireDistributionStartEvent(context, distribution);
        for (String packagerName : JReleaserSupport.supportedPackagers()) {
            if (context.getExcludedPackagers().contains(packagerName)) {
                context.getLogger().info(RB.$((String)"packagers.packager.excluded", (Object[])new Object[0]), new Object[]{packagerName});
                continue;
            }
            Distributions.processPackager(context, distribution, packagerName, action);
        }
        Distributions.fireDistributionEndEvent(context, distribution);
        context.getLogger().decreaseIndent();
    }

    private static void processDistribution(JReleaserContext context, Distribution distribution, String packagerName, DistributionProcessor.PackagingAction action) {
        context.getLogger().increaseIndent();
        context.getLogger().info(RB.$((String)"distributions.apply.action.to", (Object[])new Object[0]), new Object[]{action.getText(), distribution.getName()});
        Distributions.processPackager(context, distribution, packagerName, action);
        context.getLogger().decreaseIndent();
    }

    private static void processPackager(JReleaserContext context, Distribution distribution, String packagerName, DistributionProcessor.PackagingAction action) {
        Packager packager = distribution.findPackager(packagerName);
        try {
            context.getLogger().increaseIndent();
            context.getLogger().setPrefix(packagerName);
            Distributions.firePackagerEvent(ExecutionEvent.before((String)Distributions.actionToStep(action.getType())), context, distribution, action.getType(), packager);
            DistributionProcessor processor = Distributions.createDistributionProcessor(context, distribution, packagerName);
            action.getFunction().consume(processor);
            Distributions.firePackagerEvent(ExecutionEvent.success((String)Distributions.actionToStep(action.getType())), context, distribution, action.getType(), packager);
        }
        catch (PackagerProcessingException e) {
            Distributions.firePackagerEvent(ExecutionEvent.failure((String)Distributions.actionToStep(action.getType()), (Throwable)e), context, distribution, action.getType(), packager);
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
        finally {
            context.getLogger().restorePrefix();
            context.getLogger().decreaseIndent();
        }
    }

    private static String actionToStep(DistributionProcessor.PackagingAction.Type type) {
        switch (type) {
            case PACKAGE: {
                return JReleaserCommand.PACKAGE.toStep();
            }
            case PUBLISH: {
                return JReleaserCommand.PUBLISH.toStep();
            }
        }
        return JReleaserCommand.PREPARE.toStep();
    }

    private static DistributionProcessor createDistributionProcessor(JReleaserContext context, Distribution distribution, String packagerName) {
        return DistributionProcessor.builder().context(context).distributionName(distribution.getName()).packagerName(packagerName).build();
    }

    private static void fireDistributionStartEvent(JReleaserContext context, Distribution distribution) {
        block3: {
            try {
                context.fireDistributionStartEvent(distribution.asImmutable());
            }
            catch (WorkflowListenerException e) {
                context.getLogger().error(RB.$((String)"listener.failure", (Object[])new Object[]{e.getListener().getClass().getName()}));
                context.getLogger().trace((Throwable)e);
                if (e.getListener().isContinueOnError()) break block3;
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new JReleaserException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), e.getCause());
            }
        }
    }

    private static void fireDistributionEndEvent(JReleaserContext context, Distribution distribution) {
        block4: {
            if (!distribution.isEnabled()) {
                return;
            }
            try {
                context.fireDistributionEndEvent(distribution.asImmutable());
            }
            catch (WorkflowListenerException e) {
                context.getLogger().error(RB.$((String)"listener.failure", (Object[])new Object[]{e.getListener().getClass().getName()}));
                context.getLogger().trace((Throwable)e);
                if (e.getListener().isContinueOnError()) break block4;
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new JReleaserException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), e.getCause());
            }
        }
    }

    private static void firePackagerEvent(ExecutionEvent event, JReleaserContext context, Distribution distribution, DistributionProcessor.PackagingAction.Type type, Packager<?> packager) {
        block9: {
            if (!packager.isEnabled()) {
                return;
            }
            try {
                switch (type) {
                    case PREPARE: {
                        context.firePackagerPrepareEvent(event, distribution.asImmutable(), packager.asImmutable());
                        break;
                    }
                    case PACKAGE: {
                        context.firePackagerPackageEvent(event, distribution.asImmutable(), packager.asImmutable());
                        break;
                    }
                    case PUBLISH: {
                        context.firePackagerPublishEvent(event, distribution.asImmutable(), packager.asImmutable());
                    }
                }
            }
            catch (WorkflowListenerException e) {
                context.getLogger().error(RB.$((String)"listener.failure", (Object[])new Object[]{e.getListener().getClass().getName()}));
                context.getLogger().trace((Throwable)e);
                if (event.getType() == ExecutionEvent.Type.FAILURE || e.getListener().isContinueOnError()) break block9;
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new JReleaserException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), e.getCause());
            }
        }
    }
}

