/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.workflow;

import java.util.Arrays;
import java.util.Collections;
import org.jreleaser.model.api.JReleaserCommand;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.workflow.AnnounceWorkflowItem;
import org.jreleaser.workflow.AssembleWorkflowItem;
import org.jreleaser.workflow.CatalogWorkflowItem;
import org.jreleaser.workflow.ChangelogWorkflowItem;
import org.jreleaser.workflow.ChecksumWorkflowItem;
import org.jreleaser.workflow.DeployWorkflowItem;
import org.jreleaser.workflow.DownloadWorkflowItem;
import org.jreleaser.workflow.PackageWorkflowItem;
import org.jreleaser.workflow.PrepareWorkflowItem;
import org.jreleaser.workflow.PublishWorkflowItem;
import org.jreleaser.workflow.ReleaseWorkflowItem;
import org.jreleaser.workflow.SignWorkflowItem;
import org.jreleaser.workflow.UploadWorkflowItem;
import org.jreleaser.workflow.Workflow;
import org.jreleaser.workflow.WorkflowImpl;

public final class Workflows {
    private Workflows() {
    }

    public static Workflow download(JReleaserContext context) {
        context.setCommand(JReleaserCommand.DOWNLOAD);
        return new WorkflowImpl(context, Collections.singletonList(new DownloadWorkflowItem()));
    }

    public static Workflow assemble(JReleaserContext context) {
        context.setCommand(JReleaserCommand.ASSEMBLE);
        return new WorkflowImpl(context, Collections.singletonList(new AssembleWorkflowItem()));
    }

    public static Workflow changelog(JReleaserContext context) {
        context.setCommand(JReleaserCommand.CHANGELOG);
        return new WorkflowImpl(context, Collections.singletonList(new ChangelogWorkflowItem()));
    }

    public static Workflow checksum(JReleaserContext context) {
        context.setCommand(JReleaserCommand.CHECKSUM);
        return new WorkflowImpl(context, Collections.singletonList(new ChecksumWorkflowItem()));
    }

    public static Workflow catalog(JReleaserContext context) {
        context.setCommand(JReleaserCommand.CATALOG);
        return new WorkflowImpl(context, Arrays.asList(new CatalogWorkflowItem(), new ChecksumWorkflowItem()));
    }

    public static Workflow sign(JReleaserContext context) {
        context.setCommand(JReleaserCommand.SIGN);
        return new WorkflowImpl(context, Arrays.asList(new ChecksumWorkflowItem(), new CatalogWorkflowItem(), new SignWorkflowItem()));
    }

    public static Workflow deploy(JReleaserContext context) {
        context.setCommand(JReleaserCommand.DEPLOY);
        return new WorkflowImpl(context, Collections.singletonList(new DeployWorkflowItem()));
    }

    public static Workflow upload(JReleaserContext context) {
        context.setCommand(JReleaserCommand.UPLOAD);
        return new WorkflowImpl(context, Arrays.asList(new ChecksumWorkflowItem(), new CatalogWorkflowItem(), new SignWorkflowItem(), new UploadWorkflowItem()));
    }

    public static Workflow release(JReleaserContext context) {
        context.setCommand(JReleaserCommand.RELEASE);
        return new WorkflowImpl(context, Arrays.asList(new ChangelogWorkflowItem(), new ChecksumWorkflowItem(), new CatalogWorkflowItem(), new SignWorkflowItem(), new DeployWorkflowItem(), new UploadWorkflowItem(), new ReleaseWorkflowItem()));
    }

    public static Workflow prepare(JReleaserContext context) {
        context.setCommand(JReleaserCommand.PREPARE);
        return new WorkflowImpl(context, Arrays.asList(new ChecksumWorkflowItem(), new PrepareWorkflowItem()));
    }

    public static Workflow packageRelease(JReleaserContext context) {
        context.setCommand(JReleaserCommand.PACKAGE);
        return new WorkflowImpl(context, Arrays.asList(new ChecksumWorkflowItem(), new PrepareWorkflowItem(), new PackageWorkflowItem()));
    }

    public static Workflow publish(JReleaserContext context) {
        context.setCommand(JReleaserCommand.PUBLISH);
        return new WorkflowImpl(context, Arrays.asList(new ChecksumWorkflowItem(), new PrepareWorkflowItem(), new PackageWorkflowItem(), new PublishWorkflowItem()));
    }

    public static Workflow announce(JReleaserContext context) {
        context.setCommand(JReleaserCommand.ANNOUNCE);
        return new WorkflowImpl(context, Arrays.asList(new ChangelogWorkflowItem(), new AnnounceWorkflowItem()));
    }

    public static Workflow fullRelease(JReleaserContext context) {
        context.setCommand(JReleaserCommand.FULL_RELEASE);
        return new WorkflowImpl(context, Arrays.asList(new ChangelogWorkflowItem(), new ChecksumWorkflowItem(), new CatalogWorkflowItem(), new SignWorkflowItem(), new DeployWorkflowItem(), new UploadWorkflowItem(), new ReleaseWorkflowItem(), new PrepareWorkflowItem(), new PackageWorkflowItem(), new PublishWorkflowItem(), new AnnounceWorkflowItem()));
    }
}

