/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.scope.ElementClassHint;

public final class ElementClassFilter
implements ElementFilter {
    public static final ElementClassFilter PACKAGE = new ElementClassFilter(ElementClassHint.DeclarationKind.PACKAGE);
    public static final ElementClassFilter VARIABLE = new ElementClassFilter(ElementClassHint.DeclarationKind.VARIABLE);
    public static final ElementClassFilter METHOD = new ElementClassFilter(ElementClassHint.DeclarationKind.METHOD);
    public static final ElementClassFilter CLASS = new ElementClassFilter(ElementClassHint.DeclarationKind.CLASS);
    public static final ElementClassFilter FIELD = new ElementClassFilter(ElementClassHint.DeclarationKind.FIELD);
    public static final ElementClassFilter ENUM_CONST = new ElementClassFilter(ElementClassHint.DeclarationKind.ENUM_CONST);
    private final ElementClassHint.DeclarationKind myKind;

    private ElementClassFilter(ElementClassHint.DeclarationKind kind) {
        this.myKind = kind;
    }

    @Override
    public boolean isAcceptable(Object element, PsiElement context) {
        switch (this.myKind) {
            case CLASS: {
                return element instanceof PsiClass;
            }
            case ENUM_CONST: {
                return element instanceof PsiEnumConstant;
            }
            case FIELD: {
                return element instanceof PsiField;
            }
            case METHOD: {
                return element instanceof PsiMethod;
            }
            case PACKAGE: {
                return element instanceof PsiPackage;
            }
            case VARIABLE: {
                return element instanceof PsiVariable;
            }
        }
        return false;
    }

    @Override
    public boolean isClassAcceptable(Class hintClass) {
        return true;
    }
}

