/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.containers.FastUtilCaseInsensitiveStringHashingStrategy;
import it.unimi.dsi.fastutil.Hash;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class FastUtilHashingStrategies
implements Hash.Strategy<CharSequence> {
    private static final Hash.Strategy<CharSequence> CASE_SENSITIVE = new FastUtilHashingStrategies(true);
    private static final Hash.Strategy<CharSequence> CASE_INSENSITIVE = new FastUtilHashingStrategies(false);
    private final boolean isCaseSensitive;

    @NotNull
    public static Hash.Strategy<CharSequence> getCharSequenceStrategy(boolean isCaseSensitive) {
        Hash.Strategy<CharSequence> strategy = isCaseSensitive ? CASE_SENSITIVE : CASE_INSENSITIVE;
        if (strategy == null) {
            FastUtilHashingStrategies.$$$reportNull$$$0(0);
        }
        return strategy;
    }

    @NotNull
    public static Hash.Strategy<String> getCaseInsensitiveStringStrategy() {
        Hash.Strategy<String> strategy = FastUtilCaseInsensitiveStringHashingStrategy.INSTANCE;
        if (strategy == null) {
            FastUtilHashingStrategies.$$$reportNull$$$0(2);
        }
        return strategy;
    }

    private FastUtilHashingStrategies(boolean caseSensitive) {
        this.isCaseSensitive = caseSensitive;
    }

    @Override
    public int hashCode(CharSequence o) {
        if (o == null) {
            return 0;
        }
        return this.isCaseSensitive ? StringUtil.stringHashCode(o) : StringUtil.stringHashCodeInsensitive(o);
    }

    @Override
    public boolean equals(CharSequence s1, CharSequence s2) {
        return StringUtilRt.equal(s1, s2, this.isCaseSensitive);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/util/containers/FastUtilHashingStrategies";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharSequenceStrategy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringStrategy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaseInsensitiveStringStrategy";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalStrategy";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

