/*
 * Decompiled with CFR 0.152.
 */
package javaslang.match;

import java.util.Arrays;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.processing.Messager;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import javax.tools.Diagnostic;

class UnapplyChecker {
    static boolean isValid(ExecutableElement elem, Messager messager) {
        return UnapplyChecker.ensure(elem, UnapplyChecker.doesNotThrow(elem), messager, () -> "@Unapply method should not throw (checked) exceptions.") && UnapplyChecker.ensure(elem, !elem.isDefault(), messager, () -> "@Unapply method needs to be declared in a class, not an interface.") && UnapplyChecker.ensure(elem, !elem.isVarArgs(), messager, () -> "@Unapply method has varargs.") && UnapplyChecker.ensure(elem, elem.getParameters().size() == 1, messager, () -> "Unapply method must have exactly one parameter of the object to be deconstructed.") && UnapplyChecker.ensure(elem, elem.getParameters().get(0).asType().getKind() == TypeKind.DECLARED, messager, () -> "Unapply method parameter must be a declared type.") && UnapplyChecker.ensure(elem, elem.getReturnType().toString().startsWith("javaslang.Tuple"), messager, () -> "Return type of unapply method must be a Tuple.") && UnapplyChecker.ensure(elem, !elem.getReturnType().toString().endsWith("Tuple"), messager, () -> "Return type is no Tuple implementation.") && UnapplyChecker.ensure(elem, UnapplyChecker.hasAll(elem, Modifier.STATIC), messager, () -> "Unapply method needs to be static.") && UnapplyChecker.ensure(elem, UnapplyChecker.hasNone(elem, Modifier.PRIVATE, Modifier.PROTECTED, Modifier.ABSTRACT), messager, () -> "Unapply method may not be private or protected.");
    }

    private static boolean ensure(ExecutableElement elem, boolean condition, Messager messager, Supplier<String> msg2) {
        if (!condition) {
            messager.printMessage(Diagnostic.Kind.ERROR, msg2.get(), elem);
        }
        return condition;
    }

    private static boolean hasAll(ExecutableElement elem, Modifier ... modifiers2) {
        return elem.getModifiers().containsAll(Arrays.asList(modifiers2));
    }

    private static boolean hasNone(ExecutableElement elem, Modifier ... modifiers2) {
        Set<Modifier> set = elem.getModifiers();
        for (Modifier modifier : modifiers2) {
            if (!set.contains((Object)modifier)) continue;
            return false;
        }
        return true;
    }

    private static boolean doesNotThrow(ExecutableElement elem) {
        return elem.getThrownTypes().isEmpty();
    }
}

