/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub.file;

import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.DirectoryBasedClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinderKt;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmNameResolver;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmProtoBufUtil;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.serialization.deserialization.ClassData;
import org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/DirectoryBasedDataFinder;", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassDataFinder;", "classFinder", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/DirectoryBasedClassFinder;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "(Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/DirectoryBasedClassFinder;Lcom/intellij/openapi/diagnostic/Logger;)V", "getClassFinder", "()Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/DirectoryBasedClassFinder;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "findClassData", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassData;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "decompiler-to-file-stubs"})
public final class DirectoryBasedDataFinder
implements ClassDataFinder {
    @NotNull
    private final DirectoryBasedClassFinder classFinder;
    @NotNull
    private final Logger log;

    public DirectoryBasedDataFinder(@NotNull DirectoryBasedClassFinder classFinder, @NotNull Logger log2) {
        Intrinsics.checkNotNullParameter((Object)classFinder, (String)"classFinder");
        Intrinsics.checkNotNullParameter((Object)log2, (String)"log");
        this.classFinder = classFinder;
        this.log = log2;
    }

    @NotNull
    public final DirectoryBasedClassFinder getClassFinder() {
        return this.classFinder;
    }

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    @Override
    @Nullable
    public ClassData findClassData(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        KotlinJvmBinaryClass kotlinJvmBinaryClass2 = KotlinClassFinderKt.findKotlinClass((KotlinClassFinder)this.classFinder, classId);
        if (kotlinJvmBinaryClass2 == null) {
            return null;
        }
        KotlinJvmBinaryClass binaryClass = kotlinJvmBinaryClass2;
        KotlinClassHeader classHeader = binaryClass.getClassHeader();
        String[] data = classHeader.getData();
        if (data == null) {
            this.log.error("Annotation data missing for " + binaryClass.getClassId());
            return null;
        }
        String[] strings2 = classHeader.getStrings();
        if (strings2 == null) {
            this.log.error("String table not found in class " + binaryClass.getClassId());
            return null;
        }
        Pair<JvmNameResolver, ProtoBuf.Class> pair = JvmProtoBufUtil.readClassDataFrom(data, strings2);
        JvmNameResolver nameResolver2 = (JvmNameResolver)pair.component1();
        ProtoBuf.Class classProto = (ProtoBuf.Class)pair.component2();
        return new ClassData(nameResolver2, classProto, classHeader.getMetadataVersion(), new KotlinJvmBinarySourceElement(binaryClass, null, false, null, 14, null));
    }
}

