/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.extensions;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.extensions.FirPredicateBasedProvider;
import org.jetbrains.kotlin.fir.extensions.FirRegisteredPluginAnnotations;
import org.jetbrains.kotlin.fir.extensions.FirRegisteredPluginAnnotationsKt;
import org.jetbrains.kotlin.fir.extensions.predicate.AncestorAnnotatedWith;
import org.jetbrains.kotlin.fir.extensions.predicate.AncestorMetaAnnotatedWith;
import org.jetbrains.kotlin.fir.extensions.predicate.AnnotatedWith;
import org.jetbrains.kotlin.fir.extensions.predicate.DeclarationPredicate;
import org.jetbrains.kotlin.fir.extensions.predicate.DeclarationPredicateVisitor;
import org.jetbrains.kotlin.fir.extensions.predicate.HasAnnotatedWith;
import org.jetbrains.kotlin.fir.extensions.predicate.HasMetaAnnotatedWith;
import org.jetbrains.kotlin.fir.extensions.predicate.MetaAnnotated;
import org.jetbrains.kotlin.fir.extensions.predicate.MetaAnnotatedWith;
import org.jetbrains.kotlin.fir.extensions.predicate.ParentAnnotatedWith;
import org.jetbrains.kotlin.fir.extensions.predicate.ParentMetaAnnotatedWith;
import org.jetbrains.kotlin.fir.resolve.CallableIdUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010\u000f\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u001bH\u0016J\u001e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u001bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl;", "Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProvider;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "cache", "Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl$Cache;", "matcher", "Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl$Matcher;", "registeredPluginAnnotations", "Lorg/jetbrains/kotlin/fir/extensions/FirRegisteredPluginAnnotations;", "fileHasPluginAnnotations", "", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getOwnersOfDeclaration", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "getSymbolsByPredicate", "predicate", "Lorg/jetbrains/kotlin/fir/extensions/predicate/DeclarationPredicate;", "matches", "registerAnnotatedDeclaration", "", "owners", "Lkotlinx/collections/immutable/PersistentList;", "registerOwnersDeclarations", "Cache", "Matcher", "resolve"})
public final class FirPredicateBasedProviderImpl
extends FirPredicateBasedProvider {
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirRegisteredPluginAnnotations registeredPluginAnnotations;
    @NotNull
    private final Cache cache;
    @NotNull
    private final Matcher matcher;

    public FirPredicateBasedProviderImpl(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
        this.registeredPluginAnnotations = FirRegisteredPluginAnnotationsKt.getRegisteredPluginAnnotations(this.session);
        this.cache = new Cache();
        this.matcher = new Matcher();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<FirBasedSymbol<?>> getSymbolsByPredicate(@NotNull DeclarationPredicate predicate) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        FirDeclaration it;
        void $this$filterTo$iv$iv;
        void destination$iv;
        void $this$flatMapTo$iv;
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        Set<FqName> annotations2 = this.registeredPluginAnnotations.getAnnotationsForPredicate(predicate);
        if (annotations2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable iterable = annotations2;
        Collection collection = new LinkedHashSet();
        boolean $i$f$flatMapTo22 = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            FqName it2 = (FqName)element$iv;
            boolean bl = false;
            Collection<FirDeclaration> collection2 = this.cache.getDeclarationByAnnotation().get(it2);
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"cache.declarationByAnnotation[it]");
            Collection<FirDeclaration> collection3 = this.cache.getDeclarationsUnderAnnotated().get(it2);
            Intrinsics.checkNotNullExpressionValue(collection3, (String)"cache.declarationsUnderAnnotated[it]");
            Iterable list$iv = CollectionsKt.plus(collection2, (Iterable)collection3);
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        Set declarations2 = (Set)destination$iv;
        Iterable $this$filter$iv = declarations2;
        boolean $i$f$filter = false;
        Iterable $i$f$flatMapTo22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (FirDeclaration)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (!this.matches(predicate, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (FirDeclaration)item$iv$iv;
            Collection collection4 = destination$iv$iv;
            boolean bl = false;
            collection4.add(it.getSymbol());
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean fileHasPluginAnnotations(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.cache.getFilesWithPluginAnnotations().contains(file2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void registerAnnotatedDeclaration(@NotNull FirDeclaration declaration, @NotNull PersistentList<? extends FirDeclaration> owners) {
        FqName it;
        void $this$filterTo$iv$iv;
        List $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter(owners, (String)"owners");
        this.cache.getOwnersForDeclaration().put(declaration, owners);
        this.registerOwnersDeclarations(declaration, owners);
        if (declaration.getAnnotations().isEmpty()) {
            return;
        }
        Iterable iterable = declaration.getAnnotations();
        boolean $i$f$mapNotNull = false;
        void var7_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FqName it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirAnnotation it2 = (FirAnnotation)element$iv$iv;
            boolean bl2 = false;
            if (CallableIdUtilsKt.fqName(it2, this.session) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (FqName)element$iv$iv;
            boolean bl = false;
            if (!this.registeredPluginAnnotations.getAnnotations().contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it3 = $this$filter$iv = (List)destination$iv$iv;
        boolean bl = false;
        List list2 = !((Collection)it3).isEmpty() ? $this$filter$iv : null;
        if (list2 == null) {
            return;
        }
        List matchingAnnotations = list2;
        FirDeclaration firDeclaration = (FirDeclaration)CollectionsKt.lastOrNull((List)owners);
        if (firDeclaration != null) {
            FirDeclaration owner = firDeclaration;
            boolean bl4 = false;
            Iterable $this$forEach$iv = matchingAnnotations;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FqName)element$iv;
                boolean bl5 = false;
                this.cache.getDeclarationsHasAnnotated().put(it, owner);
            }
            this.cache.getAnnotationsOfHasAnnotated().putAll(owner, matchingAnnotations);
        }
        Iterable $this$forEach$iv = matchingAnnotations;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv) {
            FqName it4 = (FqName)element$iv;
            boolean bl6 = false;
            this.cache.getDeclarationByAnnotation().put(it4, declaration);
        }
        this.cache.getAnnotationsOfDeclaration().putAll((Object)declaration, matchingAnnotations);
        Object object = CollectionsKt.first((List)owners);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirFile");
        FirFile file2 = (FirFile)object;
        ((Collection)this.cache.getFilesWithPluginAnnotations()).add(file2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public List<FirBasedSymbol<?>> getOwnersOfDeclaration(@NotNull FirDeclaration declaration) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        PersistentList<FirDeclaration> persistentList = this.cache.getOwnersForDeclaration().get(declaration);
        if (persistentList != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = persistentList;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirDeclaration firDeclaration = (FirDeclaration)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getSymbol());
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        return list2;
    }

    private final void registerOwnersDeclarations(FirDeclaration declaration, PersistentList<? extends FirDeclaration> owners) {
        FirDeclaration firDeclaration = (FirDeclaration)CollectionsKt.lastOrNull((List)owners);
        if (firDeclaration == null) {
            return;
        }
        FirDeclaration lastOwner = firDeclaration;
        Set annotationsFromLastOwner = this.cache.getAnnotationsOfDeclaration().get((Object)lastOwner);
        Set annotationsFromPreviousOwners = this.cache.getAnnotationsOfUnderAnnotated().get((Object)lastOwner);
        Intrinsics.checkNotNullExpressionValue((Object)annotationsFromLastOwner, (String)"annotationsFromLastOwner");
        Iterable $this$forEach$iv = annotationsFromLastOwner;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FqName it = (FqName)element$iv;
            boolean bl = false;
            this.cache.getDeclarationsParentAnnotated().put(it, declaration);
        }
        this.cache.getAnnotationsOfParentAnnotated().putAll(declaration, annotationsFromLastOwner);
        Intrinsics.checkNotNullExpressionValue((Object)annotationsFromPreviousOwners, (String)"annotationsFromPreviousOwners");
        Set allParentDeclarations = SetsKt.plus((Set)annotationsFromLastOwner, (Iterable)annotationsFromPreviousOwners);
        Iterable $this$forEach$iv2 = allParentDeclarations;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            FqName it = (FqName)element$iv;
            boolean bl = false;
            this.cache.getDeclarationsUnderAnnotated().put(it, declaration);
        }
        this.cache.getAnnotationsOfUnderAnnotated().putAll((Object)declaration, (Iterable)allParentDeclarations);
    }

    @Override
    public boolean matches(@NotNull DeclarationPredicate predicate, @NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return (Boolean)predicate.accept(this.matcher, declaration);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR!\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR!\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR!\u0010\u0012\u001a\u0012\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR!\u0010\u0014\u001a\u0012\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR!\u0010\u0016\u001a\u0012\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR!\u0010\u0018\u001a\u0012\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\rR\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR#\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050!0 \u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl$Cache;", "", "()V", "annotationsOfDeclaration", "Lcom/google/common/collect/LinkedHashMultimap;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/extensions/AnnotationFqn;", "getAnnotationsOfDeclaration", "()Lcom/google/common/collect/LinkedHashMultimap;", "annotationsOfHasAnnotated", "Lcom/google/common/collect/Multimap;", "getAnnotationsOfHasAnnotated", "()Lcom/google/common/collect/Multimap;", "annotationsOfParentAnnotated", "getAnnotationsOfParentAnnotated", "annotationsOfUnderAnnotated", "getAnnotationsOfUnderAnnotated", "declarationByAnnotation", "getDeclarationByAnnotation", "declarationsHasAnnotated", "getDeclarationsHasAnnotated", "declarationsParentAnnotated", "getDeclarationsParentAnnotated", "declarationsUnderAnnotated", "getDeclarationsUnderAnnotated", "filesWithPluginAnnotations", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getFilesWithPluginAnnotations", "()Ljava/util/Set;", "ownersForDeclaration", "", "Lkotlinx/collections/immutable/PersistentList;", "getOwnersForDeclaration", "()Ljava/util/Map;", "resolve"})
    private static final class Cache {
        @NotNull
        private final Multimap<FqName, FirDeclaration> declarationByAnnotation;
        @NotNull
        private final LinkedHashMultimap<FirDeclaration, FqName> annotationsOfDeclaration;
        @NotNull
        private final Multimap<FqName, FirDeclaration> declarationsUnderAnnotated;
        @NotNull
        private final LinkedHashMultimap<FirDeclaration, FqName> annotationsOfUnderAnnotated;
        @NotNull
        private final Multimap<FqName, FirDeclaration> declarationsParentAnnotated;
        @NotNull
        private final Multimap<FirDeclaration, FqName> annotationsOfParentAnnotated;
        @NotNull
        private final Multimap<FqName, FirDeclaration> declarationsHasAnnotated;
        @NotNull
        private final Multimap<FirDeclaration, FqName> annotationsOfHasAnnotated;
        @NotNull
        private final Map<FirDeclaration, PersistentList<FirDeclaration>> ownersForDeclaration;
        @NotNull
        private final Set<FirFile> filesWithPluginAnnotations;

        public Cache() {
            LinkedHashMultimap linkedHashMultimap = LinkedHashMultimap.create();
            Intrinsics.checkNotNullExpressionValue(linkedHashMultimap, (String)"create()");
            this.declarationByAnnotation = linkedHashMultimap;
            LinkedHashMultimap linkedHashMultimap2 = LinkedHashMultimap.create();
            Intrinsics.checkNotNullExpressionValue(linkedHashMultimap2, (String)"create()");
            this.annotationsOfDeclaration = linkedHashMultimap2;
            LinkedHashMultimap linkedHashMultimap3 = LinkedHashMultimap.create();
            Intrinsics.checkNotNullExpressionValue(linkedHashMultimap3, (String)"create()");
            this.declarationsUnderAnnotated = linkedHashMultimap3;
            LinkedHashMultimap linkedHashMultimap4 = LinkedHashMultimap.create();
            Intrinsics.checkNotNullExpressionValue(linkedHashMultimap4, (String)"create()");
            this.annotationsOfUnderAnnotated = linkedHashMultimap4;
            LinkedHashMultimap linkedHashMultimap5 = LinkedHashMultimap.create();
            Intrinsics.checkNotNullExpressionValue(linkedHashMultimap5, (String)"create()");
            this.declarationsParentAnnotated = linkedHashMultimap5;
            LinkedHashMultimap linkedHashMultimap6 = LinkedHashMultimap.create();
            Intrinsics.checkNotNullExpressionValue(linkedHashMultimap6, (String)"create()");
            this.annotationsOfParentAnnotated = linkedHashMultimap6;
            LinkedHashMultimap linkedHashMultimap7 = LinkedHashMultimap.create();
            Intrinsics.checkNotNullExpressionValue(linkedHashMultimap7, (String)"create()");
            this.declarationsHasAnnotated = linkedHashMultimap7;
            LinkedHashMultimap linkedHashMultimap8 = LinkedHashMultimap.create();
            Intrinsics.checkNotNullExpressionValue(linkedHashMultimap8, (String)"create()");
            this.annotationsOfHasAnnotated = linkedHashMultimap8;
            this.ownersForDeclaration = new LinkedHashMap();
            this.filesWithPluginAnnotations = new LinkedHashSet();
        }

        @NotNull
        public final Multimap<FqName, FirDeclaration> getDeclarationByAnnotation() {
            return this.declarationByAnnotation;
        }

        @NotNull
        public final LinkedHashMultimap<FirDeclaration, FqName> getAnnotationsOfDeclaration() {
            return this.annotationsOfDeclaration;
        }

        @NotNull
        public final Multimap<FqName, FirDeclaration> getDeclarationsUnderAnnotated() {
            return this.declarationsUnderAnnotated;
        }

        @NotNull
        public final LinkedHashMultimap<FirDeclaration, FqName> getAnnotationsOfUnderAnnotated() {
            return this.annotationsOfUnderAnnotated;
        }

        @NotNull
        public final Multimap<FqName, FirDeclaration> getDeclarationsParentAnnotated() {
            return this.declarationsParentAnnotated;
        }

        @NotNull
        public final Multimap<FirDeclaration, FqName> getAnnotationsOfParentAnnotated() {
            return this.annotationsOfParentAnnotated;
        }

        @NotNull
        public final Multimap<FqName, FirDeclaration> getDeclarationsHasAnnotated() {
            return this.declarationsHasAnnotated;
        }

        @NotNull
        public final Multimap<FirDeclaration, FqName> getAnnotationsOfHasAnnotated() {
            return this.annotationsOfHasAnnotated;
        }

        @NotNull
        public final Map<FirDeclaration, PersistentList<FirDeclaration>> getOwnersForDeclaration() {
            return this.ownersForDeclaration;
        }

        @NotNull
        public final Set<FirFile> getFilesWithPluginAnnotations() {
            return this.filesWithPluginAnnotations;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\"\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00032\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0006H\u0002J\"\u0010\u000f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00032\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0006H\u0002J\"\u0010\u0010\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00032\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0006H\u0002J\"\u0010\u0011\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00032\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0006H\u0002J\u001d\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0016J\u001d\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0019J\u001d\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u001d\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u001d\u0010 \u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\"J\u001d\u0010#\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020$2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010%J\u001d\u0010&\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020'2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010(J\u001d\u0010)\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020*2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010+J\u001d\u0010,\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020-2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010.J\u001d\u0010/\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u0002002\u0006\u0010\u0015\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u00101J\u001d\u00102\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u0002032\u0006\u0010\u0015\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u00104R\"\u0010\u0005\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0006*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl$Matcher;", "Lorg/jetbrains/kotlin/fir/extensions/predicate/DeclarationPredicateVisitor;", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "(Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl;)V", "userDefinedAnnotations", "", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/extensions/AnnotationFqn;", "Lorg/jetbrains/kotlin/fir/extensions/predicate/MetaAnnotated;", "getUserDefinedAnnotations", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/MetaAnnotated;)Ljava/util/Set;", "matchHasAnnotatedWith", "declaration", "annotations", "matchParentWith", "matchUnder", "matchWith", "visitAncestorAnnotatedWith", "predicate", "Lorg/jetbrains/kotlin/fir/extensions/predicate/AncestorAnnotatedWith;", "data", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/AncestorAnnotatedWith;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Ljava/lang/Boolean;", "visitAncestorMetaAnnotatedWith", "Lorg/jetbrains/kotlin/fir/extensions/predicate/AncestorMetaAnnotatedWith;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/AncestorMetaAnnotatedWith;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Ljava/lang/Boolean;", "visitAnd", "Lorg/jetbrains/kotlin/fir/extensions/predicate/DeclarationPredicate$And;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/DeclarationPredicate$And;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Ljava/lang/Boolean;", "visitAnnotatedWith", "Lorg/jetbrains/kotlin/fir/extensions/predicate/AnnotatedWith;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/AnnotatedWith;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Ljava/lang/Boolean;", "visitHasAnnotatedWith", "Lorg/jetbrains/kotlin/fir/extensions/predicate/HasAnnotatedWith;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/HasAnnotatedWith;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Ljava/lang/Boolean;", "visitHasMetaAnnotatedWith", "Lorg/jetbrains/kotlin/fir/extensions/predicate/HasMetaAnnotatedWith;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/HasMetaAnnotatedWith;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Ljava/lang/Boolean;", "visitMetaAnnotatedWith", "Lorg/jetbrains/kotlin/fir/extensions/predicate/MetaAnnotatedWith;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/MetaAnnotatedWith;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Ljava/lang/Boolean;", "visitOr", "Lorg/jetbrains/kotlin/fir/extensions/predicate/DeclarationPredicate$Or;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/DeclarationPredicate$Or;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Ljava/lang/Boolean;", "visitParentAnnotatedWith", "Lorg/jetbrains/kotlin/fir/extensions/predicate/ParentAnnotatedWith;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/ParentAnnotatedWith;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Ljava/lang/Boolean;", "visitParentMetaAnnotatedWith", "Lorg/jetbrains/kotlin/fir/extensions/predicate/ParentMetaAnnotatedWith;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/ParentMetaAnnotatedWith;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Ljava/lang/Boolean;", "visitPredicate", "Lorg/jetbrains/kotlin/fir/extensions/predicate/DeclarationPredicate;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/DeclarationPredicate;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Ljava/lang/Boolean;", "resolve"})
    private final class Matcher
    extends DeclarationPredicateVisitor<Boolean, FirDeclaration> {
        @Override
        @NotNull
        public Boolean visitPredicate(@NotNull DeclarationPredicate predicate, @NotNull FirDeclaration data) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            throw new IllegalStateException("Should not be there");
        }

        @Override
        @NotNull
        public Boolean visitAnd(@NotNull DeclarationPredicate.And predicate, @NotNull FirDeclaration data) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return (Boolean)predicate.getA().accept(this, data) != false && (Boolean)predicate.getB().accept(this, data) != false;
        }

        @Override
        @NotNull
        public Boolean visitOr(@NotNull DeclarationPredicate.Or predicate, @NotNull FirDeclaration data) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return (Boolean)predicate.getA().accept(this, data) != false || (Boolean)predicate.getB().accept(this, data) != false;
        }

        @Override
        @NotNull
        public Boolean visitAnnotatedWith(@NotNull AnnotatedWith predicate, @NotNull FirDeclaration data) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return this.matchWith(data, predicate.getAnnotations());
        }

        @Override
        @NotNull
        public Boolean visitAncestorAnnotatedWith(@NotNull AncestorAnnotatedWith predicate, @NotNull FirDeclaration data) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return this.matchUnder(data, predicate.getAnnotations());
        }

        @Override
        @NotNull
        public Boolean visitParentAnnotatedWith(@NotNull ParentAnnotatedWith predicate, @NotNull FirDeclaration data) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return this.matchParentWith(data, predicate.getAnnotations());
        }

        @Override
        @NotNull
        public Boolean visitHasAnnotatedWith(@NotNull HasAnnotatedWith predicate, @NotNull FirDeclaration data) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return this.matchHasAnnotatedWith(data, predicate.getAnnotations());
        }

        @Override
        @NotNull
        public Boolean visitMetaAnnotatedWith(@NotNull MetaAnnotatedWith predicate, @NotNull FirDeclaration data) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return this.matchWith(data, this.getUserDefinedAnnotations(predicate));
        }

        @Override
        @NotNull
        public Boolean visitAncestorMetaAnnotatedWith(@NotNull AncestorMetaAnnotatedWith predicate, @NotNull FirDeclaration data) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return this.matchUnder(data, this.getUserDefinedAnnotations(predicate));
        }

        @Override
        @NotNull
        public Boolean visitParentMetaAnnotatedWith(@NotNull ParentMetaAnnotatedWith predicate, @NotNull FirDeclaration data) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return this.matchParentWith(data, this.getUserDefinedAnnotations(predicate));
        }

        @Override
        @NotNull
        public Boolean visitHasMetaAnnotatedWith(@NotNull HasMetaAnnotatedWith predicate, @NotNull FirDeclaration data) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return this.matchHasAnnotatedWith(data, this.getUserDefinedAnnotations(predicate));
        }

        /*
         * WARNING - void declaration
         */
        private final Set<FqName> getUserDefinedAnnotations(MetaAnnotated $this$userDefinedAnnotations) {
            void $this$flatMapTo$iv;
            Iterable iterable = $this$userDefinedAnnotations.getMetaAnnotations();
            Collection collection = new LinkedHashSet();
            FirPredicateBasedProviderImpl firPredicateBasedProviderImpl = FirPredicateBasedProviderImpl.this;
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                void destination$iv;
                FqName it = (FqName)element$iv;
                boolean bl = false;
                Iterable list$iv = firPredicateBasedProviderImpl.registeredPluginAnnotations.getAnnotationsWithMetaAnnotation(it);
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
            return (Set)collection;
        }

        private final boolean matchWith(FirDeclaration declaration, Set<FqName> annotations2) {
            boolean bl;
            block3: {
                Set set = FirPredicateBasedProviderImpl.this.cache.getAnnotationsOfDeclaration().get((Object)declaration);
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"cache.annotationsOfDeclaration[declaration]");
                Iterable $this$any$iv = set;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FqName it = (FqName)element$iv;
                        boolean bl2 = false;
                        if (!annotations2.contains(it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean matchUnder(FirDeclaration declaration, Set<FqName> annotations2) {
            boolean bl;
            block3: {
                Set set = FirPredicateBasedProviderImpl.this.cache.getAnnotationsOfUnderAnnotated().get((Object)declaration);
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"cache.annotationsOfUnderAnnotated[declaration]");
                Iterable $this$any$iv = set;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FqName it = (FqName)element$iv;
                        boolean bl2 = false;
                        if (!annotations2.contains(it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean matchParentWith(FirDeclaration declaration, Set<FqName> annotations2) {
            boolean bl;
            block3: {
                Collection<FqName> collection = FirPredicateBasedProviderImpl.this.cache.getAnnotationsOfParentAnnotated().get(declaration);
                Intrinsics.checkNotNullExpressionValue(collection, (String)"cache.annotationsOfParentAnnotated[declaration]");
                Iterable $this$any$iv = collection;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FqName it = (FqName)element$iv;
                        boolean bl2 = false;
                        if (!annotations2.contains(it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean matchHasAnnotatedWith(FirDeclaration declaration, Set<FqName> annotations2) {
            boolean bl;
            block3: {
                Collection<FqName> collection = FirPredicateBasedProviderImpl.this.cache.getAnnotationsOfHasAnnotated().get(declaration);
                Intrinsics.checkNotNullExpressionValue(collection, (String)"cache.annotationsOfHasAnnotated[declaration]");
                Iterable $this$any$iv = collection;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FqName it = (FqName)element$iv;
                        boolean bl2 = false;
                        if (!annotations2.contains(it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }
    }
}

