/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.utils.JsAnnotations;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u001a\f\u0010\u0006\u001a\u0004\u0018\u00010\u0004*\u00020\u0007\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\t*\u0006\u0012\u0002\b\u00030\nH\u0002\u001a\u0012\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f*\u00020\u0007\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\t*\u00020\u000f\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\t*\u00020\u000f\u001a\f\u0010\u0011\u001a\u0004\u0018\u00010\t*\u00020\u0012\u001a\n\u0010\u0013\u001a\u00020\u0014*\u00020\u0012\u001a\f\u0010\u0015\u001a\u0004\u0018\u00010\t*\u00020\u000f\u001a\n\u0010\u0016\u001a\u00020\t*\u00020\u0007\u001a\n\u0010\u0017\u001a\u00020\u0003*\u00020\u000f\u001a\n\u0010\u0018\u001a\u00020\u0003*\u00020\u000f\u001a\n\u0010\u0019\u001a\u00020\u0003*\u00020\u000f\u001a\n\u0010\u001a\u001a\u00020\u0003*\u00020\u000f\u001a\n\u0010\u001b\u001a\u00020\u0003*\u00020\u000f\u001a\n\u0010\u001c\u001a\u00020\u0003*\u00020\u000f\u001a\n\u0010\u001d\u001a\u00020\u0003*\u00020\u000f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0002\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0005\u00a8\u0006\u001e"}, d2={"associatedObjectKeyAnnotationFqName", "Lorg/jetbrains/kotlin/name/FqName;", "isAssociatedObjectAnnotatedAnnotation", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Z", "associatedObject", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "dfsOverridableJsNameOrNull", "", "Lorg/jetbrains/kotlin/ir/declarations/IrOverridableDeclaration;", "getClassReferencVarargArguments", "", "Lorg/jetbrains/kotlin/ir/expressions/IrClassReference;", "getJsModule", "Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "getJsName", "getJsNameForOverriddenDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "getJsNameOrKotlinName", "Lorg/jetbrains/kotlin/name/Name;", "getJsQualifier", "getSingleConstStringArgument", "hasJsPolyfill", "isJsExport", "isJsImplicitExport", "isJsNativeGetter", "isJsNativeInvoke", "isJsNativeSetter", "isJsNonModule", "backend.js"})
public final class AnnotationUtilsKt {
    @NotNull
    private static final FqName associatedObjectKeyAnnotationFqName = new FqName("kotlin.reflect.AssociatedObjectKey");

    @NotNull
    public static final String getSingleConstStringArgument(@NotNull IrConstructorCall $this$getSingleConstStringArgument) {
        Intrinsics.checkNotNullParameter((Object)$this$getSingleConstStringArgument, (String)"<this>");
        IrExpression irExpression = $this$getSingleConstStringArgument.getValueArgument(0);
        Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst<kotlin.String>");
        return (String)((IrConst)irExpression).getValue();
    }

    @Nullable
    public static final List<IrClassReference> getClassReferencVarargArguments(@NotNull IrConstructorCall $this$getClassReferencVarargArguments) {
        Intrinsics.checkNotNullParameter((Object)$this$getClassReferencVarargArguments, (String)"<this>");
        IrExpression irExpression = $this$getClassReferencVarargArguments.getValueArgument(0);
        IrVararg irVararg = irExpression instanceof IrVararg ? (IrVararg)irExpression : null;
        List<IrVarargElement> list2 = irVararg != null ? irVararg.getElements() : null;
        return list2 instanceof List ? list2 : null;
    }

    @Nullable
    public static final String getJsModule(@NotNull IrAnnotationContainer $this$getJsModule) {
        Intrinsics.checkNotNullParameter((Object)$this$getJsModule, (String)"<this>");
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation($this$getJsModule, JsAnnotations.INSTANCE.getJsModuleFqn());
        return irConstructorCall != null ? AnnotationUtilsKt.getSingleConstStringArgument(irConstructorCall) : null;
    }

    public static final boolean isJsNonModule(@NotNull IrAnnotationContainer $this$isJsNonModule) {
        Intrinsics.checkNotNullParameter((Object)$this$isJsNonModule, (String)"<this>");
        return IrUtilsKt.hasAnnotation($this$isJsNonModule, JsAnnotations.INSTANCE.getJsNonModuleFqn());
    }

    @Nullable
    public static final String getJsQualifier(@NotNull IrAnnotationContainer $this$getJsQualifier) {
        Intrinsics.checkNotNullParameter((Object)$this$getJsQualifier, (String)"<this>");
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation($this$getJsQualifier, JsAnnotations.INSTANCE.getJsQualifierFqn());
        return irConstructorCall != null ? AnnotationUtilsKt.getSingleConstStringArgument(irConstructorCall) : null;
    }

    @Nullable
    public static final String getJsName(@NotNull IrAnnotationContainer $this$getJsName) {
        Intrinsics.checkNotNullParameter((Object)$this$getJsName, (String)"<this>");
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation($this$getJsName, JsAnnotations.INSTANCE.getJsNameFqn());
        return irConstructorCall != null ? AnnotationUtilsKt.getSingleConstStringArgument(irConstructorCall) : null;
    }

    public static final boolean hasJsPolyfill(@NotNull IrAnnotationContainer $this$hasJsPolyfill) {
        Intrinsics.checkNotNullParameter((Object)$this$hasJsPolyfill, (String)"<this>");
        return IrUtilsKt.hasAnnotation($this$hasJsPolyfill, JsAnnotations.INSTANCE.getJsPolyfillFqn());
    }

    public static final boolean isJsExport(@NotNull IrAnnotationContainer $this$isJsExport) {
        Intrinsics.checkNotNullParameter((Object)$this$isJsExport, (String)"<this>");
        return IrUtilsKt.hasAnnotation($this$isJsExport, JsAnnotations.INSTANCE.getJsExportFqn());
    }

    public static final boolean isJsImplicitExport(@NotNull IrAnnotationContainer $this$isJsImplicitExport) {
        Intrinsics.checkNotNullParameter((Object)$this$isJsImplicitExport, (String)"<this>");
        return IrUtilsKt.hasAnnotation($this$isJsImplicitExport, JsAnnotations.INSTANCE.getJsImplicitExportFqn());
    }

    public static final boolean isJsNativeGetter(@NotNull IrAnnotationContainer $this$isJsNativeGetter) {
        Intrinsics.checkNotNullParameter((Object)$this$isJsNativeGetter, (String)"<this>");
        return IrUtilsKt.hasAnnotation($this$isJsNativeGetter, JsAnnotations.INSTANCE.getJsNativeGetter());
    }

    public static final boolean isJsNativeSetter(@NotNull IrAnnotationContainer $this$isJsNativeSetter) {
        Intrinsics.checkNotNullParameter((Object)$this$isJsNativeSetter, (String)"<this>");
        return IrUtilsKt.hasAnnotation($this$isJsNativeSetter, JsAnnotations.INSTANCE.getJsNativeSetter());
    }

    public static final boolean isJsNativeInvoke(@NotNull IrAnnotationContainer $this$isJsNativeInvoke) {
        Intrinsics.checkNotNullParameter((Object)$this$isJsNativeInvoke, (String)"<this>");
        return IrUtilsKt.hasAnnotation($this$isJsNativeInvoke, JsAnnotations.INSTANCE.getJsNativeInvoke());
    }

    private static final String dfsOverridableJsNameOrNull(IrOverridableDeclaration<?> $this$dfsOverridableJsNameOrNull) {
        for (IrSymbol overriddenSymbol : $this$dfsOverridableJsNameOrNull.getOverriddenSymbols()) {
            String string2;
            IrSymbolOwner symbolOwner = overriddenSymbol.getOwner();
            if (symbolOwner instanceof IrAnnotationContainer && (string2 = AnnotationUtilsKt.getJsName((IrAnnotationContainer)((Object)symbolOwner))) != null) {
                String it = string2;
                boolean bl = false;
                return it;
            }
            if (!(symbolOwner instanceof IrOverridableDeclaration) || (string2 = AnnotationUtilsKt.dfsOverridableJsNameOrNull((IrOverridableDeclaration)symbolOwner)) == null) continue;
            String it = string2;
            boolean bl = false;
            return it;
        }
        return null;
    }

    @Nullable
    public static final String getJsNameForOverriddenDeclaration(@NotNull IrDeclarationWithName $this$getJsNameForOverriddenDeclaration) {
        Intrinsics.checkNotNullParameter((Object)$this$getJsNameForOverriddenDeclaration, (String)"<this>");
        String jsName = AnnotationUtilsKt.getJsName($this$getJsNameForOverriddenDeclaration);
        String string2 = jsName;
        if (string2 == null) {
            string2 = $this$getJsNameForOverriddenDeclaration instanceof IrOverridableDeclaration ? AnnotationUtilsKt.dfsOverridableJsNameOrNull((IrOverridableDeclaration)$this$getJsNameForOverriddenDeclaration) : null;
        }
        return string2;
    }

    @NotNull
    public static final Name getJsNameOrKotlinName(@NotNull IrDeclarationWithName $this$getJsNameOrKotlinName) {
        Name name;
        Intrinsics.checkNotNullParameter((Object)$this$getJsNameOrKotlinName, (String)"<this>");
        String jsName = AnnotationUtilsKt.getJsNameForOverriddenDeclaration($this$getJsNameOrKotlinName);
        if (jsName == null) {
            name = $this$getJsNameOrKotlinName.getName();
        } else {
            Name name2 = Name.identifier(jsName);
            name = name2;
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(jsName)");
        }
        return name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isAssociatedObjectAnnotatedAnnotation(@NotNull IrClass $this$isAssociatedObjectAnnotatedAnnotation) {
        IrConstructorCall it;
        Intrinsics.checkNotNullParameter((Object)$this$isAssociatedObjectAnnotatedAnnotation, (String)"<this>");
        if (!IrUtilsKt.isAnnotationClass($this$isAssociatedObjectAnnotatedAnnotation)) return false;
        Iterable $this$any$iv = $this$isAssociatedObjectAnnotatedAnnotation.getAnnotations();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (IrConstructorCall)element$iv;
            boolean bl = false;
        } while (!Intrinsics.areEqual((Object)IrUtilsKt.getFqNameWhenAvailable(AdditionalIrUtilsKt.getConstructedClass((IrConstructor)it.getSymbol().getOwner())), (Object)associatedObjectKeyAnnotationFqName));
        return true;
    }

    @Nullable
    public static final IrClass associatedObject(@NotNull IrConstructorCall $this$associatedObject) {
        Intrinsics.checkNotNullParameter((Object)$this$associatedObject, (String)"<this>");
        if (!AnnotationUtilsKt.isAssociatedObjectAnnotatedAnnotation(AdditionalIrUtilsKt.getConstructedClass((IrConstructor)$this$associatedObject.getSymbol().getOwner()))) {
            return null;
        }
        IrExpression irExpression = $this$associatedObject.getValueArgument(0);
        IrClassReference irClassReference = irExpression instanceof IrClassReference ? (IrClassReference)irExpression : null;
        IrClassifierSymbol irClassifierSymbol = irClassReference != null ? irClassReference.getSymbol() : null;
        Object object = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
        if (object == null || (object = (IrClass)object.getOwner()) == null) {
            return null;
        }
        Object klass = object;
        return IrUtilsKt.isObject((IrClass)klass) ? klass : null;
    }
}

