/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.sourceMap;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.SourceLocationConsumer;
import org.jetbrains.kotlin.js.backend.ast.JsLocation;
import org.jetbrains.kotlin.js.backend.ast.JsLocationWithSource;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.sourceMap.PsiUtils;
import org.jetbrains.kotlin.js.sourceMap.SourceFilePathResolver;
import org.jetbrains.kotlin.js.sourceMap.SourceMapBuilderConsumer;
import org.jetbrains.kotlin.js.sourceMap.SourceMapMappingConsumer;
import org.jetbrains.kotlin.psi.KtPureElement;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000eH\u0002J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\u0012\u0010\u0014\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/js/sourceMap/SourceMapBuilderConsumer;", "Lorg/jetbrains/kotlin/js/backend/SourceLocationConsumer;", "sourceBaseDir", "Ljava/io/File;", "mappingConsumer", "Lorg/jetbrains/kotlin/js/sourceMap/SourceMapMappingConsumer;", "pathResolver", "Lorg/jetbrains/kotlin/js/sourceMap/SourceFilePathResolver;", "provideCurrentModuleContent", "", "provideExternalModuleContent", "(Ljava/io/File;Lorg/jetbrains/kotlin/js/sourceMap/SourceMapMappingConsumer;Lorg/jetbrains/kotlin/js/sourceMap/SourceFilePathResolver;ZZ)V", "sourceStack", "", "", "addMapping", "", "sourceInfo", "newLine", "popSourceInfo", "pushSourceInfo", "info", "js.sourcemap"})
public final class SourceMapBuilderConsumer
implements SourceLocationConsumer {
    @NotNull
    private final File sourceBaseDir;
    @NotNull
    private final SourceMapMappingConsumer mappingConsumer;
    @NotNull
    private final SourceFilePathResolver pathResolver;
    private final boolean provideCurrentModuleContent;
    private final boolean provideExternalModuleContent;
    @NotNull
    private final List<Object> sourceStack;

    public SourceMapBuilderConsumer(@NotNull File sourceBaseDir, @NotNull SourceMapMappingConsumer mappingConsumer, @NotNull SourceFilePathResolver pathResolver, boolean provideCurrentModuleContent, boolean provideExternalModuleContent) {
        Intrinsics.checkNotNullParameter((Object)sourceBaseDir, (String)"sourceBaseDir");
        Intrinsics.checkNotNullParameter((Object)mappingConsumer, (String)"mappingConsumer");
        Intrinsics.checkNotNullParameter((Object)pathResolver, (String)"pathResolver");
        this.sourceBaseDir = sourceBaseDir;
        this.mappingConsumer = mappingConsumer;
        this.pathResolver = pathResolver;
        this.provideCurrentModuleContent = provideCurrentModuleContent;
        this.provideExternalModuleContent = provideExternalModuleContent;
        this.sourceStack = new ArrayList();
    }

    @Override
    public void newLine() {
        this.mappingConsumer.newLine();
    }

    @Override
    public void pushSourceInfo(@Nullable Object info) {
        this.sourceStack.add(info);
        this.addMapping(info);
    }

    @Override
    public void popSourceInfo() {
        AddToStdlibKt.popLast(this.sourceStack);
        this.addMapping(CollectionsKt.lastOrNull(this.sourceStack));
    }

    private final void addMapping(Object sourceInfo) {
        Object object = sourceInfo;
        if (object == null) {
            this.mappingConsumer.addEmptyMapping();
        } else {
            if (object instanceof PsiElement) {
                if (CallUtilKt.isFakePsiElement((PsiElement)sourceInfo)) {
                    return;
                }
                try {
                    JsLocation jsLocation = PsiUtils.extractLocationFromPsi((PsiElement)sourceInfo, this.pathResolver);
                    String sourceFilePath = jsLocation.component1();
                    int startLine = jsLocation.component2();
                    int startChar = jsLocation.component3();
                    PsiFile psiFile = ((PsiElement)sourceInfo).getContainingFile();
                    File file2 = new File(psiFile.getViewProvider().getVirtualFile().getPath());
                    Function0 contentSupplier2 = this.provideCurrentModuleContent ? (Function0)new Function0<InputStreamReader>(file2){
                        final /* synthetic */ File $file;
                        {
                            this.$file = $file;
                            super(0);
                        }

                        @Nullable
                        public final InputStreamReader invoke() {
                            InputStreamReader inputStreamReader;
                            try {
                                inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(this.$file), StandardCharsets.UTF_8);
                            }
                            catch (IOException e) {
                                inputStreamReader = null;
                            }
                            return inputStreamReader;
                        }
                    } : (Function0)addMapping.contentSupplier.2.INSTANCE;
                    this.mappingConsumer.addMapping(sourceFilePath, null, () -> SourceMapBuilderConsumer.addMapping$lambda$0(contentSupplier2), startLine, startChar);
                }
                catch (IOException e) {
                    throw new RuntimeException("IO error occurred generating source maps", e);
                }
            }
            if (object instanceof JsLocationWithSource) {
                String string2;
                File absFile;
                Function0<Reader> contentSupplier3 = this.provideExternalModuleContent ? ((JsLocationWithSource)sourceInfo).getSourceProvider() : (Function0<Reader>)addMapping.contentSupplier.3.INSTANCE;
                File sourceFile = new File(((JsLocationWithSource)sourceInfo).getFile());
                File file3 = absFile = sourceFile.isAbsolute() ? sourceFile : new File(this.sourceBaseDir, ((JsLocationWithSource)sourceInfo).getFile());
                if (absFile.isAbsolute()) {
                    String string3;
                    try {
                        string3 = this.pathResolver.getPathRelativeToSourceRoots(absFile);
                    }
                    catch (IOException e) {
                        string3 = ((JsLocationWithSource)sourceInfo).getFile();
                    }
                    string2 = string3;
                } else {
                    string2 = ((JsLocationWithSource)sourceInfo).getFile();
                }
                String path2 = string2;
                this.mappingConsumer.addMapping(path2, ((JsLocationWithSource)sourceInfo).getFileIdentity(), () -> SourceMapBuilderConsumer.addMapping$lambda$1(contentSupplier3), ((JsLocationWithSource)sourceInfo).getStartLine(), ((JsLocationWithSource)sourceInfo).getStartChar());
            } else if (object instanceof JsNode ? true : object instanceof KtPureElement) {
                // empty if block
            }
        }
    }

    private static final Reader addMapping$lambda$0(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Reader)$tmp0.invoke();
    }

    private static final Reader addMapping$lambda$1(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Reader)$tmp0.invoke();
    }
}

