/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.code;

import org.jetbrains.java.decompiler.code.IfInstruction;
import org.jetbrains.java.decompiler.code.Instruction;
import org.jetbrains.java.decompiler.code.optinstructions.ALOAD;
import org.jetbrains.java.decompiler.code.optinstructions.ANEWARRAY;
import org.jetbrains.java.decompiler.code.optinstructions.ASTORE;
import org.jetbrains.java.decompiler.code.optinstructions.BIPUSH;
import org.jetbrains.java.decompiler.code.optinstructions.CHECKCAST;
import org.jetbrains.java.decompiler.code.optinstructions.DLOAD;
import org.jetbrains.java.decompiler.code.optinstructions.DSTORE;
import org.jetbrains.java.decompiler.code.optinstructions.FLOAD;
import org.jetbrains.java.decompiler.code.optinstructions.FSTORE;
import org.jetbrains.java.decompiler.code.optinstructions.GETFIELD;
import org.jetbrains.java.decompiler.code.optinstructions.GETSTATIC;
import org.jetbrains.java.decompiler.code.optinstructions.GOTO;
import org.jetbrains.java.decompiler.code.optinstructions.GOTO_W;
import org.jetbrains.java.decompiler.code.optinstructions.IINC;
import org.jetbrains.java.decompiler.code.optinstructions.ILOAD;
import org.jetbrains.java.decompiler.code.optinstructions.INSTANCEOF;
import org.jetbrains.java.decompiler.code.optinstructions.INVOKEDYNAMIC;
import org.jetbrains.java.decompiler.code.optinstructions.INVOKEINTERFACE;
import org.jetbrains.java.decompiler.code.optinstructions.INVOKESPECIAL;
import org.jetbrains.java.decompiler.code.optinstructions.INVOKESTATIC;
import org.jetbrains.java.decompiler.code.optinstructions.INVOKEVIRTUAL;
import org.jetbrains.java.decompiler.code.optinstructions.ISTORE;
import org.jetbrains.java.decompiler.code.optinstructions.JSR;
import org.jetbrains.java.decompiler.code.optinstructions.JSR_W;
import org.jetbrains.java.decompiler.code.optinstructions.LDC;
import org.jetbrains.java.decompiler.code.optinstructions.LDC2_W;
import org.jetbrains.java.decompiler.code.optinstructions.LDC_W;
import org.jetbrains.java.decompiler.code.optinstructions.LLOAD;
import org.jetbrains.java.decompiler.code.optinstructions.LOOKUPSWITCH;
import org.jetbrains.java.decompiler.code.optinstructions.LSTORE;
import org.jetbrains.java.decompiler.code.optinstructions.MULTIANEWARRAY;
import org.jetbrains.java.decompiler.code.optinstructions.NEW;
import org.jetbrains.java.decompiler.code.optinstructions.NEWARRAY;
import org.jetbrains.java.decompiler.code.optinstructions.PUTFIELD;
import org.jetbrains.java.decompiler.code.optinstructions.PUTSTATIC;
import org.jetbrains.java.decompiler.code.optinstructions.RET;
import org.jetbrains.java.decompiler.code.optinstructions.SIPUSH;
import org.jetbrains.java.decompiler.code.optinstructions.TABLESWITCH;

public class ConstantsUtil {
    private static final String[] opcodeNames = new String[]{"nop", "aconst_null", "iconst_m1", "iconst_0", "iconst_1", "iconst_2", "iconst_3", "iconst_4", "iconst_5", "lconst_0", "lconst_1", "fconst_0", "fconst_1", "fconst_2", "dconst_0", "dconst_1", "bipush", "sipush", "ldc", "ldc_w", "ldc2_w", "iload", "lload", "fload", "dload", "aload", "iload_0", "iload_1", "iload_2", "iload_3", "lload_0", "lload_1", "lload_2", "lload_3", "fload_0", "fload_1", "fload_2", "fload_3", "dload_0", "dload_1", "dload_2", "dload_3", "aload_0", "aload_1", "aload_2", "aload_3", "iaload", "laload", "faload", "daload", "aaload", "baload", "caload", "saload", "istore", "lstore", "fstore", "dstore", "astore", "istore_0", "istore_1", "istore_2", "istore_3", "lstore_0", "lstore_1", "lstore_2", "lstore_3", "fstore_0", "fstore_1", "fstore_2", "fstore_3", "dstore_0", "dstore_1", "dstore_2", "dstore_3", "astore_0", "astore_1", "astore_2", "astore_3", "iastore", "lastore", "fastore", "dastore", "aastore", "bastore", "castore", "sastore", "pop", "pop2", "dup", "dup_x1", "dup_x2", "dup2", "dup2_x1", "dup2_x2", "swap", "iadd", "ladd", "fadd", "dadd", "isub", "lsub", "fsub", "dsub", "imul", "lmul", "fmul", "dmul", "idiv", "ldiv", "fdiv", "ddiv", "irem", "lrem", "frem", "drem", "ineg", "lneg", "fneg", "dneg", "ishl", "lshl", "ishr", "lshr", "iushr", "lushr", "iand", "land", "ior", "lor", "ixor", "lxor", "iinc", "i2l", "i2f", "i2d", "l2i", "l2f", "l2d", "f2i", "f2l", "f2d", "d2i", "d2l", "d2f", "i2b", "i2c", "i2s", "lcmp", "fcmpl", "fcmpg", "dcmpl", "dcmpg", "ifeq", "ifne", "iflt", "ifge", "ifgt", "ifle", "if_icmpeq", "if_icmpne", "if_icmplt", "if_icmpge", "if_icmpgt", "if_icmple", "if_acmpeq", "if_acmpne", "goto", "jsr", "ret", "tableswitch", "lookupswitch", "ireturn", "lreturn", "freturn", "dreturn", "areturn", "return", "getstatic", "putstatic", "getfield", "putfield", "invokevirtual", "invokespecial", "invokestatic", "invokeinterface", "invokedynamic", "new", "newarray", "anewarray", "arraylength", "athrow", "checkcast", "instanceof", "monitorenter", "monitorexit", "wide", "multianewarray", "ifnull", "ifnonnull", "goto_w", "jsr_w"};
    private static final Class[] opcodeClasses = new Class[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, BIPUSH.class, SIPUSH.class, LDC.class, LDC_W.class, LDC2_W.class, ILOAD.class, LLOAD.class, FLOAD.class, DLOAD.class, ALOAD.class, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, ISTORE.class, LSTORE.class, FSTORE.class, DSTORE.class, ASTORE.class, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, IINC.class, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, GOTO.class, JSR.class, RET.class, TABLESWITCH.class, LOOKUPSWITCH.class, null, null, null, null, null, null, GETSTATIC.class, PUTSTATIC.class, GETFIELD.class, PUTFIELD.class, INVOKEVIRTUAL.class, INVOKESPECIAL.class, INVOKESTATIC.class, INVOKEINTERFACE.class, INVOKEDYNAMIC.class, NEW.class, NEWARRAY.class, ANEWARRAY.class, null, null, CHECKCAST.class, INSTANCEOF.class, null, null, null, MULTIANEWARRAY.class, null, null, GOTO_W.class, JSR_W.class};

    public static String getName(int opcode) {
        return opcodeNames[opcode];
    }

    public static Instruction getInstructionInstance(int opcode, boolean wide, int group, int bytecode_version, int[] operands) {
        Instruction instr = ConstantsUtil.getInstructionInstance(opcode, bytecode_version);
        instr.wide = wide;
        instr.group = group;
        instr.bytecode_version = bytecode_version;
        instr.setOperands(operands);
        return instr;
    }

    private static Instruction getInstructionInstance(int opcode, int bytecode_version) {
        try {
            Instruction instr;
            if (opcode >= 153 && opcode <= 166 || opcode == 198 || opcode == 199) {
                instr = new IfInstruction();
            } else {
                Class cl = opcodeClasses[opcode];
                if (opcode == 186 && bytecode_version < 4) {
                    cl = null;
                }
                instr = cl == null ? new Instruction() : (Instruction)cl.newInstance();
            }
            instr.opcode = opcode;
            return instr;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

