/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt.externalsources;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.javacs.kt.externalsources.KlsURIKt;
import org.javacs.kt.util.TemporaryDirectory;
import org.javacs.kt.util.URIsKt;
import org.javacs.kt.util.UtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001:\u0002?@B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B!\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c6\u0003J)\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00032\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c6\u0001J\u0013\u0010'\u001a\u00020!2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020+J\t\u0010,\u001a\u00020-H\u00d6\u0001J\b\u0010.\u001a\u00020/H\u0002J\u0006\u00100\u001a\u00020\tJ\b\u00101\u001a\u000202H\u0002J\b\u00103\u001a\u00020\tH\u0016J\b\u00104\u001a\u00020\u0003H\u0002J\u0010\u00105\u001a\u0004\u0018\u00010\u00002\u0006\u00106\u001a\u00020\fJ\u000e\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u00020\tJ(\u00109\u001a\u0002H:\"\u0004\b\u0000\u0010:2\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002H:0<H\u0082\b\u00a2\u0006\u0002\u0010=J\u000e\u0010>\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0015R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0015R\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006A"}, d2={"Lorg/javacs/kt/externalsources/KlsURI;", "", "uri", "Ljava/net/URI;", "(Ljava/net/URI;)V", "fileUri", "query", "", "Lorg/javacs/kt/externalsources/KlsURI$QueryParam;", "", "(Ljava/net/URI;Ljava/util/Map;)V", "archivePath", "Ljava/nio/file/Path;", "getArchivePath", "()Ljava/nio/file/Path;", "archiveType", "Lorg/javacs/kt/externalsources/KlsURI$ArchiveType;", "getArchiveType", "()Lorg/javacs/kt/externalsources/KlsURI$ArchiveType;", "fileExtension", "getFileExtension", "()Ljava/lang/String;", "fileName", "getFileName", "getFileUri", "()Ljava/net/URI;", "innerPath", "getInnerPath", "getQuery", "()Ljava/util/Map;", "queryString", "getQueryString", "source", "", "getSource", "()Z", "component1", "component2", "copy", "equals", "other", "extractToTemporaryFile", "dir", "Lorg/javacs/kt/util/TemporaryDirectory;", "hashCode", "", "openJarURLConnection", "Ljava/net/JarURLConnection;", "readContents", "toJarURL", "Ljava/net/URL;", "toString", "toURI", "withArchivePath", "newArchivePath", "withFileExtension", "newExtension", "withJarURLConnection", "T", "action", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "withSource", "ArchiveType", "QueryParam", "server"})
@SourceDebugExtension(value={"SMAP\nKlsURI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KlsURI.kt\norg/javacs/kt/externalsources/KlsURI\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,166:1\n107#1,7:171\n107#1,7:178\n1789#2,3:167\n1#3:170\n*S KotlinDebug\n*F\n+ 1 KlsURI.kt\norg/javacs/kt/externalsources/KlsURI\n*L\n124#1:171,7\n133#1:178,7\n49#1:167,3\n*E\n"})
public final class KlsURI {
    @NotNull
    private final URI fileUri;
    @NotNull
    private final Map<QueryParam, String> query;

    public KlsURI(@NotNull URI fileUri, @NotNull Map<QueryParam, String> query2) {
        Intrinsics.checkNotNullParameter((Object)fileUri, (String)"fileUri");
        Intrinsics.checkNotNullParameter(query2, (String)"query");
        this.fileUri = fileUri;
        this.query = query2;
    }

    @NotNull
    public final URI getFileUri() {
        return this.fileUri;
    }

    @NotNull
    public final Map<QueryParam, String> getQuery() {
        return this.query;
    }

    /*
     * WARNING - void declaration
     */
    private final String getQueryString() {
        String string;
        if (this.query.isEmpty()) {
            string = "";
        } else {
            void $this$fold$iv;
            Iterable iterable = this.query.entrySet();
            String initial$iv = "?";
            boolean $i$f$fold = false;
            Object accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void next;
                Map.Entry entry = (Map.Entry)element$iv;
                String accum = accumulator$iv;
                boolean bl = false;
                accumulator$iv = accum + next.getKey() + "=" + next.getValue();
            }
            string = accumulator$iv;
        }
        return string;
    }

    @NotNull
    public final String getFileName() {
        String string = this.fileUri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fileUri.toString()");
        return StringsKt.substringAfterLast$default((String)string, (String)"/", null, (int)2, null);
    }

    @Nullable
    public final String getFileExtension() {
        Object object = new String[]{"."};
        Object it = object = StringsKt.split$default((CharSequence)this.getFileName(), (String[])object, (boolean)false, (int)0, (int)6, null);
        boolean bl = false;
        Object object2 = it.size() > 1 ? object : null;
        return object2 != null ? (String)CollectionsKt.lastOrNull((List)object2) : null;
    }

    private final ArchiveType getArchiveType() {
        ArchiveType archiveType;
        String string = this.fileUri.getSchemeSpecificPart();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fileUri.schemeSpecificPart");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"!/modules", (boolean)false, (int)2, null)) {
            archiveType = ArchiveType.JDK;
        } else {
            String string2 = this.fileUri.getSchemeSpecificPart();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fileUri.schemeSpecificPart");
            archiveType = StringsKt.contains$default((CharSequence)string2, (CharSequence)".zip!", (boolean)false, (int)2, null) ? ArchiveType.ZIP : ArchiveType.JAR;
        }
        return archiveType;
    }

    @NotNull
    public final Path getArchivePath() {
        String string = this.fileUri.getSchemeSpecificPart();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fileUri.schemeSpecificPart");
        String[] stringArray = new String[]{this.getArchiveType().getDelimiter()};
        Path path = Paths.get(URIsKt.parseURI((String)((String)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0))));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(parseURI(fileUri.sch\u2026chiveType.delimiter)[0]))");
        return path;
    }

    private final String getInnerPath() {
        String string = this.fileUri.getSchemeSpecificPart();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fileUri.schemeSpecificPart");
        String[] stringArray = new String[]{this.getArchiveType().getDelimiter()};
        return (String)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)2, (int)2, null).get(1);
    }

    public final boolean getSource() {
        String string = this.query.get((Object)QueryParam.SOURCE);
        return string != null ? Boolean.parseBoolean(string) : false;
    }

    public KlsURI(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this(KlsURIKt.access$parseKlsURIFileURI(uri), KlsURIKt.access$parseKlsURIQuery(uri));
    }

    @Nullable
    public final KlsURI withArchivePath(@NotNull Path newArchivePath) {
        KlsURI klsURI;
        KlsURI it;
        Intrinsics.checkNotNullParameter((Object)newArchivePath, (String)"newArchivePath");
        String string = this.getInnerPath();
        String string2 = newArchivePath.toUri().toString();
        boolean bl = false;
        String string3 = string2 + ("!" + (String)((Object)it));
        KlsURI klsURI2 = KlsURIKt.toKlsURI(new URI(string3));
        if (klsURI2 != null) {
            it = klsURI2;
            boolean bl2 = false;
            klsURI = new KlsURI(it.fileUri, this.query);
        } else {
            klsURI = null;
        }
        return klsURI;
    }

    @NotNull
    public final KlsURI withFileExtension(@NotNull String newExtension) {
        Intrinsics.checkNotNullParameter((Object)newExtension, (String)"newExtension");
        String string = this.fileUri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fileUri.toString()");
        Pair pair = UtilsKt.partitionAroundLast((String)string, (String)"/");
        String parentUri = (String)pair.component1();
        String fileName = (String)pair.component2();
        String[] stringArray = new String[]{"."};
        URI newUri = new URI(parentUri + CollectionsKt.first((List)StringsKt.split$default((CharSequence)fileName, (String[])stringArray, (boolean)false, (int)0, (int)6, null)) + "." + newExtension);
        return new KlsURI(newUri, this.query);
    }

    @NotNull
    public final KlsURI withSource(boolean source) {
        Map newQuery = new LinkedHashMap();
        newQuery.putAll(this.query);
        newQuery.put(QueryParam.SOURCE, String.valueOf(source));
        return new KlsURI(this.fileUri, newQuery);
    }

    private final URI toURI() {
        return new URI(this.fileUri.toString() + this.getQueryString());
    }

    private final URL toJarURL() {
        return new URL("jar:" + this.fileUri.getSchemeSpecificPart());
    }

    private final JarURLConnection openJarURLConnection() {
        URLConnection uRLConnection = this.toJarURL().openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.JarURLConnection");
        return (JarURLConnection)uRLConnection;
    }

    private final <T> T withJarURLConnection(Function1<? super JarURLConnection, ? extends T> action) {
        boolean $i$f$withJarURLConnection = false;
        JarURLConnection connection = this.openJarURLConnection();
        Object result = action.invoke((Object)connection);
        if (connection.getUseCaches()) {
            connection.getJarFile().close();
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String readContents() {
        Object object;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getArchiveType().ordinal()]) {
            case 1: {
                ZipFile zipFile = new ZipFile(new File(String.valueOf(this.getArchivePath())));
                Object object2 = new char[]{'/'};
                InputStream inputStream = zipFile.getInputStream(zipFile.getEntry(StringsKt.trimStart((String)this.getInnerPath(), (char[])object2)));
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"zipFile.getInputStream(z\u2026nnerPath.trimStart('/')))");
                Closeable closeable = inputStream;
                object2 = Charsets.UTF_8;
                Reader reader = new InputStreamReader((InputStream)closeable, (Charset)object2);
                int n = 8192;
                closeable = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
                object2 = null;
                try {
                    Object p0 = (BufferedReader)closeable;
                    boolean bl = false;
                    p0 = TextStreamsKt.readText((Reader)((Reader)p0));
                    object = p0;
                    break;
                }
                catch (Throwable p0) {
                    object2 = p0;
                    throw p0;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
                }
            }
            case 2: 
            case 3: {
                JarURLConnection connection$iv;
                KlsURI this_$iv = this;
                boolean $i$f$withJarURLConnection = false;
                JarURLConnection it = connection$iv = this_$iv.openJarURLConnection();
                boolean bl = false;
                InputStream inputStream = it.getJarFile().getInputStream(it.getJarEntry());
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"it.jarFile\n             \u2026tInputStream(it.jarEntry)");
                Closeable closeable = inputStream;
                Object object3 = Charsets.UTF_8;
                Object object4 = new InputStreamReader((InputStream)closeable, (Charset)object3);
                int n = 8192;
                closeable = object4 instanceof BufferedReader ? (BufferedReader)object4 : new BufferedReader((Reader)object4, n);
                object3 = null;
                try {
                    BufferedReader p0 = (BufferedReader)closeable;
                    boolean bl2 = false;
                    object4 = TextStreamsKt.readText((Reader)p0);
                }
                catch (Throwable throwable) {
                    object3 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object3);
                }
                Object result$iv = object4;
                if (connection$iv.getUseCaches()) {
                    connection$iv.getJarFile().close();
                }
                object = result$iv;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Path extractToTemporaryFile(@NotNull TemporaryDirectory dir) {
        JarURLConnection connection$iv;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        KlsURI this_$iv = this;
        boolean $i$f$withJarURLConnection = false;
        JarURLConnection it = connection$iv = this_$iv.openJarURLConnection();
        boolean bl = false;
        String string = it.getJarEntry().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.jarEntry.name");
        String[] stringArray = new String[]{"."};
        List name = StringsKt.split$default((CharSequence)StringsKt.substringAfterLast$default((String)string, (String)"/", null, (int)2, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        Path tmpFile = dir.createTempFile((String)name.get(0), "." + name.get(1));
        Closeable closeable = it.getJarFile().getInputStream(it.getJarEntry());
        Throwable throwable = null;
        try {
            long l;
            InputStream input = (InputStream)closeable;
            boolean bl2 = false;
            Closeable closeable2 = Files.newOutputStream(tmpFile, new OpenOption[0]);
            Throwable throwable2 = null;
            try {
                OutputStream it2 = (OutputStream)closeable2;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)input, (String)"input");
                Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)it2, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Path result$iv = tmpFile;
        if (connection$iv.getUseCaches()) {
            connection$iv.getJarFile().close();
        }
        return result$iv;
    }

    @NotNull
    public String toString() {
        String string = this.toURI().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toURI().toString()");
        return string;
    }

    @NotNull
    public final URI component1() {
        return this.fileUri;
    }

    @NotNull
    public final Map<QueryParam, String> component2() {
        return this.query;
    }

    @NotNull
    public final KlsURI copy(@NotNull URI fileUri, @NotNull Map<QueryParam, String> query2) {
        Intrinsics.checkNotNullParameter((Object)fileUri, (String)"fileUri");
        Intrinsics.checkNotNullParameter(query2, (String)"query");
        return new KlsURI(fileUri, query2);
    }

    public static /* synthetic */ KlsURI copy$default(KlsURI klsURI, URI uRI, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            uRI = klsURI.fileUri;
        }
        if ((n & 2) != 0) {
            map = klsURI.query;
        }
        return klsURI.copy(uRI, map);
    }

    public int hashCode() {
        int result = this.fileUri.hashCode();
        result = result * 31 + ((Object)this.query).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KlsURI)) {
            return false;
        }
        KlsURI klsURI = (KlsURI)other;
        if (!Intrinsics.areEqual((Object)this.fileUri, (Object)klsURI.fileUri)) {
            return false;
        }
        return Intrinsics.areEqual(this.query, klsURI.query);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/javacs/kt/externalsources/KlsURI$ArchiveType;", "", "delimiter", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getDelimiter", "()Ljava/lang/String;", "JAR", "ZIP", "JDK", "server"})
    public static final class ArchiveType
    extends Enum<ArchiveType> {
        @NotNull
        private final String delimiter;
        public static final /* enum */ ArchiveType JAR = new ArchiveType("!");
        public static final /* enum */ ArchiveType ZIP = new ArchiveType("!");
        public static final /* enum */ ArchiveType JDK = new ArchiveType("!/modules");
        private static final /* synthetic */ ArchiveType[] $VALUES;

        private ArchiveType(String delimiter) {
            this.delimiter = delimiter;
        }

        @NotNull
        public final String getDelimiter() {
            return this.delimiter;
        }

        public static ArchiveType[] values() {
            return (ArchiveType[])$VALUES.clone();
        }

        public static ArchiveType valueOf(String value) {
            return Enum.valueOf(ArchiveType.class, value);
        }

        static {
            $VALUES = archiveTypeArray = new ArchiveType[]{ArchiveType.JAR, ArchiveType.ZIP, ArchiveType.JDK};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/javacs/kt/externalsources/KlsURI$QueryParam;", "", "parameterName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getParameterName", "()Ljava/lang/String;", "toString", "SOURCE", "server"})
    public static final class QueryParam
    extends Enum<QueryParam> {
        @NotNull
        private final String parameterName;
        public static final /* enum */ QueryParam SOURCE = new QueryParam("source");
        private static final /* synthetic */ QueryParam[] $VALUES;

        private QueryParam(String parameterName) {
            this.parameterName = parameterName;
        }

        @NotNull
        public final String getParameterName() {
            return this.parameterName;
        }

        @NotNull
        public String toString() {
            return this.parameterName;
        }

        public static QueryParam[] values() {
            return (QueryParam[])$VALUES.clone();
        }

        public static QueryParam valueOf(String value) {
            return Enum.valueOf(QueryParam.class, value);
        }

        static {
            $VALUES = queryParamArray = new QueryParam[]{QueryParam.SOURCE};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ArchiveType.values().length];
            try {
                nArray[ArchiveType.ZIP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArchiveType.JAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArchiveType.JDK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

