/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.CollectionFactory;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class TransactionGuardImpl
extends TransactionGuard {
    private static final Logger LOG = Logger.getInstance(TransactionGuardImpl.class);
    private final Map<ModalityState, Boolean> myWriteSafeModalities = CollectionFactory.createConcurrentWeakMap();
    private boolean myWritingAllowed;
    private boolean myErrorReported;

    public TransactionGuardImpl() {
        this.myWriteSafeModalities.put(ModalityState.NON_MODAL, true);
        this.myWritingAllowed = SwingUtilities.isEventDispatchThread();
    }

    @Override
    public boolean isWriteSafeModality(ModalityState state) {
        return Boolean.TRUE.equals(this.myWriteSafeModalities.get(state));
    }

    public void assertWriteActionAllowed() {
        ApplicationManager.getApplication().assertIsWriteThread();
        if (!this.myWritingAllowed && TransactionGuardImpl.areAssertionsEnabled() && !this.myErrorReported) {
            LOG.error(TransactionGuardImpl.reportWriteUnsafeContext(ModalityState.current()));
            this.myErrorReported = true;
        }
    }

    @NonNls
    private static String reportWriteUnsafeContext(@NotNull ModalityState modality) {
        if (modality == null) {
            TransactionGuardImpl.$$$reportNull$$$0(4);
        }
        return "Write-unsafe context! Model changes are allowed from write-safe contexts only. Please ensure you're using invokeLater/invokeAndWait with a correct modality state (not \"any\"). See TransactionGuard documentation for details.\n  current modality=" + modality;
    }

    @Override
    public void assertWriteSafeContext(@NotNull ModalityState modality) {
        if (modality == null) {
            TransactionGuardImpl.$$$reportNull$$$0(5);
        }
        if (!this.isWriteSafeModality(modality) && TransactionGuardImpl.areAssertionsEnabled()) {
            LOG.error(TransactionGuardImpl.reportWriteUnsafeContext(modality));
        }
    }

    private static boolean areAssertionsEnabled() {
        return LoadingState.COMPONENTS_LOADED.isOccurred() && Registry.is("ide.require.transaction.for.model.changes", false);
    }

    public void enteredModality(@NotNull ModalityState modality) {
        if (modality == null) {
            TransactionGuardImpl.$$$reportNull$$$0(8);
        }
        this.myWriteSafeModalities.put(modality, this.myWritingAllowed);
    }

    public String toString() {
        return "TransactionGuardImpl{myWritingAllowed=" + this.myWritingAllowed + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transaction";
                break;
            }
            case 2: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/TransactionGuardImpl";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/TransactionGuardImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "startActivity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "submitTransaction";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "submitTransactionAndWait";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "reportWriteUnsafeContext";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "assertWriteSafeContext";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "submitTransactionLater";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "enteredModality";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "wrapLaterInvocation";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runWithWritingAllowed";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

