/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.psi;

import com.intellij.openapi.diagnostic.Logger;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.psi.DeserializerForDecompilerBase;
import org.jetbrains.kotlin.analysis.decompiler.psi.KotlinMetadataDeserializerForDecompiler;
import org.jetbrains.kotlin.analysis.decompiler.psi.LoggingErrorReporter;
import org.jetbrains.kotlin.analysis.decompiler.psi.ResolveEverythingToKotlinAnyLocalClassifierResolver;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.NotFoundClasses;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.impl.MutablePackageFragmentDescriptor;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.sam.SamConversionResolverImpl;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;
import org.jetbrains.kotlin.serialization.deserialization.AnnotationAndConstantLoaderImpl;
import org.jetbrains.kotlin.serialization.deserialization.ContractDeserializer;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationComponents;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationConfiguration;
import org.jetbrains.kotlin.serialization.deserialization.FlexibleTypeDeserializer;
import org.jetbrains.kotlin.serialization.deserialization.ProtoBasedClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedPackageMemberScope;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u0003H\u0016R\u0014\u0010\u000f\u001a\u00020\u00108TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/psi/KotlinMetadataDeserializerForDecompiler;", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/DeserializerForDecompilerBase;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "metadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "serializerProtocol", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "flexibleTypeDeserializer", "Lorg/jetbrains/kotlin/serialization/deserialization/FlexibleTypeDeserializer;", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;Lorg/jetbrains/kotlin/serialization/deserialization/FlexibleTypeDeserializer;)V", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "getBuiltIns", "()Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "deserializationComponents", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationComponents;", "getDeserializationComponents", "()Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationComponents;", "resolveDeclarationsInFacade", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "facadeFqName", "Companion", "decompiler-to-psi"})
public final class KotlinMetadataDeserializerForDecompiler
extends DeserializerForDecompilerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProtoBuf.PackageFragment proto;
    @NotNull
    private final NameResolver nameResolver;
    @NotNull
    private final BinaryVersion metadataVersion;
    @NotNull
    private final DeserializationComponents deserializationComponents;
    @NotNull
    private static final Logger LOG;

    public KotlinMetadataDeserializerForDecompiler(@NotNull FqName packageFqName, @NotNull ProtoBuf.PackageFragment proto, @NotNull NameResolver nameResolver2, @NotNull BinaryVersion metadataVersion, @NotNull SerializerExtensionProtocol serializerProtocol, @NotNull FlexibleTypeDeserializer flexibleTypeDeserializer) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)nameResolver2, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)metadataVersion, (String)"metadataVersion");
        Intrinsics.checkNotNullParameter((Object)serializerProtocol, (String)"serializerProtocol");
        Intrinsics.checkNotNullParameter((Object)flexibleTypeDeserializer, (String)"flexibleTypeDeserializer");
        super(packageFqName);
        this.proto = proto;
        this.nameResolver = nameResolver2;
        this.metadataVersion = metadataVersion;
        NotFoundClasses notFoundClasses = new NotFoundClasses(this.getStorageManager(), this.getModuleDescriptor());
        this.deserializationComponents = new DeserializationComponents(this.getStorageManager(), this.getModuleDescriptor(), DeserializationConfiguration.Default.INSTANCE, new ProtoBasedClassDataFinder(this.proto, this.nameResolver, this.metadataVersion, null, 8, null), new AnnotationAndConstantLoaderImpl(this.getModuleDescriptor(), notFoundClasses, serializerProtocol), this.getPackageFragmentProvider(), new ResolveEverythingToKotlinAnyLocalClassifierResolver(this.getBuiltIns()), new LoggingErrorReporter(LOG), LookupTracker.DO_NOTHING.INSTANCE, flexibleTypeDeserializer, CollectionsKt.emptyList(), notFoundClasses, ContractDeserializer.Companion.getDEFAULT(), null, null, serializerProtocol.getExtensionRegistry(), null, new SamConversionResolverImpl(this.getStorageManager(), CollectionsKt.emptyList()), null, this.getEnumEntriesDeserializationSupport(), 352256, null);
    }

    @Override
    @NotNull
    protected KotlinBuiltIns getBuiltIns() {
        return DefaultBuiltIns.Companion.getInstance();
    }

    @Override
    @NotNull
    protected DeserializationComponents getDeserializationComponents() {
        return this.deserializationComponents;
    }

    @Override
    @NotNull
    public List<DeclarationDescriptor> resolveDeclarationsInFacade(@NotNull FqName facadeFqName) {
        Intrinsics.checkNotNullParameter((Object)facadeFqName, (String)"facadeFqName");
        boolean bl = Intrinsics.areEqual((Object)facadeFqName, (Object)this.getDirectoryPackageFqName());
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-KotlinMetadataDeserializerForDecompiler$resolveDeclarationsInFacade$22 = false;
            String $i$a$-assert-KotlinMetadataDeserializerForDecompiler$resolveDeclarationsInFacade$22 = "Was called for " + facadeFqName + "; only members of " + this.getDirectoryPackageFqName() + " package are expected.";
            throw new AssertionError((Object)$i$a$-assert-KotlinMetadataDeserializerForDecompiler$resolveDeclarationsInFacade$22);
        }
        MutablePackageFragmentDescriptor dummyPackageFragment = this.createDummyPackageFragment(facadeFqName);
        PackageFragmentDescriptor packageFragmentDescriptor = dummyPackageFragment;
        ProtoBuf.Package package_ = this.proto.getPackage();
        Intrinsics.checkNotNullExpressionValue((Object)package_, (String)"getPackage(...)");
        DeserializedPackageMemberScope membersScope2 = new DeserializedPackageMemberScope(packageFragmentDescriptor, package_, this.nameResolver, this.metadataVersion, null, this.getDeserializationComponents(), "scope of dummyPackageFragment " + dummyPackageFragment.getFqName() + " in module " + this.getDeserializationComponents().getModuleDescriptor() + " @KotlinMetadataDeserializerForDecompiler", (Function0<? extends Collection<Name>>)((Function0)resolveDeclarationsInFacade.membersScope.1.INSTANCE));
        return CollectionsKt.toList((Iterable)ResolutionScope.DefaultImpls.getContributedDescriptors$default(membersScope2, null, null, 3, null));
    }

    static {
        Logger logger = Logger.getInstance(KotlinMetadataDeserializerForDecompiler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/psi/KotlinMetadataDeserializerForDecompiler$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "decompiler-to-psi"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

