/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations;

import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.fir.declarations.DeprecationAnnotationInfo;
import org.jetbrains.kotlin.fir.declarations.RequireKotlinDeprecationInfo;
import org.jetbrains.kotlin.metadata.deserialization.VersionRequirement;
import org.jetbrains.kotlin.resolve.deprecation.CommonDeprecationUtilsKt;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationInfo;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/RequireKotlinInfo;", "Lorg/jetbrains/kotlin/fir/declarations/DeprecationAnnotationInfo;", "versionRequirement", "Lorg/jetbrains/kotlin/metadata/deserialization/VersionRequirement;", "(Lorg/jetbrains/kotlin/metadata/deserialization/VersionRequirement;)V", "computeDeprecationInfo", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationInfo;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "tree"})
@SourceDebugExtension(value={"SMAP\nDeprecationsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeprecationsProvider.kt\norg/jetbrains/kotlin/fir/declarations/RequireKotlinInfo\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,140:1\n227#2:141\n*S KotlinDebug\n*F\n+ 1 DeprecationsProvider.kt\norg/jetbrains/kotlin/fir/declarations/RequireKotlinInfo\n*L\n82#1:141\n*E\n"})
public final class RequireKotlinInfo
extends DeprecationAnnotationInfo {
    @NotNull
    private final VersionRequirement versionRequirement;

    public RequireKotlinInfo(@NotNull VersionRequirement versionRequirement) {
        Intrinsics.checkNotNullParameter((Object)versionRequirement, (String)"versionRequirement");
        super(null);
        this.versionRequirement = versionRequirement;
    }

    @Override
    @Nullable
    public DeprecationInfo computeDeprecationInfo(@NotNull LanguageVersionSettings languageVersionSettings2) {
        RequireKotlinDeprecationInfo requireKotlinDeprecationInfo;
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        boolean condition$iv = CommonDeprecationUtilsKt.isFulfilled(this.versionRequirement, languageVersionSettings2);
        boolean $i$f$runUnless = false;
        if (condition$iv) {
            requireKotlinDeprecationInfo = null;
        } else {
            DeprecationLevelValue deprecationLevelValue;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[this.versionRequirement.getLevel().ordinal()]) {
                case 1: {
                    deprecationLevelValue = DeprecationLevelValue.WARNING;
                    break;
                }
                case 2: {
                    deprecationLevelValue = DeprecationLevelValue.ERROR;
                    break;
                }
                case 3: {
                    deprecationLevelValue = DeprecationLevelValue.HIDDEN;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            requireKotlinDeprecationInfo = new RequireKotlinDeprecationInfo(deprecationLevelValue, this.versionRequirement);
        }
        return requireKotlinDeprecationInfo;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DeprecationLevel.values().length];
            try {
                nArray[DeprecationLevel.WARNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeprecationLevel.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeprecationLevel.HIDDEN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

