/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt.externalsources;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.javacs.kt.CompilerClassPath;
import org.javacs.kt.ExternalSourcesConfiguration;
import org.javacs.kt.LoggerKt;
import org.javacs.kt.externalsources.ClassContentProvider;
import org.javacs.kt.externalsources.Decompiler;
import org.javacs.kt.externalsources.FernflowerDecompiler;
import org.javacs.kt.externalsources.KlsURI;
import org.javacs.kt.externalsources.SourceArchiveProvider;
import org.javacs.kt.j2k.JavaToKotlinConverterKt;
import org.javacs.kt.util.KotlinLSException;
import org.javacs.kt.util.TemporaryDirectory;
import org.javacs.kt.util.URIsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000A\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005*\u0001\u000e\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\u0012J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\u001e\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u0012H\u0002R\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/javacs/kt/externalsources/ClassContentProvider;", "", "config", "Lorg/javacs/kt/ExternalSourcesConfiguration;", "cp", "Lorg/javacs/kt/CompilerClassPath;", "tempDir", "Lorg/javacs/kt/util/TemporaryDirectory;", "sourceArchiveProvider", "Lorg/javacs/kt/externalsources/SourceArchiveProvider;", "decompiler", "Lorg/javacs/kt/externalsources/Decompiler;", "(Lorg/javacs/kt/ExternalSourcesConfiguration;Lorg/javacs/kt/CompilerClassPath;Lorg/javacs/kt/util/TemporaryDirectory;Lorg/javacs/kt/externalsources/SourceArchiveProvider;Lorg/javacs/kt/externalsources/Decompiler;)V", "cachedContents", "org/javacs/kt/externalsources/ClassContentProvider$cachedContents$1", "Lorg/javacs/kt/externalsources/ClassContentProvider$cachedContents$1;", "contentOf", "Lkotlin/Pair;", "Lorg/javacs/kt/externalsources/KlsURI;", "", "uri", "convertToKotlinIfNeeded", "javaCode", "tryReadContentOf", "server"})
@SourceDebugExtension(value={"SMAP\nClassContentProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassContentProvider.kt\norg/javacs/kt/externalsources/ClassContentProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
public final class ClassContentProvider {
    @NotNull
    private final ExternalSourcesConfiguration config;
    @NotNull
    private final CompilerClassPath cp;
    @NotNull
    private final TemporaryDirectory tempDir;
    @NotNull
    private final SourceArchiveProvider sourceArchiveProvider;
    @NotNull
    private final Decompiler decompiler;
    @NotNull
    private final cachedContents.1 cachedContents;

    public ClassContentProvider(@NotNull ExternalSourcesConfiguration config, @NotNull CompilerClassPath cp, @NotNull TemporaryDirectory tempDir, @NotNull SourceArchiveProvider sourceArchiveProvider, @NotNull Decompiler decompiler) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)cp, (String)"cp");
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        Intrinsics.checkNotNullParameter((Object)sourceArchiveProvider, (String)"sourceArchiveProvider");
        Intrinsics.checkNotNullParameter((Object)decompiler, (String)"decompiler");
        this.config = config;
        this.cp = cp;
        this.tempDir = tempDir;
        this.sourceArchiveProvider = sourceArchiveProvider;
        this.decompiler = decompiler;
        this.cachedContents = new LinkedHashMap<String, Pair<? extends String, ? extends String>>(){

            protected boolean removeEldestEntry(@NotNull Map.Entry<String, Pair<String, String>> eldest) {
                Intrinsics.checkNotNullParameter(eldest, (String)"eldest");
                return this.size() > 5;
            }
        };
    }

    public /* synthetic */ ClassContentProvider(ExternalSourcesConfiguration externalSourcesConfiguration, CompilerClassPath compilerClassPath, TemporaryDirectory temporaryDirectory, SourceArchiveProvider sourceArchiveProvider, Decompiler decompiler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            decompiler = new FernflowerDecompiler();
        }
        this(externalSourcesConfiguration, compilerClassPath, temporaryDirectory, sourceArchiveProvider, decompiler);
    }

    @NotNull
    public final Pair<KlsURI, String> contentOf(@NotNull KlsURI uri) {
        Object resolvedUri;
        String key;
        Pair<String, String> pair;
        Pair<String, String> pair2;
        Object object;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                Object[] objectArray = new Object[]{uri};
                LoggerKt.getLOG().info("Resolving {} for contents", objectArray);
                object = this.sourceArchiveProvider.fetchSourceArchive(uri.getArchivePath());
                if (object == null) break block5;
                Path path = object;
                pair2 = uri.withSource(true);
                Path p0 = path;
                boolean bl = false;
                KlsURI klsURI = pair2.withArchivePath(p0);
                object = klsURI;
                if (klsURI != null) break block6;
            }
            object = uri;
        }
        if ((pair = (Pair<String, String>)this.cachedContents.get((Object)(key = ((KlsURI)(resolvedUri = object)).toString()))) == null) {
            ClassContentProvider $this$contentOf_u24lambda_u240 = this;
            boolean bl = false;
            Object[] objectArray = new Object[]{URIsKt.describeURI((URI)((KlsURI)resolvedUri).getFileUri())};
            LoggerKt.getLOG().info("Reading contents of {}", objectArray);
            Pair<String, String> pair3 = $this$contentOf_u24lambda_u240.tryReadContentOf((KlsURI)resolvedUri);
            if (pair3 == null && (pair3 = $this$contentOf_u24lambda_u240.tryReadContentOf(((KlsURI)resolvedUri).withFileExtension("class"))) == null && (pair3 = $this$contentOf_u24lambda_u240.tryReadContentOf(((KlsURI)resolvedUri).withFileExtension("java"))) == null && (pair3 = $this$contentOf_u24lambda_u240.tryReadContentOf(((KlsURI)resolvedUri).withFileExtension("kt"))) == null) {
                throw new KotlinLSException("Could not find " + uri);
            }
            Pair<String, String> it = pair2 = pair3;
            boolean bl2 = false;
            ((Map)this.cachedContents).put(key, it);
            pair = pair2;
        }
        Pair<String, String> pair4 = pair;
        String contents = (String)pair4.component1();
        String extension = (String)pair4.component2();
        KlsURI sourceUri = ((KlsURI)resolvedUri).withFileExtension(extension);
        return new Pair((Object)sourceUri, (Object)contents);
    }

    private final String convertToKotlinIfNeeded(String javaCode) {
        return this.config.getAutoConvertToKotlin() ? JavaToKotlinConverterKt.convertJavaToKotlin(javaCode, this.cp.getCompiler()) : javaCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<String, String> tryReadContentOf(KlsURI uri) {
        String string;
        try {
            Pair pair;
            string = uri.getFileExtension();
            if (Intrinsics.areEqual((Object)string, (Object)"class")) {
                Object object = uri.extractToTemporaryFile(this.tempDir);
                Decompiler decompiler = this.decompiler;
                Path p0 = object;
                boolean bl = false;
                Object it = decompiler.decompileClass(p0);
                int n = 0;
                InputStream inputStream = Files.newInputStream((Path)it, new OpenOption[0]);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"let(...)");
                Closeable closeable = inputStream;
                object = Charsets.UTF_8;
                it = new InputStreamReader((InputStream)closeable, (Charset)object);
                n = 8192;
                closeable = it instanceof BufferedReader ? (BufferedReader)it : new BufferedReader((Reader)it, n);
                object = null;
                try {
                    Object p02 = (BufferedReader)closeable;
                    boolean bl2 = false;
                    p02 = TextStreamsKt.readText((Reader)((Reader)p02));
                }
                catch (Throwable p02) {
                    object = p02;
                    throw p02;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                }
                Object p03 = p02;
                boolean bl3 = false;
                String string2 = this.config.getAutoConvertToKotlin() ? "kt" : "java";
                String string3 = this.convertToKotlinIfNeeded((String)p03);
                pair = new Pair((Object)string3, (Object)string2);
            } else {
                pair = Intrinsics.areEqual((Object)string, (Object)"java") ? (uri.getSource() ? new Pair((Object)uri.readContents(), (Object)"java") : new Pair((Object)this.convertToKotlinIfNeeded(uri.readContents()), (Object)"kt")) : new Pair((Object)uri.readContents(), (Object)"kt");
            }
            string = pair;
        }
        catch (FileNotFoundException e) {
            string = null;
        }
        return string;
    }
}

