/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.util.ListStack;

public class StrongConnectivityHelper {
    private ListStack<Statement> lstack;
    private int ncounter;
    private HashSet<Statement> tset;
    private HashMap<Statement, Integer> dfsnummap;
    private HashMap<Statement, Integer> lowmap;
    private List<List<Statement>> components;
    private HashSet<Statement> setProcessed;

    public StrongConnectivityHelper() {
    }

    public StrongConnectivityHelper(Statement stat) {
        this.findComponents(stat);
    }

    public List<List<Statement>> findComponents(Statement stat) {
        this.components = new ArrayList<List<Statement>>();
        this.setProcessed = new HashSet();
        this.visitTree(stat.getFirst());
        for (Statement st : stat.getStats()) {
            if (this.setProcessed.contains(st) || !st.getPredecessorEdges(0x40000000).isEmpty()) continue;
            this.visitTree(st);
        }
        for (Statement st : stat.getStats()) {
            if (this.setProcessed.contains(st)) continue;
            this.visitTree(st);
        }
        return this.components;
    }

    public static boolean isExitComponent(List<Statement> lst) {
        HashSet<Statement> set = new HashSet<Statement>();
        for (Statement stat : lst) {
            set.addAll(stat.getNeighbours(1, 1));
        }
        set.removeAll(lst);
        return set.size() == 0;
    }

    public static List<Statement> getExitReps(List<List<Statement>> lst) {
        ArrayList<Statement> res = new ArrayList<Statement>();
        for (List<Statement> comp : lst) {
            if (!StrongConnectivityHelper.isExitComponent(comp)) continue;
            res.add(comp.get(0));
        }
        return res;
    }

    private void visitTree(Statement stat) {
        this.lstack = new ListStack();
        this.ncounter = 0;
        this.tset = new HashSet();
        this.dfsnummap = new HashMap();
        this.lowmap = new HashMap();
        this.visit(stat);
        this.setProcessed.addAll(this.tset);
        this.setProcessed.add(stat);
    }

    private void visit(Statement stat) {
        this.lstack.push(stat);
        this.dfsnummap.put(stat, this.ncounter);
        this.lowmap.put(stat, this.ncounter);
        ++this.ncounter;
        List<Statement> lstSuccs = stat.getNeighbours(1, 1);
        lstSuccs.removeAll(this.setProcessed);
        for (int i = 0; i < lstSuccs.size(); ++i) {
            int secvalue;
            Statement succ = lstSuccs.get(i);
            if (this.tset.contains(succ)) {
                secvalue = this.dfsnummap.get(succ);
            } else {
                this.tset.add(succ);
                this.visit(succ);
                secvalue = this.lowmap.get(succ);
            }
            this.lowmap.put(stat, Math.min(this.lowmap.get(stat), secvalue));
        }
        if (this.lowmap.get(stat).intValue() == this.dfsnummap.get(stat).intValue()) {
            Statement v;
            ArrayList<Statement> lst = new ArrayList<Statement>();
            do {
                v = this.lstack.pop();
                lst.add(v);
            } while (v != stat);
            this.components.add(lst);
        }
    }

    public List<List<Statement>> getComponents() {
        return this.components;
    }

    public void setComponents(List<List<Statement>> components) {
        this.components = components;
    }
}

