/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.ArrayList;
import java.util.Arrays;
import org.h2.command.dml.Query;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionList;
import org.h2.expression.ExpressionVisitor;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueRow;

public class Subquery
extends Expression {
    private final Query query;
    private Expression expression;

    public Subquery(Query query) {
        this.query = query;
    }

    @Override
    public Value getValue(Session session) {
        this.query.setSession(session);
        try (ResultInterface resultInterface = this.query.query(2);){
            Value value;
            if (!resultInterface.next()) {
                value = ValueNull.INSTANCE;
            } else {
                value = Subquery.readRow(resultInterface);
                if (resultInterface.hasNext()) {
                    throw DbException.get(90053);
                }
            }
            Value value2 = value;
            return value2;
        }
    }

    public ArrayList<Value> getAllRows(Session session) {
        ArrayList<Value> arrayList = new ArrayList<Value>();
        this.query.setSession(session);
        try (ResultInterface resultInterface = this.query.query(Integer.MAX_VALUE);){
            while (resultInterface.next()) {
                arrayList.add(Subquery.readRow(resultInterface));
            }
        }
        return arrayList;
    }

    private static Value readRow(ResultInterface resultInterface) {
        Value[] valueArray = resultInterface.currentRow();
        int n = resultInterface.getVisibleColumnCount();
        return n == 1 ? valueArray[0] : ValueRow.get(n == valueArray.length ? valueArray : Arrays.copyOf(valueArray, n));
    }

    @Override
    public TypeInfo getType() {
        return this.getExpression().getType();
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        this.query.mapColumns(columnResolver, n + 1);
    }

    @Override
    public Expression optimize(Session session) {
        session.optimizeQueryExpression(this.query);
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.query.setEvaluatable(tableFilter, bl);
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        return stringBuilder.append('(').append(this.query.getPlanSQL(bl)).append(')');
    }

    @Override
    public void updateAggregate(Session session, int n) {
        this.query.updateAggregate(session, n);
    }

    private Expression getExpression() {
        if (this.expression == null) {
            ArrayList<Expression> arrayList = this.query.getExpressions();
            int n = this.query.getColumnCount();
            if (n == 1) {
                this.expression = arrayList.get(0);
            } else {
                Expression[] expressionArray = new Expression[n];
                for (int i = 0; i < n; ++i) {
                    expressionArray[i] = arrayList.get(i);
                }
                this.expression = new ExpressionList(expressionArray, false);
            }
        }
        return this.expression;
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.query.isEverything(expressionVisitor);
    }

    public Query getQuery() {
        return this.query;
    }

    @Override
    public int getCost() {
        return this.query.getCostAsExpression();
    }

    @Override
    public Expression[] getExpressionColumns(Session session) {
        return this.getExpression().getExpressionColumns(session);
    }
}

