/*
 * LALXMLVCSInfo.h - LALXML VCS Information
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 * Copyright (C) 2014 Karl Wette
 */

#ifndef _LALXMLVCSINFO_H
#define _LALXMLVCSINFO_H

#include <lal/LALVCSInfoType.h>

#ifdef __cplusplus
extern "C" {
#endif

/* global variables for vcs information */
extern const char *const lalXMLVCSVersion;
extern const char *const lalXMLVCSId;
extern const char *const lalXMLVCSDate;
extern const char *const lalXMLVCSBranch;
extern const char *const lalXMLVCSTag;
extern const char *const lalXMLVCSAuthor;
extern const char *const lalXMLVCSCommitter;
extern const char *const lalXMLVCSStatus;

/* global variables for vcs information - identable */
extern const char *const lalXMLVCSIdentId;
extern const char *const lalXMLVCSIdentDate;
extern const char *const lalXMLVCSIdentBranch;
extern const char *const lalXMLVCSIdentTag;
extern const char *const lalXMLVCSIdentAuthor;
extern const char *const lalXMLVCSIdentCommitter;
extern const char *const lalXMLVCSIdentStatus;

/* library vcs information structure */
extern const struct tagLALVCSInfo lalXMLVCSInfo;

/* configure arguments */
extern const char *const lalXMLConfigureArgs;

/* configure date */
extern const char *const lalXMLConfigureDate;

/* build date */
extern const char *const lalXMLBuildDate;

#ifdef __cplusplus
}
#endif

#endif /* _LALXMLVCSINFO_H */

/*
 * vim: tw=0 ts=2 et
 */
