/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.molxyz;

import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.util.Logger;

public class MolReader
extends AtomSetCollectionReader {
    boolean is2D;
    private static final String isotopeMap0 = "H1 H2 ";
    private static final String isotopeMap1 = "D  T  ";

    public void initializeReader() throws Exception {
        this.is2D = this.filter != null && this.filter.toUpperCase().indexOf("2D") >= 0;
    }

    protected boolean checkLine() throws Exception {
        boolean bl = this.line.startsWith("$MDL");
        if (bl) {
            this.discardLinesUntilStartsWith("$HDR");
            this.readLine();
            if (this.line == null) {
                Logger.warn((String)"$HDR not found in MDL RG file");
                this.continuing = false;
                return false;
            }
        }
        if (this.doGetModel(++this.modelNumber)) {
            this.processMolSdHeader();
            if (bl) {
                this.discardLinesUntilStartsWith("$CTAB");
            }
            this.processCtab();
            if (this.isLastModel(this.modelNumber)) {
                this.continuing = false;
                return false;
            }
        }
        this.discardLinesUntilStartsWith("$$$$");
        return true;
    }

    public void finalizeReader() throws Exception {
        if (this.is2D) {
            this.set2D(true);
        }
    }

    void processMolSdHeader() throws Exception {
        String string = "";
        String string2 = this.line;
        string = string + this.line + "\n";
        this.atomSetCollection.setCollectionName(this.line);
        this.readLine();
        if (this.line == null) {
            return;
        }
        string = string + this.line + "\n";
        this.readLine();
        if (this.line == null) {
            return;
        }
        string = string + this.line + "\n";
        this.checkLineForScript();
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("fileHeader", (Object)string);
        this.newAtomSet(string2);
    }

    void processCtab() throws Exception {
        this.readLine();
        if (this.line == null) {
            return;
        }
        int n = this.parseInt(this.line, 0, 3);
        int n2 = this.parseInt(this.line, 3, 6);
        int n3 = this.atomSetCollection.getAtomCount();
        this.readAtoms(n);
        this.readBonds(n3, n2);
        this.applySymmetryAndSetTrajectory();
    }

    void readAtoms(int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            this.readLine();
            String string = "";
            string = this.line.length() > 34 ? this.line.substring(31, 34).trim().intern() : this.line.substring(31).trim().intern();
            float f = this.parseFloat(this.line, 0, 10);
            float f2 = this.parseFloat(this.line, 10, 20);
            float f3 = this.parseFloat(this.line, 20, 30);
            if (this.is2D && f3 != 0.0f) {
                this.is2D = false;
            }
            int n2 = 0;
            if (this.line.length() >= 39) {
                int n3 = this.parseInt(this.line, 36, 39);
                if (n3 >= 1 && n3 <= 7) {
                    n2 = 4 - n3;
                }
                if ((n3 = this.parseInt(this.line, 34, 36)) != 0 && n3 >= -3 && n3 <= 4) {
                    int n4 = isotopeMap0.indexOf(string + n3);
                    if (n4 >= 0) {
                        string = isotopeMap1.substring(n4, n4 + 3).trim();
                    } else if (string == "C") {
                        string = 12 + n3 + "C";
                    } else if (string == "N") {
                        string = 14 + n3 + "N";
                    }
                }
            }
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = string;
            atom.formalCharge = n2;
            this.setAtomCoord(atom, f, f2, f3);
        }
    }

    void readBonds(int n, int n2) throws Exception {
        for (int i = 0; i < n2; ++i) {
            this.readLine();
            int n3 = this.parseInt(this.line, 0, 3);
            int n4 = this.parseInt(this.line, 3, 6);
            int n5 = this.parseInt(this.line, 6, 9);
            switch (n5) {
                case -10: 
                case 0: {
                    n5 = 1;
                    break;
                }
                case 1: {
                    if (!this.is2D) break;
                    switch (this.line.length() >= 12 ? this.parseInt(this.line.substring(9, 12)) : 0) {
                        case 1: {
                            n5 = 1025;
                            break;
                        }
                        case 6: {
                            n5 = 1041;
                        }
                    }
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    n5 = 515;
                    break;
                }
                case 5: {
                    n5 = 66;
                    break;
                }
                case 6: {
                    n5 = 513;
                    break;
                }
                case 7: {
                    n5 = 514;
                    break;
                }
                case 8: {
                    n5 = 33;
                }
            }
            this.atomSetCollection.addBond(new Bond(n + n3 - 1, n + n4 - 1, n5));
        }
    }
}

