/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.data;

import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.util.MeshSurface;

public class MeshData
extends MeshSurface {
    public static final int MODE_GET_VERTICES = 1;
    public static final int MODE_GET_COLOR_INDEXES = 2;
    public static final int MODE_PUT_SETS = 3;
    public static final int MODE_PUT_VERTICES = 4;
    private boolean setsSuccessful;
    public int vertexIncrement = 1;
    public String polygonColorData;

    public int addVertexCopy(Point3f point3f, float f, int n) {
        if (n < 0) {
            this.vertexIncrement = -n;
        }
        return this.addVertexCopy(point3f, f);
    }

    public BitSet[] getSurfaceSet() {
        return this.surfaceSet == null ? this.getSurfaceSet(0) : this.surfaceSet;
    }

    public BitSet[] getSurfaceSet(int n) {
        int n2;
        int n3;
        int n4;
        if (n == 0) {
            this.surfaceSet = new BitSet[100];
            this.nSets = 0;
        }
        this.setsSuccessful = true;
        for (n4 = 0; n4 < this.polygonCount; ++n4) {
            if (this.polygonIndexes[n4] == null) continue;
            int[] nArray = this.polygonIndexes[n4];
            n3 = this.findSet(nArray[0]);
            n2 = this.findSet(nArray[1]);
            int n5 = this.findSet(nArray[2]);
            if (n3 < 0 && n2 < 0 && n5 < 0) {
                this.createSet(nArray[0], nArray[1], nArray[2]);
                continue;
            }
            if (n3 == n2 && n2 == n5) continue;
            if (n3 >= 0) {
                this.surfaceSet[n3].set(nArray[1]);
                this.surfaceSet[n3].set(nArray[2]);
                if (n2 >= 0 && n2 != n3) {
                    this.mergeSets(n3, n2);
                }
                if (n5 < 0 || n5 == n3 || n5 == n2) continue;
                this.mergeSets(n3, n5);
                continue;
            }
            if (n2 >= 0) {
                this.surfaceSet[n2].set(nArray[0]);
                this.surfaceSet[n2].set(nArray[2]);
                if (n5 < 0 || n5 == n2) continue;
                this.mergeSets(n2, n5);
                continue;
            }
            this.surfaceSet[n5].set(nArray[0]);
            this.surfaceSet[n5].set(nArray[1]);
        }
        n4 = 0;
        for (int i = 0; i < this.nSets; ++i) {
            if (this.surfaceSet[i] == null) continue;
            ++n4;
        }
        BitSet[] bitSetArray = new BitSet[100];
        n4 = 0;
        for (n3 = 0; n3 < this.nSets; ++n3) {
            if (this.surfaceSet[n3] == null) continue;
            bitSetArray[n4++] = this.surfaceSet[n3];
        }
        this.nSets = n4;
        this.surfaceSet = bitSetArray;
        if (!this.setsSuccessful && n < 2) {
            this.getSurfaceSet(n + 1);
        }
        if (n == 0) {
            this.vertexSets = new int[this.vertexCount];
            for (n3 = 0; n3 < this.nSets; ++n3) {
                n2 = this.surfaceSet[n3].nextSetBit(0);
                while (n2 >= 0) {
                    this.vertexSets[n2] = n3;
                    n2 = this.surfaceSet[n3].nextSetBit(n2 + 1);
                }
            }
        }
        return this.surfaceSet;
    }

    private int findSet(int n) {
        for (int i = 0; i < this.nSets; ++i) {
            if (this.surfaceSet[i] == null || !this.surfaceSet[i].get(n)) continue;
            return i;
        }
        return -1;
    }

    private void createSet(int n, int n2, int n3) {
        int n4;
        for (n4 = 0; n4 < this.nSets && this.surfaceSet[n4] != null; ++n4) {
        }
        if (n4 >= 100) {
            this.setsSuccessful = false;
            return;
        }
        this.surfaceSet[n4] = new BitSet();
        this.surfaceSet[n4].set(n);
        this.surfaceSet[n4].set(n2);
        this.surfaceSet[n4].set(n3);
        if (n4 == this.nSets) {
            ++this.nSets;
        }
    }

    private void mergeSets(int n, int n2) {
        this.surfaceSet[n].or(this.surfaceSet[n2]);
        this.surfaceSet[n2] = null;
    }

    public void invalidateSurfaceSet(int n) {
        int n2 = this.surfaceSet[n].nextSetBit(0);
        while (n2 >= 0) {
            this.vertexValues[n2] = Float.NaN;
            n2 = this.surfaceSet[n].nextSetBit(n2 + 1);
        }
        this.surfaceSet[n] = null;
    }

    public static boolean checkCutoff(int n, int n2, int n3, float[] fArray) {
        if (n < 0 || n2 < 0 || n3 < 0) {
            return false;
        }
        float f = fArray[n];
        float f2 = fArray[n2];
        float f3 = fArray[n3];
        return f >= 0.0f && f2 >= 0.0f && f3 >= 0.0f || f <= 0.0f && f2 <= 0.0f && f3 <= 0.0f;
    }
}

