/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.atomdata.AtomDataServer;
import org.jmol.atomdata.RadiusData;
import org.jmol.g3d.Graphics3D;
import org.jmol.geodesic.EnvelopeCalculation;
import org.jmol.modelset.Atom;
import org.jmol.shape.AtomShape;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.FastBitSet;
import org.jmol.util.Logger;

public class Dots
extends AtomShape {
    public EnvelopeCalculation ec;
    public boolean isSurface = false;
    static final float SURFACE_DISTANCE_FOR_CALCULATION = 10.0f;
    BitSet bsOn = new BitSet();
    private BitSet bsSelected;
    private BitSet bsIgnore;
    static int MAX_LEVEL = 3;
    int thisAtom;
    float thisRadius;
    int thisArgb;
    RadiusData rdLast = new RadiusData();

    public void initShape() {
        super.initShape();
        this.translucentAllowed = false;
        this.ec = new EnvelopeCalculation((AtomDataServer)this.viewer, this.atomCount, this.mads, this.viewer.getTestFlag2());
    }

    public int getSize(int n) {
        return this.mads == null ? (int)(this.ec.getRadius(n) * 2000.0f) : this.mads[n] * 2;
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if ("init" == string) {
            this.initialize();
            return;
        }
        if ("translucency" == string && !this.translucentAllowed) {
            return;
        }
        if ("ignore" == string) {
            this.bsIgnore = (BitSet)object;
            return;
        }
        if ("select" == string) {
            this.bsSelected = (BitSet)object;
            return;
        }
        if ("radius" == string) {
            this.thisRadius = ((Float)object).floatValue();
            if (this.thisRadius > 16.0f) {
                this.thisRadius = 16.0f;
            }
            return;
        }
        if ("colorRGB" == string) {
            this.thisArgb = (Integer)object;
            return;
        }
        if ("atom" == string) {
            this.thisAtom = (Integer)object;
            this.atoms[this.thisAtom].setShapeVisibility(this.myVisibilityFlag, true);
            this.ec.allocDotsConvexMaps(this.atomCount);
            return;
        }
        if ("dots" == string) {
            this.isActive = true;
            this.ec.setFromBits(this.thisAtom, (BitSet)object);
            this.atoms[this.thisAtom].setShapeVisibility(this.myVisibilityFlag, true);
            if (this.mads == null) {
                this.ec.setMads(null);
                this.mads = new short[this.atomCount];
                for (int i = 0; i < this.atomCount; ++i) {
                    if (!this.atoms[i].isInFrame() || !this.atoms[i].isShapeVisible(this.myVisibilityFlag)) continue;
                    this.mads[i] = (short)(this.ec.getAppropriateRadius(i) * 1000.0f);
                }
                this.ec.setMads(this.mads);
            }
            this.mads[this.thisAtom] = (short)(this.thisRadius * 1000.0f);
            if (this.colixes == null) {
                this.colixes = new short[this.atomCount];
                this.paletteIDs = new byte[this.atomCount];
            }
            this.colixes[this.thisAtom] = Graphics3D.getColix((int)this.thisArgb);
            this.bsOn.set(this.thisAtom);
            return;
        }
        if ("refreshTrajectories" == string) {
            this.ec.reCalculate(bitSet);
            return;
        }
        if (string == "deleteModelAtoms") {
            int n = ((int[])((Object[])object)[2])[1];
            int n2 = ((int[])((Object[])object)[2])[2];
            BitSetUtil.deleteBits((BitSet)this.bsOn, (BitSet)bitSet);
            this.ec.deleteAtoms(n, n2);
        }
        super.setProperty(string, object, bitSet);
    }

    void initialize() {
        this.bsSelected = null;
        this.bsIgnore = null;
        this.isActive = false;
        if (this.ec == null) {
            this.ec = new EnvelopeCalculation((AtomDataServer)this.viewer, this.atomCount, this.mads, this.viewer.getTestFlag2());
        }
    }

    public void setSize(RadiusData radiusData, BitSet bitSet) {
        FastBitSet[] fastBitSetArray;
        int n;
        int n2;
        boolean bl;
        float f;
        if (radiusData == null) {
            radiusData = new RadiusData(0.0f, 0, 0);
        }
        if (this.bsSelected != null) {
            bitSet = this.bsSelected;
        }
        if (Logger.debugging) {
            Logger.debug((String)("Dots.setSize " + radiusData.value));
        }
        boolean bl2 = true;
        float f2 = Float.MAX_VALUE;
        this.isActive = true;
        switch (radiusData.type) {
            case 0: {
                if (radiusData.value == 0.0f) {
                    bl2 = false;
                }
                f2 = radiusData.value;
                break;
            }
        }
        if (radiusData.type != 1) {
            radiusData.valueExtended = this.viewer.getCurrentSolventProbeRadius();
        }
        switch (radiusData.vdwType) {
            case 1112539137: 
            case 1112539138: 
            case 1112541198: {
                f = f2;
                break;
            }
            case 1112541194: {
                f = this.modelSet.getMaxVanderwaalsRadius() * 2.0f;
                break;
            }
            default: {
                f = this.modelSet.getMaxVanderwaalsRadius();
            }
        }
        if (Logger.debugging) {
            Logger.startTimer();
        }
        boolean bl3 = bl = this.rdLast.value != radiusData.value || this.rdLast.valueExtended != radiusData.valueExtended || this.rdLast.type != radiusData.type || this.rdLast.vdwType != radiusData.vdwType || this.ec.getDotsConvexMax() == 0;
        if (bl2) {
            n2 = bitSet.nextSetBit(0);
            while (n2 >= 0) {
                if (!this.bsOn.get(n2)) {
                    this.bsOn.set(n2);
                    bl = true;
                }
                n2 = bitSet.nextSetBit(n2 + 1);
            }
        } else {
            n2 = bitSet == null ? 1 : 0;
            int n3 = n = n2 != 0 ? this.atomCount - 1 : bitSet.nextSetBit(0);
            while (n3 >= 0) {
                this.bsOn.set(n3, false);
                n3 = n2 != 0 ? n3 - 1 : bitSet.nextSetBit(n3 + 1);
            }
        }
        n2 = this.atomCount;
        while (--n2 >= 0) {
            this.atoms[n2].setShapeVisibility(this.myVisibilityFlag, this.bsOn.get(n2));
        }
        if (!bl2) {
            return;
        }
        if (bl) {
            this.mads = null;
            this.ec.newSet();
        }
        if ((fastBitSetArray = this.ec.getDotsConvexMaps()) != null) {
            n = this.atomCount;
            while (--n >= 0) {
                if (!this.bsOn.get(n)) continue;
                fastBitSetArray[n] = null;
            }
        }
        if (fastBitSetArray == null) {
            this.colixes = new short[this.atomCount];
            this.paletteIDs = new byte[this.atomCount];
        }
        this.ec.calculate(radiusData, f, this.bsOn, this.bsIgnore, !this.viewer.getDotSurfaceFlag(), this.viewer.getDotsSelectedOnlyFlag(), this.isSurface, true);
        this.rdLast = radiusData;
        if (Logger.debugging) {
            Logger.checkTimer((String)"dots generation time");
        }
    }

    public void setModelClickability() {
        int n = this.atomCount;
        while (--n >= 0) {
            Atom atom = this.atoms[n];
            if ((atom.getShapeVisibilityFlags() & this.myVisibilityFlag) == 0 || this.modelSet.isAtomHidden(n)) continue;
            atom.setClickable(this.myVisibilityFlag);
        }
    }

    public String getShapeState() {
        FastBitSet[] fastBitSetArray = this.ec.getDotsConvexMaps();
        if (fastBitSetArray == null || this.ec.getDotsConvexMax() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Hashtable hashtable = new Hashtable();
        int n = this.viewer.getAtomCount();
        String string = this.isSurface ? "geoSurface " : "dots ";
        for (int i = 0; i < n; ++i) {
            FastBitSet fastBitSet;
            if (fastBitSetArray[i] == null || !this.bsOn.get(i)) continue;
            if (this.bsColixSet != null && this.bsColixSet.get(i)) {
                Dots.setStateInfo(hashtable, (int)i, (String)this.getColorCommand(string, this.paletteIDs[i], this.colixes[i]));
            }
            if ((fastBitSet = fastBitSetArray[i]).isEmpty()) continue;
            float f = this.ec.getAppropriateRadius(i);
            Dots.appendCmd((StringBuffer)stringBuffer, (String)(string + i + " radius " + f + " " + Escape.escape((BitSet)fastBitSet.toBitSet())));
        }
        stringBuffer.append(Dots.getShapeCommands(hashtable, null));
        return stringBuffer.toString();
    }
}

