/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BasisFunctionReader
extends AtomSetCollectionReader {
    protected Map<String, Object> moData = new Hashtable<String, Object>();
    protected List<Map<String, Object>> orbitals = new ArrayList<Map<String, Object>>();
    protected int nOrbitals = 0;
    protected int[][] dfCoefMaps;
    protected static String CANONICAL_DC_LIST = "DXX   DYY   DZZ   DXY   DXZ   DYZ";
    protected static String CANONICAL_FC_LIST = "XXX   YYY   ZZZ   XYY   XXY   XXZ   XZZ   YZZ   YYZ   XYZ";
    protected static String CANONICAL_DS_LIST = "d0    d1+   d1-   d2+   d2-";
    protected static String CANONICAL_FS_LIST = "f0    f1+   f1-   f2+   f2-   f3+   f3-";

    BasisFunctionReader() {
    }

    protected void setMO(Map<String, Object> map) {
        if (this.dfCoefMaps != null) {
            map.put("dfCoefMaps", this.dfCoefMaps);
        }
        this.orbitals.add(map);
    }

    protected boolean isQuantumBasisSupported(char c) {
        return "SPLDF".indexOf(Character.toUpperCase(c)) >= 0;
    }

    protected boolean getDFMap(String string, int n, String string2, int n2) {
        if (string.equals(string2)) {
            return true;
        }
        if (this.dfCoefMaps == null) {
            this.dfCoefMaps = new int[][]{null, null, null, new int[5], new int[6], new int[7], new int[10]};
        }
        String[] stringArray = BasisFunctionReader.getTokens((String)string);
        boolean bl = true;
        for (int i = 0; i < this.dfCoefMaps[n].length && bl; ++i) {
            int n3;
            String string3 = stringArray[i];
            if (string3.length() >= n2 && (n3 = string2.indexOf(string3)) >= 0) {
                this.dfCoefMaps[n][n3 /= 6] = i - n3;
                continue;
            }
            bl = false;
        }
        if (!bl) {
            Logger.error((String)("Disabling orbitals of type " + n + " -- Cannot read orbital order for: " + string + "\n expecting: " + string2));
            this.dfCoefMaps[n][0] = Integer.MIN_VALUE;
        }
        return bl;
    }

    protected static final String canonicalizeQuantumSubshellTag(String string) {
        char c = string.charAt(0);
        if (c == 'X' || c == 'Y' || c == 'Z') {
            char[] cArray = string.toCharArray();
            Arrays.sort(cArray);
            return new String(cArray);
        }
        return string;
    }

    protected void fixSlaterTypes(int n, int n2) {
        List list = (List)this.moData.get("shells");
        int n3 = list.size();
        while (--n3 >= 0) {
            int[] nArray = (int[])list.get(n3);
            if (nArray[1] != n) continue;
            nArray[1] = n2;
        }
    }
}

