/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import org.jmol.adapter.readers.quantum.MopacSlaterReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class MoldenReader
extends MopacSlaterReader {
    protected float[] frequencies = null;
    protected AtomSetCollection freqAtomSet = null;

    protected boolean checkLine() throws Exception {
        if (this.line.indexOf("[Atoms]") >= 0 || this.line.indexOf("[ATOMS]") >= 0) {
            this.readAtoms();
            return false;
        }
        if (this.line.indexOf("[GTO]") >= 0) {
            this.readGaussianBasis();
            return false;
        }
        if (this.line.indexOf("[MO]") >= 0) {
            this.readMolecularOrbitals();
            return false;
        }
        if (this.line.indexOf("[FREQ]") >= 0) {
            this.readFreqsAndModes();
            return false;
        }
        return true;
    }

    void readAtoms() throws Exception {
        boolean bl;
        String string = this.getTokens()[1];
        int n = 0;
        int n2 = 0;
        boolean bl2 = bl = string.indexOf("Angs") < 0;
        if (bl && string.indexOf("AU") < 0) {
            throw new Exception("invalid coordinate unit " + string + " in [Atoms]");
        }
        this.readLine();
        while (this.line != null && this.line.indexOf(91) < 0) {
            Atom atom = this.atomSetCollection.addNewAtom();
            String[] stringArray = this.getTokens();
            atom.atomName = stringArray[0];
            n2 = this.parseInt(stringArray[1]);
            if (n > 0 && n2 != n + 1) {
                throw new Exception("out of order atom in [Atoms]");
            }
            n = n2;
            atom.set(this.parseFloat(stringArray[3]), this.parseFloat(stringArray[4]), this.parseFloat(stringArray[5]));
            this.readLine();
        }
        if (bl) {
            int n3 = this.atomSetCollection.getAtomCount();
            while (--n3 >= 0) {
                this.atomSetCollection.getAtom(n3).scale(0.5291772f);
            }
        }
    }

    void readGaussianBasis() throws Exception {
        Object object;
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        ArrayList<float[]> arrayList2 = new ArrayList<float[]>();
        int n = 0;
        int n2 = 0;
        while (this.readLine() != null && (this.line = this.line.trim()).length() != 0 && this.line.charAt(0) != '[') {
            object = this.getTokens();
            n = this.parseInt((String)object[0]) - 1;
            while (this.readLine() != null && this.line.trim().length() > 0) {
                object = this.getTokens();
                String string = object[0].toUpperCase();
                int n3 = this.parseInt((String)object[1]);
                int[] nArray = new int[]{n, JmolAdapter.getQuantumShellTagID((String)string), n2, n3};
                int n4 = n3;
                while (--n4 >= 0) {
                    String[] stringArray = MoldenReader.getTokens((String)this.readLine());
                    int n5 = stringArray.length;
                    float[] fArray = new float[n5];
                    for (int i = 0; i < n5; ++i) {
                        fArray[i] = this.parseFloat(stringArray[i]);
                    }
                    arrayList2.add(fArray);
                    ++n2;
                }
                arrayList.add(nArray);
            }
        }
        object = new float[n2][];
        for (int i = 0; i < n2; ++i) {
            object[i] = (float[])arrayList2.get(i);
        }
        this.moData.put("shells", arrayList);
        this.moData.put("gaussians", object);
        if (Logger.debugging) {
            Logger.debug((String)(arrayList.size() + " slater shells read"));
            Logger.debug((String)(((float[][])object).length + " gaussian primitives read"));
        }
        this.atomSetCollection.setAtomSetAuxiliaryInfo("moData", (Object)this.moData);
    }

    void readMolecularOrbitals() throws Exception {
        this.readLine();
        if (this.line.equals("[5D]")) {
            this.fixSlaterTypes(4, 3);
            this.fixSlaterTypes(6, 5);
            this.readLine();
        }
        String[] stringArray = this.getTokens();
        while (stringArray != null && this.line.indexOf(91) < 0) {
            Object[] objectArray;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            ArrayList<String> arrayList = new ArrayList<String>();
            float f = Float.NaN;
            float f2 = Float.NaN;
            while (stringArray != null && this.parseInt(stringArray[0]) == Integer.MIN_VALUE) {
                if (stringArray[0].startsWith("Ene")) {
                    objectArray = this.splitKeyValue();
                    f = this.parseFloat((String)objectArray[1]);
                } else if (stringArray[0].startsWith("Occup")) {
                    objectArray = this.splitKeyValue();
                    f2 = this.parseFloat((String)objectArray[1]);
                }
                stringArray = MoldenReader.getTokens((String)this.readLine());
            }
            if (stringArray == null) {
                throw new Exception("error reading MOs: unexpected EOF reading coeffs");
            }
            while (stringArray != null && this.parseInt(stringArray[0]) != Integer.MIN_VALUE) {
                if (stringArray.length != 2) {
                    throw new Exception("invalid MO coefficient specification");
                }
                arrayList.add(stringArray[1]);
                stringArray = MoldenReader.getTokens((String)this.readLine());
            }
            objectArray = new float[arrayList.size()];
            int n = arrayList.size();
            while (--n >= 0) {
                objectArray[n] = this.parseFloat((String)arrayList.get(n));
            }
            hashtable.put("energy", new Float(f));
            hashtable.put("occupancy", new Float(f2));
            hashtable.put("coefficients", objectArray);
            this.setMO(hashtable);
            if (!Logger.debugging) continue;
            Logger.debug((String)(objectArray.length + " coefficients in MO " + this.orbitals.size()));
        }
        Logger.debug((String)("read " + this.orbitals.size() + " MOs"));
        this.setMOs("eV");
    }

    void readFreqsAndModes() throws Exception {
        String[] stringArray;
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (this.readLine() != null && this.line.indexOf(91) < 0) {
            arrayList.add(this.getTokens()[0]);
        }
        if (this.line.indexOf("[FR-COORD]") < 0) {
            throw new Exception("error reading normal modes: [FREQ] must be followed by [FR-COORD]");
        }
        int n2 = arrayList.size();
        int n3 = this.atomSetCollection.getFirstAtomSetAtomCount();
        this.atomSetCollection.cloneLastAtomSet();
        this.atomSetCollection.setAtomSetName("frequency base geometry");
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        int n4 = this.atomSetCollection.getLastAtomSetAtomIndex();
        for (n = 0; n < n3; ++n) {
            stringArray = MoldenReader.getTokens((String)this.readLine());
            Atom atom = atomArray[n + n4];
            atom.atomName = stringArray[0];
            atom.set(this.parseFloat(stringArray[1]), this.parseFloat(stringArray[2]), this.parseFloat(stringArray[3]));
            atom.scale(0.5291772f);
        }
        this.readLine();
        if (this.line.indexOf("[FR-NORM-COORD]") < 0) {
            throw new Exception("error reading normal modes: [FR-COORD] must be followed by [FR-NORM-COORD]");
        }
        for (n = 0; n < n2; ++n) {
            boolean bl;
            if (this.readLine().indexOf("Vibration") < 0) {
                throw new Exception("error reading normal modes: expected vibration data");
            }
            boolean bl2 = bl = !this.doGetVibration(n + 1);
            if (!bl) {
                this.atomSetCollection.cloneLastAtomSet();
                this.atomSetCollection.setAtomSetFrequency(null, null, "" + (String)arrayList.get(n), null);
                n4 = this.atomSetCollection.getLastAtomSetAtomIndex();
            }
            for (int i = 0; i < n3; ++i) {
                stringArray = MoldenReader.getTokens((String)this.readLine());
                if (bl) continue;
                this.atomSetCollection.addVibrationVector(i + n4, this.parseFloat(stringArray[0]) * 0.5291772f, this.parseFloat(stringArray[1]) * 0.5291772f, this.parseFloat(stringArray[2]) * 0.5291772f);
            }
        }
        this.readLine();
    }

    String[] splitKeyValue() {
        return this.splitKeyValue("=", this.line);
    }

    String[] splitKeyValue(String string) {
        return this.splitKeyValue(string, this.line);
    }

    String[] splitKeyValue(String string, String string2) throws NoSuchElementException {
        String[] stringArray = new String[2];
        int n = string2.indexOf(string);
        if (n < 0) {
            throw new NoSuchElementException("separator not found");
        }
        stringArray[0] = string2.substring(0, n);
        stringArray[1] = string2.substring(n + string.length());
        return stringArray;
    }
}

