/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import java.util.BitSet;
import java.util.List;
import javax.vecmath.Point3f;
import org.jmol.api.MOCalculationInterface;
import org.jmol.api.VolumeDataInterface;
import org.jmol.quantum.QuantumCalculation;
import org.jmol.quantum.SlaterData;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MOCalculation
extends QuantumCalculation
implements MOCalculationInterface {
    private static final double CUT = -50.0;
    private static final int MAX_GRID = 80;
    final float[] CX = new float[80];
    final float[] CY = new float[80];
    final float[] CZ = new float[80];
    final float[] DXY = new float[80];
    final float[] DXZ = new float[80];
    final float[] DYZ = new float[80];
    final float[] EX = new float[80];
    final float[] EY = new float[80];
    final float[] EZ = new float[80];
    private String calculationType;
    private List<int[]> shells;
    private float[][] gaussians;
    private SlaterData[] slaters;
    private float[] moCoefficients;
    private int moCoeff;
    private int gaussianPtr;
    private int firstAtomOffset;
    private boolean isElectronDensity;
    private float occupancy = 2.0f;
    private boolean doNormalize = true;
    private int[][] dfCoefMaps = new int[][]{null, null, null, new int[5], new int[6], new int[7], new int[10]};
    protected float[][][] voxelDataTemp;
    boolean as5D = false;
    private int nGaussians;
    private static final float ROOT3 = 1.7320508f;

    public void calculate(VolumeDataInterface volumeDataInterface, BitSet bitSet, String string, Point3f[] point3fArray, int n, List<int[]> list, float[][] fArray, int[][] nArray, Object object, float[] fArray2, float[] fArray3, boolean bl) {
        boolean bl2 = false;
        this.calculationType = string;
        this.firstAtomOffset = n;
        this.shells = list;
        this.gaussians = fArray;
        if (nArray != null) {
            this.dfCoefMaps = nArray;
        }
        this.slaters = (SlaterData[])object;
        this.moCoefficients = fArray2;
        this.isElectronDensity = bl2 || fArray3 != null;
        this.doNormalize = bl;
        int[] nArray2 = volumeDataInterface.getVoxelCounts();
        this.initialize(nArray2[0], nArray2[1], nArray2[2]);
        this.voxelData = volumeDataInterface.getVoxelData();
        this.voxelDataTemp = this.isElectronDensity ? new float[this.nX][this.nY][this.nZ] : this.voxelData;
        this.setupCoordinates(volumeDataInterface.getOriginFloat(), volumeDataInterface.getVolumetricVectorLengths(), bitSet, point3fArray);
        this.atomIndex = n - 1;
        this.doDebug = Logger.debugging;
        if (object == null) {
            this.createGaussianCube();
        } else {
            this.createSlaterCube();
        }
        if (this.doDebug || bl2 || this.isElectronDensity) {
            this.calculateElectronDensity(fArray3);
        }
    }

    public void calculateElectronDensity(float[] fArray) {
        float f = 0.0f;
        int n = this.nX;
        while (--n >= 0) {
            int n2 = this.nY;
            while (--n2 >= 0) {
                int n3 = this.nZ;
                while (--n3 >= 0) {
                    float f2 = this.voxelData[n][n2][n3];
                    f += f2 * f2;
                }
            }
        }
        float f3 = this.stepBohr[0] * this.stepBohr[1] * this.stepBohr[2];
        Logger.info((String)("Integrated density = " + (f *= f3)));
    }

    private void createSlaterCube() {
        this.moCoeff = 0;
        for (int i = 0; i < this.slaters.length && this.processSlater(i); ++i) {
        }
    }

    private void createGaussianCube() {
        if (!this.checkCalculationType()) {
            return;
        }
        this.check5D();
        int n = this.shells.size();
        this.moCoeff = 0;
        for (int i = 0; i < n; ++i) {
            this.processShell(i);
            if (!this.doDebug) continue;
            Logger.debug((String)("createGaussianCube shell=" + i + " moCoeff=" + this.moCoeff + "/" + this.moCoefficients.length));
        }
    }

    private void check5D() {
        int n = this.shells.size();
        this.moCoeff = 0;
        this.thisAtom = null;
        for (int i = 0; i < n; ++i) {
            int[] nArray = this.shells.get(i);
            int n2 = nArray[1];
            this.gaussianPtr = nArray[2];
            this.nGaussians = nArray[3];
            this.addData(n2);
        }
        boolean bl = this.as5D = this.moCoeff > this.moCoefficients.length;
        if (this.as5D) {
            Logger.error((String)"MO calculation does not have the proper number of coefficients! Assuming spherical (5D,7F) orbitals");
        }
    }

    private boolean checkCalculationType() {
        if (this.calculationType == null) {
            Logger.warn((String)"calculation type not identified -- continuing");
            return true;
        }
        if (this.calculationType.indexOf("+") >= 0 || this.calculationType.indexOf("*") >= 0) {
            Logger.warn((String)("polarization/diffuse wavefunctions have not been tested fully: " + this.calculationType + " -- continuing"));
        }
        if (this.calculationType.indexOf("?") >= 0) {
            Logger.warn((String)"unknown calculation type may not render correctly -- continuing");
        } else {
            Logger.info((String)("calculation type: " + this.calculationType + " OK."));
        }
        return true;
    }

    private void processShell(int n) {
        int n2 = this.atomIndex;
        int[] nArray = this.shells.get(n);
        this.atomIndex = nArray[0] + this.firstAtomOffset;
        int n3 = nArray[1];
        this.gaussianPtr = nArray[2];
        this.nGaussians = nArray[3];
        if (this.doDebug) {
            Logger.debug((String)("processShell: " + n + " type=" + JmolConstants.getQuantumShellTag((int)n3) + " nGaussians=" + this.nGaussians + " atom=" + this.atomIndex));
        }
        if (this.atomIndex != n2 && (this.thisAtom = this.qmAtoms[this.atomIndex]) != null) {
            this.thisAtom.setXYZ(true);
        }
        this.addData(n3);
    }

    private void addData(int n) {
        switch (n) {
            case 0: {
                this.addDataS();
                break;
            }
            case 1: {
                this.addDataP();
                break;
            }
            case 2: {
                this.addDataSP();
                break;
            }
            case 3: {
                this.addData5D();
                break;
            }
            case 4: {
                if (this.as5D) {
                    this.addData5D();
                    break;
                }
                this.addData6D();
                break;
            }
            case 5: {
                this.addData7F();
                break;
            }
            case 6: {
                if (this.as5D) {
                    this.addData7F();
                    break;
                }
                this.addData10F();
                break;
            }
            default: {
                Logger.warn((String)(" Unsupported basis type for atomno=" + (this.atomIndex + 1) + ": " + n));
            }
        }
    }

    private void setTemp() {
        int n = this.xMax;
        while (--n >= this.xMin) {
            int n2 = this.yMax;
            while (--n2 >= this.yMin) {
                int n3 = this.zMax;
                while (--n3 >= this.zMin) {
                    float f = this.voxelDataTemp[n][n2][n3];
                    float[] fArray = this.voxelData[n][n2];
                    int n4 = n3;
                    fArray[n4] = fArray[n4] + f * f * this.occupancy;
                    this.voxelDataTemp[n][n2][n3] = 0.0f;
                }
            }
        }
    }

    private void addDataS() {
        if (this.thisAtom == null) {
            ++this.moCoeff;
            return;
        }
        if (this.doDebug) {
            this.dumpInfo("S ");
        }
        float f = this.moCoefficients[this.moCoeff++];
        for (int i = 0; i < this.nGaussians; ++i) {
            float f2 = this.gaussians[this.gaussianPtr + i][0];
            float f3 = this.gaussians[this.gaussianPtr + i][1];
            float f4 = f * f3;
            if (this.doNormalize) {
                f4 *= (float)Math.pow(f2, 0.75) * 0.7127055f;
            }
            int n = this.xMax;
            while (--n >= this.xMin) {
                this.EX[n] = f4 * (float)Math.exp(-this.X2[n] * f2);
            }
            n = this.yMax;
            while (--n >= this.yMin) {
                this.EY[n] = (float)Math.exp(-this.Y2[n] * f2);
            }
            n = this.zMax;
            while (--n >= this.zMin) {
                this.EZ[n] = (float)Math.exp(-this.Z2[n] * f2);
            }
            n = this.xMax;
            while (--n >= this.xMin) {
                float f5 = this.EX[n];
                int n2 = this.yMax;
                while (--n2 >= this.yMin) {
                    float f6 = f5 * this.EY[n2];
                    int n3 = this.zMax;
                    while (--n3 >= this.zMin) {
                        float[] fArray = this.voxelDataTemp[n][n2];
                        int n4 = n3;
                        fArray[n4] = fArray[n4] + f6 * this.EZ[n3];
                    }
                }
            }
        }
        if (this.isElectronDensity) {
            this.setTemp();
        }
    }

    private void addDataP() {
        if (this.thisAtom == null) {
            this.moCoeff += 3;
            return;
        }
        if (this.doDebug) {
            this.dumpInfo("X Y Z ");
        }
        float f = this.moCoefficients[this.moCoeff++];
        float f2 = this.moCoefficients[this.moCoeff++];
        float f3 = this.moCoefficients[this.moCoeff++];
        if (this.isElectronDensity) {
            float f4;
            float f5;
            float f6;
            int n;
            for (n = 0; n < this.nGaussians; ++n) {
                f6 = this.gaussians[this.gaussianPtr + n][0];
                f4 = f5 = this.gaussians[this.gaussianPtr + n][1];
                if (this.doNormalize) {
                    f4 *= (float)Math.pow(f6, 1.25) * 1.425411f;
                }
                this.calcSP(f6, 0.0f, f4 * f, 0.0f, 0.0f);
            }
            this.setTemp();
            for (n = 0; n < this.nGaussians; ++n) {
                f6 = this.gaussians[this.gaussianPtr + n][0];
                f4 = f5 = this.gaussians[this.gaussianPtr + n][1];
                if (this.doNormalize) {
                    f4 *= (float)Math.pow(f6, 1.25) * 1.425411f;
                }
                this.calcSP(f6, 0.0f, 0.0f, f4 * f2, 0.0f);
            }
            this.setTemp();
            for (n = 0; n < this.nGaussians; ++n) {
                f6 = this.gaussians[this.gaussianPtr + n][0];
                f4 = f5 = this.gaussians[this.gaussianPtr + n][1];
                if (this.doNormalize) {
                    f4 *= (float)Math.pow(f6, 1.25) * 1.425411f;
                }
                this.calcSP(f6, 0.0f, 0.0f, 0.0f, f4 * f3);
            }
            this.setTemp();
        } else {
            for (int i = 0; i < this.nGaussians; ++i) {
                float f7;
                float f8 = this.gaussians[this.gaussianPtr + i][0];
                float f9 = f7 = this.gaussians[this.gaussianPtr + i][1];
                if (this.doNormalize) {
                    f9 *= (float)Math.pow(f8, 1.25) * 1.425411f;
                }
                this.calcSP(f8, 0.0f, f9 * f, f9 * f2, f9 * f3);
            }
        }
    }

    private void addDataSP() {
        float f = this.gaussians[this.gaussianPtr][1];
        if (this.thisAtom == null) {
            this.moCoeff += f == 0.0f ? 3 : 4;
            return;
        }
        if (this.doDebug) {
            this.dumpInfo(f == 0.0f ? "X Y Z " : "S X Y Z ");
        }
        float f2 = f == 0.0f ? 0.0f : this.moCoefficients[this.moCoeff++];
        float f3 = this.moCoefficients[this.moCoeff++];
        float f4 = this.moCoefficients[this.moCoeff++];
        float f5 = this.moCoefficients[this.moCoeff++];
        if (this.isElectronDensity) {
            float f6;
            float f7;
            float f8;
            int n;
            for (n = 0; n < this.nGaussians; ++n) {
                f8 = this.gaussians[this.gaussianPtr + n][0];
                f7 = f = this.gaussians[this.gaussianPtr + n][1];
                if (this.doNormalize) {
                    f7 *= (float)Math.pow(f8, 0.75) * 0.7127055f;
                }
                this.calcSP(f8, f7 * f2, 0.0f, 0.0f, 0.0f);
            }
            this.setTemp();
            for (n = 0; n < this.nGaussians; ++n) {
                f8 = this.gaussians[this.gaussianPtr + n][0];
                f6 = f7 = this.gaussians[this.gaussianPtr + n][2];
                if (this.doNormalize) {
                    f6 *= (float)Math.pow(f8, 1.25) * 1.425411f;
                }
                this.calcSP(f8, 0.0f, f6 * f3, 0.0f, 0.0f);
            }
            this.setTemp();
            for (n = 0; n < this.nGaussians; ++n) {
                f8 = this.gaussians[this.gaussianPtr + n][0];
                f6 = f7 = this.gaussians[this.gaussianPtr + n][2];
                if (this.doNormalize) {
                    f6 *= (float)Math.pow(f8, 1.25) * 1.425411f;
                }
                this.calcSP(f8, 0.0f, 0.0f, f6 * f4, 0.0f);
            }
            this.setTemp();
            for (n = 0; n < this.nGaussians; ++n) {
                f8 = this.gaussians[this.gaussianPtr + n][0];
                f6 = f7 = this.gaussians[this.gaussianPtr + n][2];
                if (this.doNormalize) {
                    f6 *= (float)Math.pow(f8, 1.25) * 1.425411f;
                }
                this.calcSP(f8, 0.0f, 0.0f, 0.0f, f6 * f5);
            }
            this.setTemp();
        } else {
            for (int i = 0; i < this.nGaussians; ++i) {
                float f9 = this.gaussians[this.gaussianPtr + i][0];
                f = this.gaussians[this.gaussianPtr + i][1];
                float f10 = this.gaussians[this.gaussianPtr + i][2];
                float f11 = f;
                if (this.doNormalize) {
                    f11 *= (float)Math.pow(f9, 0.75) * 0.7127055f;
                }
                float f12 = f10;
                if (this.doNormalize) {
                    f12 *= (float)Math.pow(f9, 1.25) * 1.425411f;
                }
                this.calcSP(f9, f11 * f2, f12 * f3, f12 * f4, f12 * f5);
            }
        }
    }

    private void setCE(float[] fArray, float[] fArray2, float f, float f2, float f3, float f4, float f5) {
        int n = this.xMax;
        while (--n >= this.xMin) {
            fArray[n] = f2 + f3 * this.X[n];
            fArray2[n] = (float)Math.exp(-this.X2[n] * f);
        }
        n = this.yMax;
        while (--n >= this.yMin) {
            this.CY[n] = f4 * this.Y[n];
            this.EY[n] = (float)Math.exp(-this.Y2[n] * f);
        }
        n = this.zMax;
        while (--n >= this.zMin) {
            this.CZ[n] = f5 * this.Z[n];
            this.EZ[n] = (float)Math.exp(-this.Z2[n] * f);
        }
    }

    private void setE(float[] fArray, float f) {
        int n = this.xMax;
        while (--n >= this.xMin) {
            fArray[n] = (float)Math.exp(-this.X2[n] * f);
        }
        n = this.yMax;
        while (--n >= this.yMin) {
            this.EY[n] = (float)Math.exp(-this.Y2[n] * f);
        }
        n = this.zMax;
        while (--n >= this.zMin) {
            this.EZ[n] = (float)Math.exp(-this.Z2[n] * f);
        }
    }

    private void calcSP(float f, float f2, float f3, float f4, float f5) {
        this.setCE(this.CX, this.EX, f, f2, f3, f4, f5);
        int n = this.xMax;
        while (--n >= this.xMin) {
            float f6 = this.EX[n];
            float f7 = this.CX[n];
            int n2 = this.yMax;
            while (--n2 >= this.yMin) {
                float f8 = f6 * this.EY[n2];
                float f9 = f7 + this.CY[n2];
                int n3 = this.zMax;
                while (--n3 >= this.zMin) {
                    float[] fArray = this.voxelDataTemp[n][n2];
                    int n4 = n3;
                    fArray[n4] = fArray[n4] + (f9 + this.CZ[n3]) * f8 * this.EZ[n3];
                }
            }
        }
    }

    private void addData6D() {
        int[] nArray = this.dfCoefMaps[4];
        if (this.thisAtom == null || this.isElectronDensity || nArray[0] == Integer.MIN_VALUE) {
            this.moCoeff += 6;
            return;
        }
        if (this.doDebug) {
            this.dumpInfo(4, nArray);
        }
        float f = this.moCoefficients[nArray[0] + this.moCoeff++];
        float f2 = this.moCoefficients[nArray[1] + this.moCoeff++];
        float f3 = this.moCoefficients[nArray[2] + this.moCoeff++];
        float f4 = this.moCoefficients[nArray[3] + this.moCoeff++];
        float f5 = this.moCoefficients[nArray[4] + this.moCoeff++];
        float f6 = this.moCoefficients[nArray[5] + this.moCoeff++];
        for (int i = 0; i < this.nGaussians; ++i) {
            float f7;
            float f8 = this.gaussians[this.gaussianPtr + i][0];
            float f9 = f7 = this.gaussians[this.gaussianPtr + i][1];
            if (this.doNormalize) {
                f9 *= (float)Math.pow(f8, 1.75) * 2.850822f;
            }
            float f10 = f9 / 1.7320508f * f;
            float f11 = f9 / 1.7320508f * f2;
            float f12 = f9 / 1.7320508f * f3;
            float f13 = f9 * f4;
            float f14 = f9 * f5;
            float f15 = f9 * f6;
            this.setCE(this.CX, this.EX, f8, 0.0f, f10, f11, f12);
            int n = this.xMax;
            while (--n >= this.xMin) {
                this.DXY[n] = f13 * this.X[n];
                this.DXZ[n] = f14 * this.X[n];
            }
            n = this.yMax;
            while (--n >= this.yMin) {
                this.DYZ[n] = f15 * this.Y[n];
            }
            n = this.xMax;
            while (--n >= this.xMin) {
                float f16 = this.CX[n] * this.X[n];
                float f17 = this.DXY[n];
                float f18 = this.DXZ[n];
                float f19 = this.EX[n];
                int n2 = this.yMax;
                while (--n2 >= this.yMin) {
                    float f20 = f16 + (this.CY[n2] + f17) * this.Y[n2];
                    float f21 = f18 + this.DYZ[n2];
                    float f22 = f19 * this.EY[n2];
                    int n3 = this.zMax;
                    while (--n3 >= this.zMin) {
                        float[] fArray = this.voxelDataTemp[n][n2];
                        int n4 = n3;
                        fArray[n4] = fArray[n4] + (f20 + (this.CZ[n3] + f21) * this.Z[n3]) * f22 * this.EZ[n3];
                    }
                }
            }
        }
    }

    private void addData5D() {
        int[] nArray = this.dfCoefMaps[3];
        if (this.thisAtom == null || this.isElectronDensity || nArray[0] == Integer.MIN_VALUE) {
            this.moCoeff += 5;
            return;
        }
        if (this.doDebug) {
            this.dumpInfo(3, nArray);
        }
        float f = this.doNormalize ? (float)Math.pow(66.05114251919257, 0.25) : 1.0f;
        float f2 = this.doNormalize ? (float)((double)f / Math.sqrt(3.0)) : 1.0f;
        float f3 = this.doNormalize ? (float)Math.sqrt(0.75) : 1.0f;
        float f4 = this.moCoefficients[nArray[0] + this.moCoeff++];
        float f5 = this.moCoefficients[nArray[1] + this.moCoeff++];
        float f6 = this.moCoefficients[nArray[2] + this.moCoeff++];
        float f7 = this.moCoefficients[nArray[3] + this.moCoeff++];
        float f8 = this.moCoefficients[nArray[4] + this.moCoeff++];
        for (int i = 0; i < this.nGaussians; ++i) {
            float f9;
            float f10 = this.gaussians[this.gaussianPtr + i][0];
            float f11 = f9 = this.gaussians[this.gaussianPtr + i][1];
            if (this.doNormalize) {
                f11 *= (float)Math.pow(f10, 1.75);
            }
            float f12 = f11 * f4;
            float f13 = f11 * f5;
            float f14 = f11 * f6;
            float f15 = f11 * f7;
            float f16 = f11 * f8;
            this.setE(this.EX, f10);
            int n = this.xMax;
            while (--n >= this.xMin) {
                float f17 = this.X[n];
                float f18 = this.EX[n];
                float f19 = f2 * f17 * f17;
                int n2 = this.yMax;
                while (--n2 >= this.yMin) {
                    float f20 = this.Y[n2];
                    float f21 = f18 * this.EY[n2];
                    float f22 = f2 * f20 * f20;
                    float f23 = f * f17 * f20;
                    int n3 = this.zMax;
                    while (--n3 >= this.zMin) {
                        float f24 = this.Z[n3];
                        float f25 = f2 * f24 * f24;
                        float f26 = f * f17 * f24;
                        float f27 = f * f20 * f24;
                        float[] fArray = this.voxelDataTemp[n][n2];
                        int n4 = n3;
                        fArray[n4] = fArray[n4] + (f12 * (f25 - 0.5f * (f19 + f22)) + f13 * f26 + f14 * f27 + f15 * f3 * (f19 - f22) + f16 * f23) * f21 * this.EZ[n3];
                    }
                }
            }
        }
    }

    private void addData10F() {
        int[] nArray = this.dfCoefMaps[6];
        if (this.thisAtom == null || this.isElectronDensity || nArray[0] == Integer.MIN_VALUE) {
            this.moCoeff += 10;
            return;
        }
        if (this.doDebug) {
            this.dumpInfo(6, nArray);
        }
        float f = this.doNormalize ? (float)Math.pow(1056.818280307081, 0.25) : 1.0f;
        float f2 = this.doNormalize ? (float)((double)f / Math.sqrt(3.0)) : 1.0f;
        float f3 = this.doNormalize ? (float)((double)f / Math.sqrt(15.0)) : 1.0f;
        float f4 = this.moCoefficients[nArray[0] + this.moCoeff++];
        float f5 = this.moCoefficients[nArray[1] + this.moCoeff++];
        float f6 = this.moCoefficients[nArray[2] + this.moCoeff++];
        float f7 = this.moCoefficients[nArray[3] + this.moCoeff++];
        float f8 = this.moCoefficients[nArray[4] + this.moCoeff++];
        float f9 = this.moCoefficients[nArray[5] + this.moCoeff++];
        float f10 = this.moCoefficients[nArray[6] + this.moCoeff++];
        float f11 = this.moCoefficients[nArray[7] + this.moCoeff++];
        float f12 = this.moCoefficients[nArray[8] + this.moCoeff++];
        float f13 = this.moCoefficients[nArray[9] + this.moCoeff++];
        for (int i = 0; i < this.nGaussians; ++i) {
            float f14 = this.gaussians[this.gaussianPtr + i][0];
            float f15 = this.gaussians[this.gaussianPtr + i][1];
            this.setE(this.EX, f14);
            float f16 = f15;
            if (this.doNormalize) {
                f16 *= (float)Math.pow(f14, 2.25);
            }
            float f17 = f16 * f3 * f4;
            float f18 = f16 * f3 * f5;
            float f19 = f16 * f3 * f6;
            float f20 = f16 * f2 * f7;
            float f21 = f16 * f2 * f8;
            float f22 = f16 * f2 * f9;
            float f23 = f16 * f2 * f10;
            float f24 = f16 * f2 * f11;
            float f25 = f16 * f2 * f12;
            float f26 = f16 * f * f13;
            int n = this.xMax;
            while (--n >= this.xMin) {
                float f27 = this.X[n];
                float f28 = f27 * f27;
                float f29 = this.EX[n];
                float f30 = f17 * f28 * f27;
                int n2 = this.yMax;
                while (--n2 >= this.yMin) {
                    float f31 = this.Y[n2];
                    float f32 = f31 * f31;
                    float f33 = f29 * this.EY[n2];
                    float f34 = f18 * f32 * f31;
                    float f35 = f21 * f28 * f31;
                    float f36 = f20 * f27 * f32;
                    int n3 = this.zMax;
                    while (--n3 >= this.zMin) {
                        float f37 = this.Z[n3];
                        float f38 = f37 * f37;
                        float f39 = f19 * f38 * f37;
                        float f40 = f22 * f28 * f37;
                        float f41 = f23 * f27 * f38;
                        float f42 = f25 * f32 * f37;
                        float f43 = f24 * f31 * f38;
                        float f44 = f26 * f27 * f31 * f37;
                        float[] fArray = this.voxelDataTemp[n][n2];
                        int n4 = n3;
                        fArray[n4] = fArray[n4] + (f30 + f34 + f39 + f36 + f35 + f40 + f41 + f43 + f42 + f44) * f33 * this.EZ[n3];
                    }
                }
            }
        }
    }

    private void addData7F() {
        int[] nArray = this.dfCoefMaps[5];
        if (this.thisAtom == null || this.isElectronDensity || nArray[0] == Integer.MIN_VALUE) {
            this.moCoeff += 7;
            return;
        }
        if (this.doDebug) {
            this.dumpInfo(5, nArray);
        }
        float f = this.doNormalize ? (float)Math.pow(1056.818280307081, 0.25) : 1.0f;
        float f2 = this.doNormalize ? (float)((double)f / Math.sqrt(3.0)) : 1.0f;
        float f3 = this.doNormalize ? (float)((double)f / Math.sqrt(15.0)) : 1.0f;
        float f4 = (float)(3.0 / (2.0 * Math.sqrt(5.0)));
        float f5 = (float)Math.sqrt(1.2);
        float f6 = (float)Math.sqrt(0.375);
        float f7 = (float)Math.sqrt(0.075);
        float f8 = f5;
        float f9 = f6;
        float f10 = f7;
        float f11 = (float)Math.sqrt(0.75);
        float f12 = (float)Math.sqrt(0.625);
        float f13 = 0.75f * (float)Math.sqrt(2.0);
        float f14 = f12;
        float f15 = f13;
        float f16 = this.moCoefficients[nArray[0] + this.moCoeff++];
        float f17 = this.moCoefficients[nArray[1] + this.moCoeff++];
        float f18 = this.moCoefficients[nArray[2] + this.moCoeff++];
        float f19 = this.moCoefficients[nArray[3] + this.moCoeff++];
        float f20 = this.moCoefficients[nArray[4] + this.moCoeff++];
        float f21 = this.moCoefficients[nArray[5] + this.moCoeff++];
        float f22 = this.moCoefficients[nArray[6] + this.moCoeff++];
        for (int i = 0; i < this.nGaussians; ++i) {
            float f23;
            float f24 = this.gaussians[this.gaussianPtr + i][0];
            float f25 = f23 = this.gaussians[this.gaussianPtr + i][1];
            if (this.doNormalize) {
                f25 *= (float)Math.pow(f24, 2.25);
            }
            float f26 = f25 * f16;
            float f27 = f25 * f17;
            float f28 = f25 * f18;
            float f29 = f25 * f19;
            float f30 = f25 * f20;
            float f31 = f25 * f21;
            float f32 = f25 * f22;
            this.setE(this.EX, f24);
            int n = this.xMax;
            while (--n >= this.xMin) {
                float f33 = this.X[n];
                float f34 = f33 * f33;
                float f35 = this.EX[n];
                float f36 = f3 * f33 * f34;
                int n2 = this.yMax;
                while (--n2 >= this.yMin) {
                    float f37 = this.Y[n2];
                    float f38 = f37 * f37;
                    float f39 = f35 * this.EY[n2];
                    float f40 = f3 * f37 * f38;
                    float f41 = f2 * f33 * f38;
                    float f42 = f2 * f34 * f37;
                    int n3 = this.zMax;
                    while (--n3 >= this.zMin) {
                        float f43 = this.Z[n3];
                        float f44 = f43 * f43;
                        float f45 = f3 * f43 * f44;
                        float f46 = f2 * f34 * f43;
                        float f47 = f2 * f33 * f44;
                        float f48 = f2 * f38 * f43;
                        float f49 = f2 * f37 * f44;
                        float f50 = f * f33 * f37 * f43;
                        float f51 = f26 * (f45 - f4 * (f46 + f48));
                        float f52 = f27 * (f5 * f47 - f6 * f36 - f7 * f41);
                        float f53 = f28 * (f8 * f49 - f9 * f40 - f10 * f42);
                        float f54 = f29 * (f11 * (f46 - f48));
                        float f55 = f30 * f50;
                        float f56 = f31 * (f12 * f36 - f13 * f41);
                        float f57 = f32 * (-f14 * f40 + f15 * f42);
                        float[] fArray = this.voxelDataTemp[n][n2];
                        int n4 = n3;
                        fArray[n4] = fArray[n4] + (f51 + f52 + f53 + f54 + f55 + f56 + f57) * f39 * this.EZ[n3];
                    }
                }
            }
        }
    }

    private boolean processSlater(int n) {
        double d;
        int n2 = this.atomIndex;
        SlaterData slaterData = this.slaters[n];
        this.atomIndex = slaterData.iAtom;
        double d2 = -slaterData.zeta;
        this.thisAtom = this.qmAtoms[this.atomIndex];
        if (this.thisAtom == null) {
            if (d2 <= 0.0) {
                ++this.moCoeff;
            }
            return true;
        }
        if (d2 > 0.0) {
            d2 = -d2;
            --this.moCoeff;
        }
        if (this.moCoeff >= this.moCoefficients.length) {
            return false;
        }
        if ((d = slaterData.coef * (double)this.moCoefficients[this.moCoeff++]) == 0.0) {
            this.atomIndex = -1;
            return true;
        }
        if (this.atomIndex != n2) {
            this.thisAtom.setXYZ(true);
        }
        int n3 = slaterData.x;
        int n4 = slaterData.y;
        int n5 = slaterData.z;
        int n6 = slaterData.r;
        if (n3 == -2) {
            int n7 = this.xMax;
            while (--n7 >= this.xMin) {
                double d3 = this.X2[n7];
                int n8 = this.yMax;
                while (--n8 >= this.yMin) {
                    double d4 = this.Y2[n8];
                    double d5 = d3 + d4;
                    int n9 = this.zMax;
                    while (--n9 >= this.zMin) {
                        double d6 = this.Z2[n9];
                        double d7 = d5 + d6;
                        double d8 = Math.sqrt(d7);
                        double d9 = d2 * d8;
                        if (d9 < -50.0) continue;
                        double d10 = d * Math.exp(d9) * (3.0 * d6 - d7);
                        switch (n6) {
                            case 3: {
                                d10 *= d8;
                            }
                            case 2: {
                                d10 *= d7;
                                break;
                            }
                            case 1: {
                                d10 *= d8;
                            }
                        }
                        float[] fArray = this.voxelDataTemp[n7][n8];
                        int n10 = n9;
                        fArray[n10] = (float)((double)fArray[n10] + d10);
                    }
                }
            }
        } else if (n4 == -2) {
            int n11 = this.xMax;
            while (--n11 >= this.xMin) {
                double d11 = this.X2[n11];
                int n12 = this.yMax;
                while (--n12 >= this.yMin) {
                    double d12 = this.Y2[n12];
                    double d13 = d11 + d12;
                    double d14 = d * (d11 - d12);
                    int n13 = this.zMax;
                    while (--n13 >= this.zMin) {
                        double d15 = this.Z2[n13];
                        double d16 = d13 + d15;
                        double d17 = Math.sqrt(d16);
                        double d18 = d2 * d17;
                        if (d18 < -50.0) continue;
                        double d19 = d14 * Math.exp(d18);
                        switch (n6) {
                            case 3: {
                                d19 *= d17;
                            }
                            case 2: {
                                d19 *= d16;
                                break;
                            }
                            case 1: {
                                d19 *= d17;
                            }
                        }
                        float[] fArray = this.voxelDataTemp[n11][n12];
                        int n14 = n13;
                        fArray[n14] = (float)((double)fArray[n14] + d19);
                    }
                }
            }
        } else {
            int n15 = this.xMax;
            while (--n15 >= this.xMin) {
                double d20 = this.X2[n15];
                double d21 = d;
                switch (n3) {
                    case 3: {
                        d21 *= (double)this.X[n15];
                    }
                    case 2: {
                        d21 *= d20;
                        break;
                    }
                    case 1: {
                        d21 *= (double)this.X[n15];
                    }
                }
                int n16 = this.yMax;
                while (--n16 >= this.yMin) {
                    double d22 = this.Y2[n16];
                    double d23 = d20 + d22;
                    double d24 = d21;
                    switch (n4) {
                        case 3: {
                            d24 *= (double)this.Y[n16];
                        }
                        case 2: {
                            d24 *= d22;
                            break;
                        }
                        case 1: {
                            d24 *= (double)this.Y[n16];
                        }
                    }
                    int n17 = this.zMax;
                    while (--n17 >= this.zMin) {
                        double d25 = this.Z2[n17];
                        double d26 = d23 + d25;
                        double d27 = Math.sqrt(d26);
                        double d28 = d2 * d27;
                        if (d28 < -50.0) continue;
                        double d29 = d24 * Math.exp(d28);
                        switch (n5) {
                            case 3: {
                                d29 *= (double)this.Z[n17];
                            }
                            case 2: {
                                d29 *= d25;
                                break;
                            }
                            case 1: {
                                d29 *= (double)this.Z[n17];
                            }
                        }
                        switch (n6) {
                            case 3: {
                                d29 *= d27;
                            }
                            case 2: {
                                d29 *= d26;
                                break;
                            }
                            case 1: {
                                d29 *= d27;
                            }
                        }
                        float[] fArray = this.voxelDataTemp[n15][n16];
                        int n18 = n17;
                        fArray[n18] = (float)((double)fArray[n18] + d29);
                    }
                }
            }
        }
        if (this.isElectronDensity) {
            this.setTemp();
        }
        return true;
    }

    private void dumpInfo(String string) {
        int n;
        for (n = 0; n < this.nGaussians; ++n) {
            float f = this.gaussians[this.gaussianPtr + n][0];
            float f2 = this.gaussians[this.gaussianPtr + n][1];
            if (!Logger.debugging) continue;
            Logger.debug((String)("Gaussian " + (n + 1) + " alpha=" + f + " c=" + f2));
        }
        n = string.length() / 2;
        if (Logger.debugging) {
            for (int i = 0; i < n; ++i) {
                Logger.debug((String)("MO coeff " + string.substring(2 * i, 2 * i + 2) + " " + (this.moCoeff + i + 1) + " " + this.moCoefficients[this.moCoeff + i]));
            }
        }
    }

    private void dumpInfo(int n, int[] nArray) {
        for (int i = 0; i < this.nGaussians; ++i) {
            float f = this.gaussians[this.gaussianPtr + i][0];
            float f2 = this.gaussians[this.gaussianPtr + i][1];
            Logger.debug((String)("Gaussian " + (i + 1) + " alpha=" + f + " c=" + f2));
        }
        if (n >= 0 && Logger.debugging) {
            String[] stringArray = JmolConstants.getShellOrder((int)n);
            for (int i = 0; i < stringArray.length; ++i) {
                Logger.debug((String)("MO coeff " + (stringArray == null ? "?" + i : stringArray[i]) + " " + (nArray[i] + this.moCoeff + i + 1) + " " + this.moCoefficients[nArray[i] + this.moCoeff + i]));
            }
        }
    }
}

