/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Quaternion;
import org.jmol.util.TextFormat;

public class CrystalReader
extends AtomSetCollectionReader {
    private boolean isVersion3;
    private boolean isPrimitive;
    private boolean isPolymer;
    private boolean isSlab;
    private boolean isMolecular;
    private boolean haveCharges;
    private boolean addVibrations;
    private boolean isFreqCalc;
    private boolean inputOnly;
    private int atomCount;
    private int[] atomFrag;
    private boolean getLastConventional;
    Vector3f[] directLatticeVectors;
    Matrix3f primitiveToCryst;
    private Point3f ptOriginShift = new Point3f();
    private boolean havePrimitiveMapping;
    private int[] primitiveToIndex;
    int atomIndexLast;
    private List<String> vInputCoords;
    private Double energy;
    private float[] nuclearCharges;
    private float[] frequencies;
    private String[] data;

    protected void initializeReader() throws Exception {
        this.doProcessLines = false;
        if (this.filter != null) {
            this.filter = this.filter.toLowerCase();
        }
        this.inputOnly = this.filter != null && this.filter.indexOf("input") >= 0;
        this.addVibrations = !this.inputOnly && (this.filter == null || this.filter.indexOf("novib") < 0);
        this.isPrimitive = !this.inputOnly && (this.filter == null || this.filter.indexOf("conv") < 0);
        this.getLastConventional = !this.isPrimitive && this.desiredModelNumber == 0;
        this.setFractionalCoordinates(this.readHeader());
    }

    protected boolean checkLine() throws Exception {
        if (this.line.startsWith(" LATTICE PARAMETER")) {
            boolean bl;
            boolean bl2 = bl = this.line.indexOf("- CONVENTIONAL") >= 0;
            if (bl) {
                if (this.isPrimitive) {
                    return true;
                }
                this.readCellParams(true);
            } else if (!this.isPrimitive && !this.havePrimitiveMapping && !this.getLastConventional && this.readPrimitiveMapping()) {
                return true;
            }
            if (this.isPrimitive) {
                this.readCellParams(true);
            } else {
                this.readCellParams(true);
                this.discardLinesUntilContains(" TRANSFORMATION");
                this.readTransformationMatrix();
                this.discardLinesUntilContains(" CRYSTALLOGRAPHIC");
                this.readCellParams(false);
                this.discardLinesUntilContains(" CRYSTALLOGRAPHIC");
                this.readCrystallographicCoords();
                if (this.modelNumber == 1 || !this.isFreqCalc) {
                    // empty if block
                }
                if (!this.getLastConventional) {
                    if (!this.doGetModel(++this.modelNumber)) {
                        this.vInputCoords = null;
                        this.checkLastModel();
                    }
                    this.processInputCoords();
                }
            }
            return true;
        }
        if (this.isPrimitive) {
            if (this.line.indexOf("VOLUME=") >= 0 && this.line.indexOf("- DENSITY") >= 0) {
                return this.readVolumePrimCell();
            }
        } else {
            if (this.line.startsWith(" SHIFT OF THE ORIGIN")) {
                return this.readShift();
            }
            if (this.line.startsWith(" INPUT COORDINATES")) {
                this.readCrystallographicCoords();
                if (this.inputOnly) {
                    this.continuing = false;
                }
                return true;
            }
        }
        if (this.line.startsWith(" DIRECT LATTICE VECTORS CARTESIAN COMPONENTS (ANGSTROM)")) {
            return this.setDirect();
        }
        if (this.line.indexOf("DIMENSIONALITY OF THE SYSTEM") >= 0) {
            if (this.line.indexOf("2") >= 0) {
                this.isSlab = true;
            }
            if (this.line.indexOf("1") >= 0) {
                this.isPolymer = true;
            }
            return true;
        }
        if (this.line.indexOf("FRQFRQ") >= 0) {
            this.isFreqCalc = true;
            return true;
        }
        if (this.line.indexOf("CONSTRUCTION OF A NANOTUBE FROM A SLAB") >= 0) {
            this.isPolymer = true;
            this.isSlab = false;
            return true;
        }
        if (this.isPrimitive && this.line.startsWith(" ATOMS IN THE ASYMMETRIC UNIT")) {
            if (!this.doGetModel(++this.modelNumber)) {
                return this.checkLastModel();
            }
            return this.readFractionalCoords();
        }
        if (!this.doProcessLines) {
            return true;
        }
        if (this.line.startsWith(" TOTAL ENERGY")) {
            this.readEnergy();
            this.readLine();
            if (this.line.startsWith(" ********")) {
                this.discardLinesUntilContains("SYMMETRY ALLOWED");
            }
            if (this.line.startsWith(" TTTTTTTT")) {
                this.discardLinesUntilContains("PREDICTED ENERGY CHANGE");
            }
            return true;
        }
        if (this.line.startsWith(" TYPE OF CALCULATION")) {
            this.calculationType = this.line.substring(this.line.indexOf(":") + 1).trim();
            return true;
        }
        if (this.line.startsWith(" MULLIKEN POPULATION ANALYSIS")) {
            return this.readPartialCharges();
        }
        if (this.line.startsWith(" TOTAL ATOMIC CHARGES")) {
            return this.readTotalAtomicCharges();
        }
        if (this.line.startsWith(" FREQUENCIES COMPUTED ON A FRAGMENT")) {
            return this.readFragments();
        }
        if (this.addVibrations && this.line.indexOf("* CALCULATION OF PHONON FREQUENCIES AT THE GAMMA POINT.") >= 0) {
            if (this.vInputCoords != null) {
                this.processInputCoords();
            }
            return this.readFrequencies();
        }
        if (this.line.startsWith(" MAX GRADIENT")) {
            return this.readGradient();
        }
        if (this.line.startsWith(" ATOMIC SPINS SET")) {
            return this.readSpins();
        }
        if (this.line.startsWith(" TOTAL ATOMIC SPINS  :")) {
            return this.readMagneticMoments();
        }
        return true;
    }

    private boolean setDirect() throws Exception {
        this.readLine();
        this.directLatticeVectors = new Vector3f[3];
        this.directLatticeVectors[0] = this.getPoint3f(null, 0);
        this.directLatticeVectors[1] = this.getPoint3f(null, 0);
        this.directLatticeVectors[2] = this.getPoint3f(null, 0);
        if (Logger.debugging) {
            this.addJmolScript("draw va vector {0 0 0} " + Escape.escape((Tuple3f)this.directLatticeVectors[0]) + " color red");
            if (!this.isPolymer) {
                this.addJmolScript("draw vb vector {0 0 0} " + Escape.escape((Tuple3f)this.directLatticeVectors[1]) + " color green");
                if (!this.isSlab) {
                    this.addJmolScript("draw vc vector {0 0 0} " + Escape.escape((Tuple3f)this.directLatticeVectors[2]) + " color blue");
                }
            }
        }
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        if (this.isPrimitive) {
            vector3f = this.directLatticeVectors[0];
            vector3f2 = this.directLatticeVectors[1];
        } else {
            if (this.primitiveToCryst == null) {
                return true;
            }
            Matrix3f matrix3f = new Matrix3f();
            matrix3f.setColumn(0, this.directLatticeVectors[0]);
            matrix3f.setColumn(1, this.directLatticeVectors[1]);
            matrix3f.setColumn(2, this.directLatticeVectors[2]);
            matrix3f.mul(this.primitiveToCryst);
            vector3f = new Vector3f();
            vector3f2 = new Vector3f();
            matrix3f.getColumn(0, vector3f);
            matrix3f.getColumn(1, vector3f2);
        }
        this.matUnitCellOrientation = Quaternion.getQuaternionFrame((Point3f)new Point3f(), (Tuple3f)vector3f, (Tuple3f)vector3f2).getMatrix();
        Logger.info((String)("oriented unit cell is in model " + this.atomSetCollection.getAtomSetCount()));
        return true;
    }

    private Vector3f getPoint3f(float[] fArray, int n) throws Exception {
        if (fArray == null) {
            fArray = new float[3];
            this.fillFloatArray(fArray);
            return new Vector3f(fArray[0], fArray[1], fArray[2]);
        }
        return new Vector3f(fArray[n++], fArray[n++], fArray[n]);
    }

    private void readTransformationMatrix() throws Exception {
        float[] fArray = new float[9];
        this.fillFloatArray(fArray);
        this.primitiveToCryst = new Matrix3f(fArray);
    }

    private boolean readShift() {
        String[] stringArray = this.getTokens();
        int n = stringArray.length - 3;
        this.ptOriginShift.set(this.fraction(stringArray[n++]), this.fraction(stringArray[n++]), this.fraction(stringArray[n]));
        return true;
    }

    private float fraction(String string) {
        String[] stringArray = TextFormat.split((String)string, (char)'/');
        return stringArray.length == 2 ? this.parseFloat(stringArray[0]) / this.parseFloat(stringArray[1]) : 0.0f;
    }

    private boolean readGradient() throws Exception {
        String string = null;
        while (this.line != null) {
            String[] stringArray = this.getTokens();
            if (this.line.indexOf("MAX GRAD") >= 0) {
                string = "maxGradient";
            } else if (this.line.indexOf("RMS GRAD") >= 0) {
                string = "rmsGradient";
            } else if (this.line.indexOf("MAX DISP") >= 0) {
                string = "maxDisplacement";
            } else {
                if (this.line.indexOf("RMS DISP") < 0) break;
                string = "rmsDisplacement";
            }
            if (this.atomSetCollection.getAtomCount() > 0) {
                this.atomSetCollection.setAtomSetAuxiliaryProperty(string, stringArray[2]);
            }
            this.readLine();
        }
        return true;
    }

    private boolean readVolumePrimCell() {
        String[] stringArray = CrystalReader.getTokens((String)this.line);
        String string = stringArray[7];
        if (stringArray[9].length() > 7) {
            this.line = TextFormat.simpleReplace((String)this.line, (String)"DENSITY", (String)"DENSITY ");
        }
        String string2 = stringArray[10];
        this.atomSetCollection.setAtomSetAuxiliaryProperty("volumePrimitive", TextFormat.formatDecimal((float)this.parseFloat(string), (int)3));
        this.atomSetCollection.setAtomSetAuxiliaryProperty("densityPrimitive", TextFormat.formatDecimal((float)this.parseFloat(string2), (int)3));
        return true;
    }

    private boolean readSpins() throws Exception {
        String string = "";
        while (this.readLine() != null && this.line.indexOf("ALPHA") < 0) {
            string = string + this.line;
        }
        string = TextFormat.simpleReplace((String)string, (String)"-", (String)" -");
        this.setData("spin", string, 2, 3);
        return true;
    }

    private boolean readMagneticMoments() throws Exception {
        String string = "";
        while (this.readLine() != null && this.line.indexOf("TTTTTT") < 0) {
            string = string + this.line;
        }
        this.setData("magneticMoment", string, 0, 1);
        return true;
    }

    private void setData(String string, String string2, int n, int n2) throws Exception {
        if (this.vInputCoords != null) {
            this.processInputCoords();
        }
        String[] stringArray = new String[this.atomCount];
        String[] stringArray2 = CrystalReader.getTokens((String)string2);
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.atomCount) {
            int n5 = this.getAtomIndexFromPrimitiveIndex(n3);
            if (n5 >= 0) {
                stringArray[n4++] = stringArray2[n];
            }
            ++n3;
            n += n2;
        }
        string2 = TextFormat.join((String[])stringArray, (char)'\n', (int)0);
        this.atomSetCollection.setAtomSetAuxiliaryProperty(string, string2);
    }

    protected void finalizeReader() throws Exception {
        if (this.vInputCoords != null) {
            this.processInputCoords();
        }
        if (this.energy != null) {
            this.setEnergy();
        }
        super.finalizeReader();
    }

    private boolean readHeader() throws Exception {
        this.discardLinesUntilContains("*                                CRYSTAL");
        this.isVersion3 = this.line.indexOf("CRYSTAL03") >= 0;
        this.discardLinesUntilContains("EEEEEEEEEE");
        this.atomSetCollection.setCollectionName(this.readLine().trim() + (this.desiredModelNumber == 0 ? " (optimized)" : ""));
        this.readLine();
        String string = this.readLine().trim();
        if (string.indexOf("EXTERNAL FILE") >= 0) {
            string = this.readLine().trim();
            this.isPolymer = string.equals("1D - POLYMER");
            this.isSlab = string.equals("2D - SLAB");
        } else {
            this.isPolymer = string.equals("POLYMER CALCULATION");
            this.isSlab = string.equals("SLAB CALCULATION");
        }
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("symmetryType", (Object)string);
        if ((this.isPolymer || this.isSlab) && !this.isPrimitive) {
            Logger.error((String)"Cannot use FILTER \"conventional\" with POLYMER or SLAB");
            this.isPrimitive = true;
        }
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("unitCellType", (Object)(this.isPrimitive ? "primitive" : "conventional"));
        if (string.indexOf("MOLECULAR") >= 0) {
            this.doProcessLines = true;
            this.isMolecular = true;
            this.readLine();
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("molecularCalculationPointGroup", (Object)this.line.substring(this.line.indexOf(" OR ") + 4).trim());
            return false;
        }
        if (!this.isPrimitive) {
            this.discardLines(5);
            this.setSpaceGroupName(this.line.indexOf(":") >= 0 ? this.line.substring(this.line.indexOf(":") + 1).trim() : "P1");
        }
        return true;
    }

    private void readCellParams(boolean bl) throws Exception {
        this.directLatticeVectors = null;
        if (bl) {
            this.newAtomSet();
        }
        if (this.isPolymer && !this.isPrimitive) {
            float f = this.parseFloat(this.line.substring(this.line.indexOf("CELL") + 4));
            this.setUnitCell(f, -1.0f, -1.0f, 90.0f, 90.0f, 90.0f);
        } else {
            this.discardLinesUntilContains("GAMMA");
            String[] stringArray = CrystalReader.getTokens((String)this.readLine());
            if (this.isSlab) {
                if (this.isPrimitive) {
                    this.setUnitCell(this.parseFloat(stringArray[0]), this.parseFloat(stringArray[1]), -1.0f, this.parseFloat(stringArray[3]), this.parseFloat(stringArray[4]), this.parseFloat(stringArray[5]));
                } else {
                    this.setUnitCell(this.parseFloat(stringArray[0]), this.parseFloat(stringArray[1]), -1.0f, 90.0f, 90.0f, this.parseFloat(stringArray[2]));
                }
            } else if (this.isPolymer) {
                this.setUnitCell(this.parseFloat(stringArray[0]), -1.0f, -1.0f, this.parseFloat(stringArray[3]), this.parseFloat(stringArray[4]), this.parseFloat(stringArray[5]));
            } else {
                this.setUnitCell(this.parseFloat(stringArray[0]), this.parseFloat(stringArray[1]), this.parseFloat(stringArray[2]), this.parseFloat(stringArray[3]), this.parseFloat(stringArray[4]), this.parseFloat(stringArray[5]));
            }
        }
    }

    private boolean readPrimitiveMapping() throws Exception {
        int n;
        int n2;
        if (this.vInputCoords == null) {
            return false;
        }
        this.havePrimitiveMapping = true;
        BitSet bitSet = new BitSet();
        int n3 = this.vInputCoords.size();
        int[] nArray = new int[n3];
        this.primitiveToIndex = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = -1;
        }
        this.discardLines(3);
        while (this.readLine() != null && this.line.indexOf(" NOT IRREDUCIBLE") >= 0) {
            bitSet.set(this.parseInt(this.line.substring(21, 25)) - 1);
            this.readLine();
        }
        this.discardLines(3);
        n2 = 0;
        int n4 = 0;
        while (this.readLine() != null && this.line.indexOf("NUMBER") < 0) {
            if (this.line.length() == 0) continue;
            ++n4;
            n = this.parseInt(this.line.substring(4, 8)) - 1;
            if (nArray[n] >= 0) continue;
            nArray[n] = n2++;
        }
        if (bitSet.nextSetBit(0) >= 0 && this.vInputCoords != null) {
            n = n3;
            while (--n >= 0) {
                if (!bitSet.get(n)) continue;
                this.vInputCoords.remove(n);
            }
        }
        this.atomCount = this.vInputCoords.size();
        this.primitiveToIndex = new int[n4];
        for (n = 0; n < n4; ++n) {
            this.primitiveToIndex[n] = -1;
        }
        n = this.vInputCoords.size();
        while (--n >= 0) {
            this.line = this.vInputCoords.get(n);
            int n5 = this.parseInt(this.line.substring(0, 4)) - 1;
            n2 = nArray[n5];
            if (n2 < 0) continue;
            this.primitiveToIndex[n2] = n;
        }
        System.out.println(n4 + " primitive atoms " + this.vInputCoords.size() + " conventionalAtoms");
        return true;
    }

    private boolean readFractionalCoords() throws Exception {
        if (this.isMolecular) {
            this.newAtomSet();
        }
        this.readLine();
        this.readLine();
        int n = this.atomIndexLast;
        boolean bl = this.isPrimitive && !this.isMolecular && !this.isPolymer && !this.isSlab && (!this.doApplySymmetry || this.latticeCells[2] != 0);
        this.atomIndexLast = this.atomSetCollection.getAtomCount();
        while (this.readLine() != null && this.line.length() > 0) {
            Atom atom = this.atomSetCollection.addNewAtom();
            String[] stringArray = this.getTokens();
            int n2 = this.getAtomicNumber(stringArray[2]);
            atom.atomName = this.getAtomName(stringArray[3]);
            float f = this.parseFloat(stringArray[4]);
            float f2 = this.parseFloat(stringArray[5]);
            float f3 = this.parseFloat(stringArray[6]);
            if (this.haveCharges) {
                atom.partialCharge = this.atomSetCollection.getAtom((int)n++).partialCharge;
            }
            if (f < 0.0f && (this.isPolymer || this.isSlab || bl)) {
                f += 1.0f;
            }
            if (f2 < 0.0f && (this.isSlab || bl)) {
                f2 += 1.0f;
            }
            if (f3 < 0.0f && bl) {
                f3 += 1.0f;
            }
            this.setAtomCoord(atom, f, f2, f3);
            atom.elementSymbol = CrystalReader.getElementSymbol((int)n2);
        }
        this.atomCount = this.atomSetCollection.getAtomCount() - this.atomIndexLast;
        return true;
    }

    private String getAtomName(String string) {
        String string2 = string;
        if (string2.length() > 1 && Character.isLetter(string2.charAt(1))) {
            string2 = string2.substring(0, 1) + Character.toLowerCase(string2.charAt(1)) + string2.substring(2);
        }
        return string2;
    }

    private int getAtomicNumber(String string) {
        int n;
        for (n = this.parseInt(string); n >= 100; n -= 100) {
        }
        return n;
    }

    private void readCrystallographicCoords() throws Exception {
        this.readLine();
        this.readLine();
        this.vInputCoords = new ArrayList<String>();
        while (this.readLine() != null && this.line.length() > 0) {
            this.vInputCoords.add(this.line);
        }
    }

    private void processInputCoords() throws Exception {
        this.atomCount = this.vInputCoords.size();
        for (int i = 0; i < this.atomCount; ++i) {
            int n;
            int n2;
            Atom atom = this.atomSetCollection.addNewAtom();
            String[] stringArray = CrystalReader.getTokens((String)this.vInputCoords.get(i));
            if (stringArray.length == 7) {
                n2 = this.getAtomicNumber(stringArray[2]);
                n = 2;
            } else {
                n2 = this.getAtomicNumber(stringArray[1]);
                n = 0;
            }
            float f = this.parseFloat(stringArray[2 + n]) + this.ptOriginShift.x;
            float f2 = this.parseFloat(stringArray[3 + n]) + this.ptOriginShift.y;
            float f3 = this.parseFloat(stringArray[4 + n]) + this.ptOriginShift.z;
            this.setAtomCoord(atom, f, f2, f3);
            atom.elementSymbol = CrystalReader.getElementSymbol((int)n2);
        }
        this.vInputCoords = null;
    }

    private void newAtomSet() throws Exception {
        if (this.atomSetCollection.getAtomCount() == 0) {
            return;
        }
        this.applySymmetryAndSetTrajectory();
        this.atomSetCollection.newAtomSet();
    }

    private void readEnergy() {
        this.line = TextFormat.simpleReplace((String)this.line, (String)"( ", (String)"(");
        String[] stringArray = this.getTokens();
        this.energy = Double.parseDouble(stringArray[2]);
        this.setEnergy();
    }

    private void setEnergy() {
        this.atomSetCollection.setAtomSetEnergy("" + this.energy, this.energy.floatValue());
        this.atomSetCollection.setAtomSetAuxiliaryInfo("Energy", (Object)this.energy);
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("Energy", (Object)this.energy);
        this.atomSetCollection.setAtomSetName("Energy = " + this.energy + " Hartree");
    }

    private boolean readPartialCharges() throws Exception {
        if (this.haveCharges || this.atomSetCollection.getAtomCount() == 0) {
            return true;
        }
        this.haveCharges = true;
        this.discardLines(3);
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        int n = this.atomSetCollection.getLastAtomSetAtomIndex();
        int n2 = 0;
        while (this.readLine() != null && this.line.length() > 3) {
            if (this.line.charAt(3) == ' ') continue;
            int n3 = this.getAtomIndexFromPrimitiveIndex(n2);
            if (n3 >= 0) {
                atomArray[n + n3].partialCharge = this.parseFloat(this.line.substring(9, 11)) - this.parseFloat(this.line.substring(12, 18));
            }
            ++n2;
        }
        return true;
    }

    private boolean readTotalAtomicCharges() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.readLine() != null && this.line.indexOf("T") < 0) {
            stringBuffer.append(this.line);
        }
        String[] stringArray = CrystalReader.getTokens((String)stringBuffer.toString());
        float[] fArray = new float[stringArray.length];
        if (this.nuclearCharges == null) {
            this.nuclearCharges = fArray;
        }
        if (this.atomSetCollection.getAtomCount() == 0) {
            return true;
        }
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        int n = this.atomSetCollection.getLastAtomSetAtomIndex();
        for (int i = 0; i < fArray.length; ++i) {
            int n2 = this.getAtomIndexFromPrimitiveIndex(i);
            if (n2 < 0) continue;
            fArray[i] = this.parseFloat(stringArray[i]);
            atomArray[n + n2].partialCharge = this.nuclearCharges[i] - fArray[i];
        }
        return true;
    }

    private int getAtomIndexFromPrimitiveIndex(int n) {
        return this.primitiveToIndex == null ? n : this.primitiveToIndex[n];
    }

    private boolean readFragments() throws Exception {
        int n = this.parseInt(this.line.substring(39, 44));
        if (n < 0) {
            return true;
        }
        this.atomFrag = new int[n];
        String string = "";
        while (this.readLine() != null && this.line.indexOf("(") >= 0) {
            string = string + this.line;
        }
        string = TextFormat.simpleReplace((String)string, (String)"(", (String)" (");
        String[] stringArray = CrystalReader.getTokens((String)string);
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            this.atomFrag[n2] = this.getAtomIndexFromPrimitiveIndex(this.parseInt(stringArray[n3]) - 1);
            ++n2;
            n3 += 5;
        }
        Arrays.sort(this.atomFrag);
        return true;
    }

    private boolean readFrequencies() throws Exception {
        Object object;
        String[] stringArray;
        int n;
        int n2;
        this.discardLinesUntilContains(this.isVersion3 ? "MODES          EV" : "MODES         EIGV");
        this.readLine();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        int n3 = this.atomCount;
        while (this.readLine() != null && this.line.length() > 0) {
            n2 = this.parseInt(this.line.substring(1, 5));
            n = this.parseInt(this.line.substring(6, 10));
            stringArray = this.line.substring(49, 52).trim();
            object = this.line.substring(59, 69).replace(')', ' ').trim();
            if (object == null) {
                object = "not available";
            }
            String string = this.line.substring(55, 58).trim();
            String string2 = this.line.substring(71, 73).trim();
            String[] stringArray2 = new String[]{stringArray, object, string, string2};
            for (int i = n2; i <= n; ++i) {
                arrayList.add(stringArray2);
            }
        }
        this.discardLinesUntilContains(this.isVersion3 ? "THE CORRESPONDING MODES" : "NORMAL MODES NORMALIZED TO CLASSICAL AMPLITUDES");
        this.readLine();
        n2 = -1;
        while (this.readLine() != null && this.line.startsWith(" FREQ(CM**-1)")) {
            n = 0;
            stringArray = CrystalReader.getTokens((String)this.line.substring(15));
            this.frequencies = new float[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                float f;
                this.frequencies[n] = f = this.parseFloat(stringArray[i]);
                ++n;
                if (!Logger.debugging) continue;
                Logger.debug((String)(this.vibrationNumber + 1 + " frequency=" + f));
            }
            object = new boolean[n];
            int n4 = 0;
            for (int i = 0; i < n; ++i) {
                this.data = (String[])arrayList.get(this.vibrationNumber);
                object[i] = !this.doGetVibration(++this.vibrationNumber) || this.data == null;
                if (object[i] != false) continue;
                n2 = this.cloneLastAtomSet(this.atomCount);
                if (i == 0) {
                    n4 = this.atomSetCollection.getLastAtomSetAtomIndex();
                }
                this.setFreqValue(i);
            }
            this.readLine();
            this.fillFrequencyData(n4, n3, n2, (boolean[])object, false, 14, 10, this.atomFrag);
            this.readLine();
        }
        return true;
    }

    private void setFreqValue(int n) {
        String string = "IR: " + this.data[2] + ", Ram.: " + this.data[3];
        this.atomSetCollection.setAtomSetFrequency(null, string, "" + this.frequencies[n], null);
        this.atomSetCollection.setAtomSetProperty("IRintensity", this.data[1] + " km/Mole");
        this.atomSetCollection.setAtomSetProperty("vibrationalSymmetry", this.data[0]);
        this.atomSetCollection.setAtomSetProperty("IRactivity", this.data[2]);
        this.atomSetCollection.setAtomSetProperty("Ramanactivity", this.data[3]);
        this.atomSetCollection.setAtomSetName(this.data[0] + " " + TextFormat.formatDecimal((float)this.frequencies[n], (int)2) + " cm-1 (" + TextFormat.formatDecimal((float)Float.parseFloat(this.data[1]), (int)0) + " km/Mole), " + string);
    }
}

