/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.simple;

import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.api.JmolAdapter;

public class V3000Reader
extends AtomSetCollectionReader {
    private int headerAtomCount;
    private int headerBondCount;

    protected boolean checkLine() throws Exception {
        if (!this.doGetModel(++this.modelNumber)) {
            this.discardLinesUntilContains("$$$$");
            return this.checkLastModel();
        }
        this.processCtab();
        return true;
    }

    private void processCtab() throws Exception {
        while (this.readLine() != null && !this.line.startsWith("$$$$") && !this.line.startsWith("M  END")) {
            if (this.line.startsWith("M  V30 BEGIN ATOM")) {
                this.processAtomBlock();
                continue;
            }
            if (this.line.startsWith("M  V30 BEGIN BOND")) {
                this.processBondBlock();
                continue;
            }
            if (this.line.startsWith("M  V30 BEGIN CTAB")) {
                this.newAtomSet("");
                continue;
            }
            if (!this.line.startsWith("M  V30 COUNTS")) continue;
            this.headerAtomCount = this.parseInt(this.line, 13);
            this.headerBondCount = this.parseInt();
        }
        if (this.line != null && !this.line.startsWith("$$$$")) {
            this.discardLinesUntilStartsWith("$$$$");
        }
    }

    private String processAtomBlock() throws Exception {
        int n = this.headerAtomCount;
        while (--n >= 0) {
            this.readLineWithContinuation();
            if (this.line == null || !this.line.startsWith("M  V30 ")) {
                throw new Exception("unrecognized atom");
            }
            Atom atom = new Atom();
            String[] stringArray = this.getTokens();
            atom.atomSerial = this.parseInt(stringArray[2]);
            atom.elementSymbol = stringArray[3];
            atom.set(this.parseFloat(stringArray[4]), this.parseFloat(stringArray[5]), this.parseFloat(stringArray[6]));
            for (int i = 8; i < stringArray.length; ++i) {
                int n2;
                String string = stringArray[i];
                if (string.startsWith("CHG=")) {
                    n2 = this.parseInt(string, 4);
                    atom.formalCharge = n2 > 3 ? 4 - n2 : n2;
                    break;
                }
                if (!string.startsWith("MASS=")) continue;
                n2 = this.parseInt(string, 5);
                atom.elementNumber = (short)((n2 << 7) + JmolAdapter.getElementNumber((String)atom.elementSymbol));
            }
            this.atomSetCollection.addAtomWithMappedSerialNumber(atom);
        }
        this.readLine();
        if (this.line == null || !this.line.startsWith("M  V30 END ATOM")) {
            throw new Exception("M  V30 END ATOM not found");
        }
        return this.line;
    }

    private void processBondBlock() throws Exception {
        int n = this.headerBondCount;
        while (--n >= 0) {
            this.readLineWithContinuation();
            if (this.line == null || !this.line.startsWith("M  V30 ")) {
                throw new Exception("unrecognized bond");
            }
            this.parseInt(this.line, 7);
            int n2 = this.parseInt();
            int n3 = this.parseInt();
            int n4 = this.parseInt();
            this.atomSetCollection.addNewBondWithMappedSerialNumbers(n3, n4, n2);
        }
        this.readLine();
        if (this.line == null || !this.line.startsWith("M  V30 END BOND")) {
            throw new Exception("M  V30 END BOND not found");
        }
    }

    private void readLineWithContinuation() throws Exception {
        this.readLine();
        if (this.line != null && this.line.length() > 7) {
            while (this.line.charAt(this.line.length() - 1) == '-') {
                String string = this.readLine();
                if (string == null || !this.line.startsWith("M  V30 ")) {
                    throw new Exception("Invalid line continuation");
                }
                this.line = this.line + string.substring(7);
            }
        }
    }
}

