// Copyright (c) 2023, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'dart:developer';
import 'package:vm_service/vm_service.dart';

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart <test.dart>
//
const LINE_A = 25;
const LINE_B = 28;
const LINE_C = 34;
const LINE_D = 42;
const LINE_E = 46;
// AUTOGENERATED END

void topLevel<S>() {
  debugger(); // LINE_A

  void inner1<TBool, TString, TDouble, TInt>(TInt x) {
    debugger(); // LINE_B
  }

  inner1<bool, String, double, int>(3);

  void inner2() {
    debugger(); // LINE_C
  }

  inner2();
}

class A {
  void foo<T, S>() {
    debugger(); // LINE_D
  }

  void bar<T>(T t) {
    debugger(); // LINE_E
  }
}

void testMain() {
  topLevel<String>();
  A().foo<int, bool>();
  A().bar<dynamic>(42);
}

final tests = <IsolateTest>[
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_A),
  (VmService service, IsolateRef isolateRef) async {
    final isolateId = isolateRef.id!;
    await evaluateInFrameAndExpect(
      service,
      isolateId,
      'S.toString()',
      'String',
    );
  },
  resumeIsolate,
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_B),
  (VmService service, IsolateRef isolateRef) async {
    final isolateId = isolateRef.id!;
    await evaluateInFrameAndExpect(
      service,
      isolateId,
      'TBool.toString()',
      'bool',
    );
    await evaluateInFrameAndExpect(
      service,
      isolateId,
      'S.toString()',
      'String',
    );
    await evaluateInFrameAndExpect(
      service,
      isolateId,
      'TString.toString()',
      'String',
    );
    await evaluateInFrameAndExpect(
      service,
      isolateId,
      'TDouble.toString()',
      'double',
    );
    await evaluateInFrameAndExpect(
      service,
      isolateId,
      'TInt.toString()',
      'int',
    );
    await evaluateInFrameAndExpect(
      service,
      isolateId,
      'x',
      '3',
    );
  },
  resumeIsolate,
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_C),
  (VmService service, IsolateRef isolateRef) async {
    final isolateId = isolateRef.id!;
    await evaluateInFrameAndExpect(
      service,
      isolateId,
      'S.toString()',
      'String',
    );
  },
  resumeIsolate,
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_D),
  (VmService service, IsolateRef isolateRef) async {
    final isolateId = isolateRef.id!;
    await evaluateInFrameAndExpect(
      service,
      isolateId,
      'T.toString()',
      'int',
    );
    await evaluateInFrameAndExpect(
      service,
      isolateId,
      'S.toString()',
      'bool',
    );
  },
  resumeIsolate,
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_E),
  (VmService service, IsolateRef isolateRef) async {
    final isolateId = isolateRef.id!;
    await evaluateInFrameAndExpect(
      service,
      isolateId,
      'T.toString()',
      'dynamic',
    );
    await evaluateInFrameAndExpect(
      service,
      isolateId,
      't',
      '42',
    );
  },
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'evaluate_function_type_parameters_test.dart',
      testeeConcurrent: testMain,
    );
