###############################################################################
#                                                                             #
# Copyright (C) 2013 Edward d'Auvergne                                        #
#                                                                             #
# This file is part of the program relax (http://www.nmr-relax.com).          #
#                                                                             #
# This program is free software: you can redistribute it and/or modify        #
# it under the terms of the GNU General Public License as published by        #
# the Free Software Foundation, either version 3 of the License, or           #
# (at your option) any later version.                                         #
#                                                                             #
# This program is distributed in the hope that it will be useful,             #
# but WITHOUT ANY WARRANTY; without even the implied warranty of              #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               #
# GNU General Public License for more details.                                #
#                                                                             #
# You should have received a copy of the GNU General Public License           #
# along with this program.  If not, see <http://www.gnu.org/licenses/>.       #
#                                                                             #
###############################################################################

# Module docstring.
"""Module for handling Python lists."""


def count_unique_elements(values=None):
    """Count the number of unique instances in the given list.

    @keyword values:    The original list.
    @type values:       list
    @return:            The number of unique instances.
    @rtype:             int
    """

    # Create a new list.
    new_list = unique_elements(values=values)

    # The number.
    return len(new_list)


def unique_elements(values=None):
    """Return a new list with duplicates removed.

    @keyword values:    The original list.
    @type values:       list
    @return:            The new list with duplicates removed.
    @rtype:             list
    """

    # Create a new list.
    new_list = []
    for i in values:
        if i not in new_list:
            new_list.append(i)

    # Return the new list.
    return new_list
