/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.ivy.plugins.repository.AbstractRepository;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.resolver.AbstractPatternsBasedResolver;
import org.apache.ivy.plugins.resolver.ResolverSettings;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.plugins.resolver.util.ResolverHelper;
import org.apache.ivy.plugins.resolver.util.ResourceMDParser;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.Message;

public class RepositoryResolver
extends AbstractPatternsBasedResolver {
    private Repository repository;
    private Boolean alwaysCheckExactRevision = null;
    private String signerName = null;

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        if (this.repository instanceof AbstractRepository) {
            ((AbstractRepository)this.repository).setName(string);
        }
    }

    @Override
    protected ResolvedResource findResourceUsingPattern(ModuleRevisionId moduleRevisionId, String string, Artifact artifact, ResourceMDParser object, Date object2) {
        String string2 = this.getName();
        VersionMatcher versionMatcher = this.getSettings().getVersionMatcher();
        try {
            if (!versionMatcher.isDynamic(moduleRevisionId) || this.isAlwaysCheckExactRevision()) {
                Object object3 = IvyPatternHelper.substitute(string, moduleRevisionId, artifact);
                Message.debug("\t trying " + (String)object3);
                this.logAttempt((String)object3);
                object3 = this.repository.getResource((String)object3);
                boolean bl = object3.exists();
                if (bl) {
                    if (string.indexOf("revision") == -1) {
                        if ("ivy".equals(artifact.getType()) || "pom".equals(artifact.getType())) {
                            object = File.createTempFile("ivy", artifact.getExt());
                            ((File)object).deleteOnExit();
                            this.repository.get(object3.getName(), (File)object);
                            object2 = ModuleDescriptorParserRegistry.getInstance().getParser((Resource)object3);
                            object = object2.parseDescriptor(this.getParserSettings(), ((File)object).toURI().toURL(), (Resource)object3, false);
                            object = object.getRevision();
                            if (object == null || ((String)object).length() == 0) {
                                object = "working@" + string2;
                            }
                        } else {
                            object = "working@" + string2;
                        }
                    } else {
                        object = moduleRevisionId.getRevision();
                    }
                    return new ResolvedResource((Resource)object3, (String)object);
                }
                if (versionMatcher.isDynamic(moduleRevisionId)) {
                    return this.findDynamicResourceUsingPattern((ResourceMDParser)object, moduleRevisionId, string, artifact, (Date)object2);
                }
                Message.debug("\t" + string2 + ": resource not reachable for " + moduleRevisionId + ": res=" + object3);
                return null;
            }
            return this.findDynamicResourceUsingPattern((ResourceMDParser)object, moduleRevisionId, string, artifact, (Date)object2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(string2 + ": unable to get resource for " + moduleRevisionId + ": res=" + IvyPatternHelper.substitute(string, moduleRevisionId, artifact) + ": " + iOException, iOException);
        }
        catch (ParseException parseException) {
            throw new RuntimeException(string2 + ": unable to get resource for " + moduleRevisionId + ": res=" + IvyPatternHelper.substitute(string, moduleRevisionId, artifact) + ": " + parseException, parseException);
        }
    }

    private ResolvedResource findDynamicResourceUsingPattern(ResourceMDParser object, ModuleRevisionId moduleRevisionId, String string, Artifact resolvedResourceArray, Date date) {
        String string2 = this.getName();
        this.logAttempt(IvyPatternHelper.substitute(string, ModuleRevisionId.newInstance(moduleRevisionId, IvyPatternHelper.getTokenString("revision")), (Artifact)resolvedResourceArray));
        RepositoryResolver repositoryResolver = this;
        resolvedResourceArray = repositoryResolver.listResources(repositoryResolver.repository, moduleRevisionId, string, (Artifact)resolvedResourceArray);
        if (resolvedResourceArray == null) {
            Message.debug("\t" + string2 + ": unable to list resources for " + moduleRevisionId + ": pattern=" + string);
            return null;
        }
        if ((object = this.findResource(resolvedResourceArray, (ResourceMDParser)object, moduleRevisionId, date)) == null) {
            Message.debug("\t" + string2 + ": no resource found for " + moduleRevisionId + ": pattern=" + string);
        }
        return object;
    }

    protected ResolvedResource[] listResources(Repository repository, ModuleRevisionId moduleRevisionId, String string, Artifact artifact) {
        return ResolverHelper.findAll(repository, moduleRevisionId, string, artifact);
    }

    @Override
    protected long get(Resource resource, File file) throws IOException {
        Message.verbose("\t" + this.getName() + ": downloading " + resource.getName());
        Message.debug("\t\tto " + file);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        this.repository.get(resource.getName(), file);
        return file.length();
    }

    @Override
    public DownloadReport download(Artifact[] object, DownloadOptions downloadOptions) {
        EventManager eventManager = this.getEventManager();
        try {
            if (eventManager != null) {
                this.repository.addTransferListener(eventManager);
            }
            object = super.download((Artifact[])object, downloadOptions);
            return object;
        }
        finally {
            if (eventManager != null) {
                this.repository.removeTransferListener(eventManager);
            }
        }
    }

    @Override
    public String getTypeName() {
        return "repository";
    }

    @Override
    public void dumpSettings() {
        super.dumpSettings();
        Message.debug("\t\trepository: " + this.getRepository());
    }

    @Override
    public void setSettings(ResolverSettings resolverSettings) {
        super.setSettings(resolverSettings);
        if (resolverSettings != null && this.alwaysCheckExactRevision == null) {
            this.alwaysCheckExactRevision = Boolean.valueOf(resolverSettings.getVariable("ivy.default.always.check.exact.revision"));
        }
    }

    public boolean isAlwaysCheckExactRevision() {
        if (this.alwaysCheckExactRevision == null) {
            return true;
        }
        return this.alwaysCheckExactRevision;
    }
}

